/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteFile;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.process.CapturingSshProcessHandler;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.ZipUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkSessionUtil;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.remote.PyHelpersDownload;
import com.jetbrains.python.remote.PyHelpersUpload;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteProcessHandler;
import com.jetbrains.python.remote.PyRemoteProcessUtil;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSdkCredentials;
import com.jetbrains.python.remote.PyRemoteSkeletonGeneratorWithRemoteSources;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProviderFactory;
import com.jetbrains.python.remote.PyRemoteSourceItem;
import com.jetbrains.python.remote.PySshCommandLineStateUtil;
import com.jetbrains.python.remote.PySshInterpreterBundle;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.skeletons.LineWiseProcessOutputListener;
import java.awt.Component;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PyRemoteSkeletonGenerator
extends PyRemoteSkeletonGeneratorWithRemoteSources {
    @Nullable
    private final Component myOwnerComponent;
    private final PyRemoteSdkCredentials myRemoteSdkData;

    PyRemoteSkeletonGenerator(@Nullable Project project, @Nullable Component ownerComponent, String skeletonsPath, Sdk sdk) throws ExecutionException {
        super(skeletonsPath, sdk, null, project);
        this.myOwnerComponent = ownerComponent;
        try {
            this.myRemoteSdkData = this.getRemoteSdkAdditionalData().getRemoteSdkCredentials(false);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Couldn't get remote credentials", e);
        }
    }

    @Override
    public void prepare() {
        ListenableFuture<?> future2 = PyHelpersUpload.uploadAllHelpers(this.myProject, null, this.myRemoteSdkData, false);
        try {
            future2.get();
        }
        catch (Exception e) {
            LOG.error("Helpers upload failed", (Throwable)e);
        }
    }

    @Override
    protected ProcessOutput getProcessOutput(String homePath, String @NotNull [] commandLine, @Nullable String stdin, @NotNull Map<String, String> extraEnv, int timeout) throws InvalidSdkException {
        if (extraEnv == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(1);
        }
        return this.runProcessWithOptionalLineOutputListener(homePath, Arrays.asList(commandLine), stdin, null);
    }

    @Override
    @NotNull
    protected ProcessOutput runProcessWithLineOutputListener(@NotNull String homePath, @NotNull List<String> cmd, @NotNull Map<String, String> env, @Nullable String stdin, int timeout, @NotNull LineWiseProcessOutputListener listener2) throws ExecutionException, InvalidSdkException {
        if (homePath == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(2);
        }
        if (cmd == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(3);
        }
        if (env == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(4);
        }
        if (listener2 == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(5);
        }
        return this.runProcessWithOptionalLineOutputListener(homePath, cmd, stdin, listener2);
    }

    @NotNull
    private ProcessOutput runProcessWithOptionalLineOutputListener(@NotNull String homePath, @NotNull List<String> cmd, @Nullable String stdin, @Nullable LineWiseProcessOutputListener listener2) throws InvalidSdkException {
        ProcessOutput processOutput;
        if (homePath == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(6);
        }
        if (cmd == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(7);
        }
        String[] commandLine = PyRemoteSkeletonGenerator.addUnbuffered(homePath, ArrayUtil.toStringArray(cmd));
        PyRemoteSdkCredentials data = this.myRemoteSdkData;
        try {
            PyRemotePathMapper pathMapper = this.createPathMappings(this.myProject, this.getRemoteSdkAdditionalData());
            ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)data, (Project)this.myProject);
            RemoteSdkSessionUtil.checkConnection((ConnectionBuilder)connectionBuilder, (Project)this.myProject);
            CapturingSshProcessHandler handler = PyRemoteProcessUtil.getProcessHandler(connectionBuilder, data, pathMapper, commandLine, null, false);
            if (listener2 != null) {
                handler.addProcessListener((ProcessListener)new LineWiseProcessOutputListener.Adapter(listener2));
            }
            if (stdin != null) {
                PyRemoteSkeletonGenerator.sendLineToProcessInput(handler, stdin);
            }
            processOutput = handler.runProcess();
        }
        catch (ExecutionException e) {
            throw new InvalidSdkException(e.getMessage(), e);
        }
        if (processOutput == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(8);
        }
        return processOutput;
    }

    @Override
    public void finishSkeletonsGeneration() {
    }

    @NotNull
    private ProcessHandler getProcessHandler(@Nullable Project project, @NotNull GeneralCommandLine commandLine) throws InvalidSdkException {
        if (commandLine == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(9);
        }
        try {
            assert (this.mySdk.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalDataBase);
            return PyRemoteSkeletonGenerator.startRemoteProcessImpl(project, this.myRemoteSdkData, commandLine, this.createPathMappings(project, (PyRemoteSdkAdditionalDataBase)this.mySdk.getSdkAdditionalData()));
        }
        catch (RemoteSdkException e) {
            throw new InvalidSdkException("Error running SDK");
        }
    }

    @NotNull
    private static PyRemoteProcessHandler startRemoteProcessImpl(@Nullable Project project, @NotNull PyRemoteSdkCredentials data, @NotNull GeneralCommandLine commandLine, @NotNull PyRemotePathMapper pathMapper) throws RemoteSdkException {
        if (data == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(10);
        }
        if (commandLine == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(11);
        }
        if (pathMapper == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(12);
        }
        ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)data, (Project)project);
        RemoteSdkSessionUtil.checkConnection((ConnectionBuilder)connectionBuilder, (Project)project);
        PyRemoteProcessUtil.uploadAllHelpers(data, project);
        PyRemoteSocketToLocalHostProvider sshRemoteSocketProvider = PyRemoteSocketToLocalHostProviderFactory.ssh(connectionBuilder, data);
        PySshCommandLineStateUtil.patchCommandLineForSshSession(commandLine, data, pathMapper, sshRemoteSocketProvider);
        commandLine.setExePath(data.getInterpreterPath());
        SshExecProcess process2 = RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder, (GeneralCommandLine)commandLine).withAllocatePty(true).start();
        PyRemoteProcessHandler pyRemoteProcessHandler = PyRemoteProcessHandler.createProcessHandler((RemoteProcess)process2, data, commandLine, pathMapper, sshRemoteSocketProvider);
        if (pyRemoteProcessHandler == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(13);
        }
        return pyRemoteProcessHandler;
    }

    @NotNull
    private GeneralCommandLine createZipSourcesCommandLine() {
        GeneralCommandLine cmd = new GeneralCommandLine(new String[]{this.mySdk.getHomePath()});
        cmd.getParametersList().addParamsGroup("Exe Options");
        ParamsGroup group2 = cmd.getParametersList().addParamsGroup("Script");
        group2.addParameters(new String[]{PythonHelpersLocator.getHelperPath("generator3/__main__.py"), "-z", this.getSkeletonsPath()});
        GeneralCommandLine generalCommandLine = cmd;
        if (generalCommandLine == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(14);
        }
        return generalCommandLine;
    }

    private static void extractSources(File arc, String localPath) throws IOException {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        indicator.setText(PySshInterpreterBundle.message("ssh.interpreter.skeletons.extracting.contents.indicator.text", arc.getPath()));
        CountingFilenameFilter countingFilenameFilter = new CountingFilenameFilter();
        ZipUtil.extract((File)arc, (File)new File(localPath), (FilenameFilter)countingFilenameFilter);
        LOG.info("Extracted " + countingFilenameFilter.myCount + " files from skeletons zip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendSourcesToCompressList(@NotNull Collection<PyRemoteSourceItem> list, @NotNull ProcessHandler process2) {
        if (list == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(15);
        }
        if (process2 == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(16);
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        try (PrintWriter w = new PrintWriter(process2.getProcessInput());){
            for (PyRemoteSourceItem sourceItem : list) {
                indicator.setText(PySshInterpreterBundle.message("ssh.interpreter.skeletons.compressing.module.indicator.text", sourceItem.getModule()));
                String arcPath = sourceItem.getArcPath();
                arcPath = StringUtil.trimStart((String)arcPath, (String)"/");
                w.println(sourceItem.getPath() + " " + arcPath);
            }
            w.println("-");
            w.flush();
        }
    }

    @Override
    protected String getRemoteSkeletonsPath() {
        String sdkHomePath = this.mySdk.getHomePath();
        assert (sdkHomePath != null);
        return RemoteFile.detectSystemByPath((String)sdkHomePath).createRemoteFile(PythonSdkUtil.getSkeletonsPath(this.myRemoteSdkData.getHelpersPath(), sdkHomePath)).getPath();
    }

    @Override
    protected void downloadSourcesToLocalFolder(@NotNull String localPath, @NotNull Collection<PyRemoteSourceItem> sourcesToDownload) throws InvalidSdkException {
        if (localPath == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(17);
        }
        if (sourcesToDownload == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(18);
        }
        final Ref zipTransfer = Ref.create((Object)false);
        final Ref zipSourceItem = Ref.create(null);
        GeneralCommandLine cmd = this.createZipSourcesCommandLine();
        long compressingStartedInNanos = System.nanoTime();
        ProcessHandler process2 = this.getProcessHandler(this.myProject, cmd);
        final Semaphore semaphore = new Semaphore(0);
        final StringBuilder output = new StringBuilder();
        process2.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event2, @NotNull Key outputType) {
                if (event2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                String text2 = event2.getText();
                output.append(text2);
                if (text2.startsWith("OK: ")) {
                    text2 = text2.substring(4).trim();
                    zipSourceItem.set((Object)new PyRemoteSourceItem(text2, new File(text2).getParent(), 0));
                }
            }

            public void processTerminated(@NotNull ProcessEvent event2) {
                if (event2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                LOG.info("Remote zip process terminated with exit code " + event2.getExitCode());
                if (event2.getExitCode() != 0) {
                    zipTransfer.set((Object)false);
                } else {
                    zipTransfer.set((Object)true);
                }
                semaphore.release(1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/remote/PyRemoteSkeletonGenerator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        process2.startNotify();
        LOG.info("Compressing " + sourcesToDownload.size() + " source files");
        PyRemoteSkeletonGenerator.sendSourcesToCompressList(sourcesToDownload, process2);
        process2.waitFor(2000L);
        try {
            while (!process2.isProcessTerminated() && !semaphore.tryAcquire(120L, TimeUnit.SECONDS)) {
                long durationInMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - compressingStartedInNanos);
                LOG.info("Still compressing source files during " + StringUtil.formatDuration((long)durationInMillis) + "...");
            }
        }
        catch (InterruptedException e) {
            zipTransfer.set((Object)false);
        }
        if (((Boolean)zipTransfer.get()).booleanValue()) {
            try {
                PyRemoteSourceItem remoteZip = (PyRemoteSourceItem)zipSourceItem.get();
                String name = new File(remoteZip.getPath()).getName();
                File zipFile = new File(localPath, name);
                FileUtil.delete((File)zipFile);
                LOG.info("Downloading zipped sources and localSourcesFile: " + remoteZip.getPath());
                this.transferSources(Lists.newArrayList((Object[])new PyRemoteSourceItem[]{remoteZip}), localPath);
                LOG.info("Extracting downloaded zipped sources and localSourcesFile: " + zipFile.getPath());
                PyRemoteSkeletonGenerator.extractSources(zipFile, localPath);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                zipTransfer.set((Object)false);
            }
        }
        if (!((Boolean)zipTransfer.get()).booleanValue()) {
            LOG.warn("Problems with compressing sources:\n" + output.toString());
            try {
                this.transferSources(sourcesToDownload, localPath);
            }
            catch (Exception e) {
                LOG.error("Can't copy sources ", (Throwable)e);
            }
        }
    }

    private void transferSources(@NotNull Collection<PyRemoteSourceItem> sources, @NotNull String localFolder) throws FileSystemException {
        if (sources == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(19);
        }
        if (localFolder == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(20);
        }
        PyHelpersDownload.transferSources(this.mySdk, this.myProject, this.myOwnerComponent, this.myRemoteSdkData, sources, localFolder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraEnv";
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyRemoteSkeletonGenerator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcesToDownload";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyRemoteSkeletonGenerator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcessWithOptionalLineOutputListener";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "startRemoteProcessImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createZipSourcesCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithLineOutputListener";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithOptionalLineOutputListener";
                break;
            }
            case 8: 
            case 13: 
            case 14: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getProcessHandler";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "startRemoteProcessImpl";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sendSourcesToCompressList";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "downloadSourcesToLocalFolder";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "transferSources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CountingFilenameFilter
    implements FilenameFilter {
        private int myCount = 0;

        private CountingFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            ++this.myCount;
            return true;
        }
    }
}

