/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.gherkin.behave;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.QualifiedName;
import com.intellij.refactoring.RefactoringFactory;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.jetbrains.python.gherkin.PyBDDBundle;
import com.jetbrains.python.gherkin.behave.PyBehaveFunctionNames;
import com.jetbrains.python.gherkin.behave.PyBehaveFunctionParameters;
import com.jetbrains.python.gherkin.behave.PyBehaveJvmExtensionPoint;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.quickfix.PyAddImportFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyBehaveInspection
extends PyInspection {
    private static final String SUPPORTED_MATCHER = "re";
    @NotNull
    private final PyBehaveJvmExtensionPoint myBehave = new PyBehaveJvmExtensionPoint();

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file2 == null) {
            PyBehaveInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            PyBehaveInspection.$$$reportNull$$$0(1);
        }
        TypeEvalContext context = TypeEvalContext.deepCodeInsight(file2.getProject());
        if (!(file2 instanceof PyFile)) {
            return null;
        }
        PyFile pyFile = (PyFile)file2;
        if (!this.myBehave.isFrameworkStepDefinition(pyFile, context)) {
            return null;
        }
        if (!PyBehaveInspection.hasFromBehaveImportStar(pyFile)) {
            return new ProblemDescriptor[]{new ProblemDescriptorBase((PsiElement)file2, (PsiElement)file2, PyBDDBundle.message("com.jetbrains.python.gherkin.inspections.behave.no_star_import", new Object[0]), new LocalQuickFix[]{new PyAddImportFix(String.format("from %s import *", "behave"), pyFile)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, true, false)};
        }
        ArrayList<ProblemDescriptor> problemDescriptorList = new ArrayList<ProblemDescriptor>();
        PyBehaveInspection.ensureCorrectStepsFolderName(file2, problemDescriptorList);
        if (problemDescriptorList.isEmpty()) {
            return null;
        }
        return problemDescriptorList.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static boolean hasFromBehaveImportStar(@NotNull PyFile pyFile) {
        if (pyFile == null) {
            PyBehaveInspection.$$$reportNull$$$0(2);
        }
        boolean hasFromBehaveImportStar = false;
        QualifiedName packageTopFind = QualifiedName.fromComponents((String[])new String[]{"behave"});
        for (PyFromImportStatement statement : pyFile.getFromImports()) {
            if (statement.getStarImportElement() == null || !packageTopFind.equals((Object)statement.getImportSourceQName())) continue;
            hasFromBehaveImportStar = true;
            break;
        }
        return hasFromBehaveImportStar;
    }

    private static void ensureCorrectStepsFolderName(@NotNull PsiFile file2, @NotNull Collection<ProblemDescriptor> problemDescriptorList) {
        PsiDirectory fileDirectory;
        String dirName;
        if (file2 == null) {
            PyBehaveInspection.$$$reportNull$$$0(3);
        }
        if (problemDescriptorList == null) {
            PyBehaveInspection.$$$reportNull$$$0(4);
        }
        if (!(dirName = (fileDirectory = file2.getContainingDirectory()).getName()).equals("steps")) {
            PsiDirectory fileGrandDirectory = fileDirectory.getParent();
            if (fileGrandDirectory == null) {
                return;
            }
            PsiDirectory realStepsFolder = fileGrandDirectory.findSubdirectory("steps");
            Object fix = realStepsFolder != null ? new PyBehaveMoveToFix(realStepsFolder) : new PyBehaveRenameFolderFix();
            problemDescriptorList.add((ProblemDescriptor)new ProblemDescriptorBase((PsiElement)file2, (PsiElement)file2, PyBDDBundle.message("com.jetbrains.python.gherkin.inspections.behave.folder.wrong_folder", dirName), new LocalQuickFix[]{fix}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, true, false));
        }
    }

    private static void addNewStepMatcherCall(@NotNull PyFile file2) {
        List<PyImportStatementBase> block;
        if (file2 == null) {
            PyBehaveInspection.$$$reportNull$$$0(5);
        }
        if ((block = file2.getImportBlock()).isEmpty()) {
            return;
        }
        PyImportStatementBase lastImport = block.get(block.size() - 1);
        PyElementGenerator instance = PyElementGenerator.getInstance(file2.getProject());
        PyCallExpression expression = instance.createCallExpression(LanguageLevel.forElement((PsiElement)lastImport), PyBehaveFunctionNames.USE_STEP_MATCHER.getExpectedName());
        PyBehaveInspection.addMatcherArgument(expression);
        file2.addAfter((PsiElement)expression, (PsiElement)lastImport);
    }

    private static void addMatcherArgument(@NotNull PyCallExpression expression) {
        if (expression == null) {
            PyBehaveInspection.$$$reportNull$$$0(6);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(expression.getProject());
        PyArgumentList argumentList = expression.getArgumentList();
        if (argumentList != null) {
            argumentList.addArgument(generator.createStringLiteralFromString(SUPPORTED_MATCHER));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptorList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/gherkin/behave/PyBehaveInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasFromBehaveImportStar";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureCorrectStepsFolderName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addNewStepMatcherCall";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addMatcherArgument";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PyBehaveMoveToFix
    implements LocalQuickFix {
        @NotNull
        private final SmartPsiElementPointer<PsiDirectory> myDestination;

        PyBehaveMoveToFix(@NotNull PsiDirectory folder) {
            if (folder == null) {
                PyBehaveMoveToFix.$$$reportNull$$$0(0);
            }
            this.myDestination = SmartPointerManager.createPointer((PsiElement)folder);
        }

        @NotNull
        public String getFamilyName() {
            String string = PyBDDBundle.message("com.jetbrains.python.gherkin.inspections.behave.folder.fix_move", new Object[0]);
            if (string == null) {
                PyBehaveMoveToFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                PyBehaveMoveToFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                PyBehaveMoveToFix.$$$reportNull$$$0(3);
            }
            PsiFile fileToMove = descriptor2.getPsiElement().getContainingFile();
            new MoveFilesOrDirectoriesProcessor(project, new PsiElement[]{fileToMove}, (PsiDirectory)this.myDestination.getElement(), true, true, true, null, null).run();
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "folder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/gherkin/behave/PyBehaveInspection$PyBehaveMoveToFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/gherkin/behave/PyBehaveInspection$PyBehaveMoveToFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PyBehaveRenameFolderFix
    implements LocalQuickFix {
        private PyBehaveRenameFolderFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PyBDDBundle.message("com.jetbrains.python.gherkin.inspections.behave.folder.fix_rename", new Object[0]);
            if (string == null) {
                PyBehaveRenameFolderFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                PyBehaveRenameFolderFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                PyBehaveRenameFolderFix.$$$reportNull$$$0(2);
            }
            PsiDirectory directoryToRename = descriptor2.getPsiElement().getContainingFile().getContainingDirectory();
            RefactoringFactory.getInstance((Project)project).createRename((PsiElement)directoryToRename, "steps").run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/gherkin/behave/PyBehaveInspection$PyBehaveRenameFolderFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/gherkin/behave/PyBehaveInspection$PyBehaveRenameFolderFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PyBehaveReMatcherFix
    implements LocalQuickFix {
        private PyBehaveReMatcherFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PyBDDBundle.message("com.jetbrains.python.gherkin.inspections.behave.matcher.fix", new Object[0]);
            if (string == null) {
                PyBehaveReMatcherFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            if (project == null) {
                PyBehaveReMatcherFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                PyBehaveReMatcherFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor2.getPsiElement()) instanceof PyCallExpression) {
                PsiElement argument;
                PyCallExpression expression = (PyCallExpression)element;
                PyArgumentList argumentList = expression.getArgumentList();
                if (argumentList != null && (argument = expression.getArgument(PyBehaveFunctionParameters.MATCHER_NAME, PsiElement.class)) != null) {
                    argument.delete();
                }
                PyBehaveInspection.addMatcherArgument(expression);
                return;
            }
            PyFile file2 = (PyFile)element.getContainingFile();
            PyBehaveInspection.addNewStepMatcherCall(file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/gherkin/behave/PyBehaveInspection$PyBehaveReMatcherFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/gherkin/behave/PyBehaveInspection$PyBehaveReMatcherFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

