/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.remote.vfs;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.debugger.remote.ui.PyMappingSimpleResolveDialog;
import com.jetbrains.python.remote.PyRemotePathMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public abstract class PyPathMapper {
    public static final Pattern WINDOWS_VOLUME_NAME = Pattern.compile("([A-Za-z]:)[/\\\\](.*)");

    public static String @NotNull [] getPath(@NotNull String originalPath) {
        String path;
        if (originalPath == null) {
            PyPathMapper.$$$reportNull$$$0(0);
        }
        ArrayList<String> pathList = new ArrayList<String>();
        Matcher windowsVolumeMatcher = WINDOWS_VOLUME_NAME.matcher(originalPath);
        if (windowsVolumeMatcher.matches()) {
            pathList.add(windowsVolumeMatcher.group(1));
            path = windowsVolumeMatcher.group(2);
        } else {
            path = originalPath;
        }
        StringTokenizer st = new StringTokenizer(path, "/\\");
        while (st.hasMoreTokens()) {
            String segment = st.nextToken();
            if (segment.length() <= 0) continue;
            pathList.add(segment);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(pathList);
        if (stringArray == null) {
            PyPathMapper.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    public static String @NotNull [] intersectFromEnd(@NotNull String path1, @NotNull String path2, boolean caseSensitive) {
        if (path1 == null) {
            PyPathMapper.$$$reportNull$$$0(2);
        }
        if (path2 == null) {
            PyPathMapper.$$$reportNull$$$0(3);
        }
        return PyPathMapper.intersectFromEnd(PyPathMapper.getPath(path1), PyPathMapper.getPath(path2), caseSensitive);
    }

    public static String @NotNull [] intersectFromEnd(String[] arr1, String[] arr2, boolean caseSensitive) {
        int i1 = arr1.length - 1;
        for (int i2 = arr2.length - 1; i1 > -1 && i2 > -1 && (caseSensitive ? arr1[i1].equals(arr2[i2]) : arr1[i1].equalsIgnoreCase(arr2[i2])); --i1, --i2) {
        }
        String[] stringArray = Arrays.copyOfRange(arr1, i1 + 1, arr1.length);
        if (stringArray == null) {
            PyPathMapper.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    public static boolean detectLocalPath(@NotNull Project project, @NotNull String remoteFilePath, @NotNull PyRemotePathMapper pathMapper) {
        if (project == null) {
            PyPathMapper.$$$reportNull$$$0(5);
        }
        if (remoteFilePath == null) {
            PyPathMapper.$$$reportNull$$$0(6);
        }
        if (pathMapper == null) {
            PyPathMapper.$$$reportNull$$$0(7);
        }
        Collection candidates2 = (Collection)ReadAction.compute(() -> FilenameIndex.getVirtualFilesByName((Project)project, (String)PathUtil.getFileName((String)remoteFilePath), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project)));
        PyMappingSimpleResolveDialog dialog = new PyMappingSimpleResolveDialog(project, remoteFilePath, candidates2);
        UIUtil.invokeAndWaitIfNeeded(() -> dialog.show());
        if (dialog.isOK()) {
            VirtualFile selectedFile = dialog.getSelectedFile();
            PyPathMapper.updateMapping(selectedFile, remoteFilePath, pathMapper);
            return true;
        }
        return false;
    }

    public static void updateMapping(VirtualFile virtualFile2, String remoteFilePath, PyRemotePathMapper pathMapper) {
        PathMappingSettings.PathMapping mapping = PyPathMapper.detectMapping(virtualFile2.getPath(), remoteFilePath);
        pathMapper.addMapping(mapping.getLocalRoot(), mapping.getRemoteRoot(), PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
    }

    @NotNull
    public static PathMappingSettings.PathMapping detectMapping(String localPath, String remotePath) {
        localPath = FileUtil.toSystemIndependentName((String)localPath);
        remotePath = FileUtil.toSystemIndependentName((String)remotePath);
        int i = 1;
        int lastCommonSeparator = 1;
        while (i < remotePath.length() && i < localPath.length() && localPath.charAt(localPath.length() - i) == remotePath.charAt(remotePath.length() - i)) {
            if (localPath.charAt(localPath.length() - ++i) != '/' || remotePath.charAt(remotePath.length() - i) != '/' || i == localPath.length() || i == remotePath.length()) continue;
            lastCommonSeparator = i;
        }
        return new PathMappingSettings.PathMapping(PyPathMapper.getRoot(localPath, lastCommonSeparator), PyPathMapper.getRoot(remotePath, lastCommonSeparator));
    }

    private static String getRoot(String path, int i) {
        if (i < path.length()) {
            return path.substring(0, path.length() - i + 1);
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPath";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/remote/vfs/PyPathMapper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path2";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/remote/vfs/PyPathMapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectFromEnd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "intersectFromEnd";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "detectLocalPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

