/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.remote.ui;

import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.debugger.remote.ui.PyPathMappingTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteMappingSettingsPanel
extends JPanel {
    private final PyPathMappingTree myPathMappingTree;

    public PyRemoteMappingSettingsPanel(@NotNull Project project) {
        if (project == null) {
            PyRemoteMappingSettingsPanel.$$$reportNull$$$0(0);
        }
        this.setLayout(new BorderLayout());
        this.myPathMappingTree = new PyPathMappingTree(project);
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myPathMappingTree)), "Center");
    }

    public void reset(Map<VirtualFile, String> map2) {
        this.myPathMappingTree.reset(map2);
    }

    private Map<VirtualFile, String> getMappings() {
        return this.myPathMappingTree.getValues();
    }

    public void setMappingSettings(PathMappingSettings settings) {
        this.reset(PyRemoteMappingSettingsPanel.convertToMap(settings));
    }

    public PathMappingSettings getMappingSettings() {
        PathMappingSettings mappingSettings = new PathMappingSettings();
        for (Map.Entry<VirtualFile, String> mapping : this.getMappings().entrySet()) {
            String remote = mapping.getValue();
            if (remote.length() <= 0) continue;
            String local = mapping.getKey().getPath();
            mappingSettings.add(new PathMappingSettings.PathMapping(local, remote));
        }
        return mappingSettings;
    }

    private static Map<VirtualFile, String> convertToMap(@Nullable PathMappingSettings settings) {
        HashMap mappings = Maps.newHashMap();
        if (settings != null) {
            for (PathMappingSettings.PathMapping mapping : settings.getPathMappings()) {
                VirtualFile localFile = VirtualFileUtil.findFile(mapping.getLocalRoot());
                if (localFile == null) continue;
                mappings.put(localFile, mapping.getRemoteRoot());
            }
        }
        return mappings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/debugger/remote/ui/PyRemoteMappingSettingsPanel", "<init>"));
    }
}

