/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.django;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XLineBreakpointTypeBase;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.lang.template.parsing.DjangoTemplateTokenTypes;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.python.debugger.PyBreakpointType;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import org.jetbrains.annotations.NotNull;

public class DjangoTemplateLineBreakpointType
extends XLineBreakpointTypeBase
implements PyBreakpointType {
    public static final String ID = "django-line";

    public DjangoTemplateLineBreakpointType() {
        super(ID, DjangoBundle.message("django.line.breakpoint", new Object[0]), (XDebuggerEditorsProvider)new PyDebuggerEditorsProvider());
    }

    public boolean canPutAt(@NotNull VirtualFile file2, int line2, @NotNull Project project) {
        if (file2 == null) {
            DjangoTemplateLineBreakpointType.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DjangoTemplateLineBreakpointType.$$$reportNull$$$0(1);
        }
        Ref stoppable = Ref.create((Object)false);
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document != null && this.canPutInDocument(project, document)) {
            XDebuggerUtil.getInstance().iterateLine(project, document, line2, psiElement -> {
                if (psiElement != null && (psiElement.getNode().getElementType() == DjangoTemplateTokenTypes.DJANGO_EXPRESSION_START || psiElement.getNode().getElementType() == DjangoTemplateTokenTypes.DJANGO_TAG_START)) {
                    stoppable.set((Object)true);
                    return false;
                }
                return true;
            });
        }
        return (Boolean)stoppable.get();
    }

    @Override
    public boolean canPutInDocument(Project project, Document document) {
        return DjangoUtil.isDjangoTemplateDocument(document, project);
    }

    public String getBreakpointsDialogHelpTopic() {
        return "reference.dialogs.breakpoints";
    }

    public boolean shouldShowInBreakpointsDialog(@NotNull Project project) {
        if (project == null) {
            DjangoTemplateLineBreakpointType.$$$reportNull$$$0(2);
        }
        return DjangoFacet.isPresentInAnyModule(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/django/DjangoTemplateLineBreakpointType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canPutAt";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldShowInBreakpointsDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

