/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyFile;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PyFlipComparisonIntention
extends PyBaseIntentionAction {
    private static final Map<PyElementType, String> FLIPPED_OPERATORS = new HashMap<PyElementType, String>(7);

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.flip.comparison", new Object[0]);
        if (string == null) {
            PyFlipComparisonIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file2) {
        if (project == null) {
            PyFlipComparisonIntention.$$$reportNull$$$0(1);
        }
        if (!(file2 instanceof PyFile)) {
            return false;
        }
        PsiElement element = file2.findElementAt(editor2.getCaretModel().getOffset());
        PyBinaryExpression binaryExpression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyBinaryExpression.class, (boolean)false);
        while (binaryExpression != null) {
            PyElementType operator = binaryExpression.getOperator();
            if (FLIPPED_OPERATORS.containsKey((Object)operator)) {
                String operatorText = binaryExpression.getPsiOperator().getText();
                String flippedOperatorText = FLIPPED_OPERATORS.get((Object)operator);
                if (flippedOperatorText.equals(operatorText)) {
                    this.setText(PyBundle.message("INTN.flip.$0", operatorText));
                } else {
                    this.setText(PyBundle.message("INTN.flip.$0.to.$1", operatorText, flippedOperatorText));
                }
                return true;
            }
            binaryExpression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)binaryExpression, PyBinaryExpression.class);
        }
        return false;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            PyFlipComparisonIntention.$$$reportNull$$$0(2);
        }
        PsiElement element = file2.findElementAt(editor2.getCaretModel().getOffset());
        PyBinaryExpression binaryExpression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyBinaryExpression.class, (boolean)false);
        while (binaryExpression != null) {
            if (FLIPPED_OPERATORS.containsKey((Object)binaryExpression.getOperator())) {
                PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
                binaryExpression.replace((PsiElement)elementGenerator.createBinaryExpression(FLIPPED_OPERATORS.get((Object)binaryExpression.getOperator()), binaryExpression.getRightExpression(), binaryExpression.getLeftExpression()));
                return;
            }
            binaryExpression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)binaryExpression, PyBinaryExpression.class);
        }
    }

    static {
        FLIPPED_OPERATORS.put(PyTokenTypes.EQEQ, "==");
        FLIPPED_OPERATORS.put(PyTokenTypes.NE, "!=");
        FLIPPED_OPERATORS.put(PyTokenTypes.NE_OLD, "<>");
        FLIPPED_OPERATORS.put(PyTokenTypes.GE, "<=");
        FLIPPED_OPERATORS.put(PyTokenTypes.LE, ">=");
        FLIPPED_OPERATORS.put(PyTokenTypes.GT, "<");
        FLIPPED_OPERATORS.put(PyTokenTypes.LT, ">");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyFlipComparisonIntention";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyFlipComparisonIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

