/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.buildout;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.buildout.BuildoutFacetConfiguration;
import com.jetbrains.python.buildout.BuildoutFacetType;
import com.jetbrains.python.buildout.config.BuildoutCfgLanguage;
import com.jetbrains.python.buildout.config.psi.impl.BuildoutCfgFile;
import com.jetbrains.python.facet.FacetLibraryConfigurator;
import com.jetbrains.python.facet.LibraryContributingFacet;
import com.jetbrains.python.facet.PythonPathContributingFacet;
import com.jetbrains.python.sdk.PythonEnvUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class BuildoutFacet
extends LibraryContributingFacet<BuildoutFacetConfiguration>
implements PythonPathContributingFacet {
    private static final Logger LOG = Logger.getInstance(BuildoutFacet.class);
    @NonNls
    public static final String BUILDOUT_CFG = "buildout.cfg";
    @NonNls
    public static final String SCRIPT_SUFFIX = "-script";
    private static final String BUILDOUT_LIB_NAME = "Buildout Eggs";

    public BuildoutFacet(@NotNull FacetType facetType, final @NotNull Module module, @NotNull String name, @NotNull BuildoutFacetConfiguration configuration, Facet underlyingFacet) {
        if (facetType == null) {
            BuildoutFacet.$$$reportNull$$$0(0);
        }
        if (module == null) {
            BuildoutFacet.$$$reportNull$$$0(1);
        }
        if (name == null) {
            BuildoutFacet.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            BuildoutFacet.$$$reportNull$$$0(3);
        }
        super(facetType, module, name, configuration, underlyingFacet);
        VirtualFileManager.getInstance().addVirtualFileListener(new VirtualFileListener(){

            public void contentsChanged(@NotNull VirtualFileEvent event2) {
                if (event2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (Comparing.equal((Object)event2.getFile(), (Object)BuildoutFacet.this.getScript())) {
                    BuildoutFacet.this.updatePaths();
                    BuildoutFacet.attachLibrary(module);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/buildout/BuildoutFacet$1", "contentsChanged"));
            }
        }, (Disposable)this);
    }

    @Nullable
    public static VirtualFile getRunner(VirtualFile baseDir) {
        VirtualFile bin;
        VirtualFile eggs;
        if (baseDir == null) {
            return null;
        }
        VirtualFile cfg = baseDir.findChild(BUILDOUT_CFG);
        if (cfg != null && !cfg.isDirectory() && (eggs = baseDir.findChild("eggs")) != null && eggs.isDirectory() && (bin = baseDir.findChild("bin")) != null && bin.isDirectory()) {
            String exe;
            VirtualFile runner;
            if (ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().isReadAccessAllowed()) {
                bin.refresh(false, false);
            }
            if ((runner = bin.findChild(exe = SystemInfo.isWindows ? "buildout.exe" : "buildout")) != null && !runner.isDirectory()) {
                return runner;
            }
        }
        return null;
    }

    @NotNull
    public static List<VirtualFile> getExtraPathForAllOpenModules() {
        ArrayList<VirtualFile> results = new ArrayList<VirtualFile>();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                List<String> paths;
                BuildoutFacet buildoutFacet = BuildoutFacet.getInstance(module);
                if (buildoutFacet == null || (paths = ((BuildoutFacetConfiguration)buildoutFacet.getConfiguration()).getPaths()) == null) continue;
                for (String path : paths) {
                    VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
                    if (file2 == null) continue;
                    results.add(file2);
                }
            }
        }
        ArrayList<VirtualFile> arrayList = results;
        if (arrayList == null) {
            BuildoutFacet.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    public String getPathPrependStatement(List<String> additionalPythonPath) {
        StringBuilder sb = new StringBuilder("sys.path[0:0]=[");
        for (String s : additionalPythonPath) {
            sb.append("'").append(s).append("',");
        }
        sb.append("]");
        return sb.toString();
    }

    public void initFacet() {
        this.updateLibrary();
    }

    @Override
    public void updateLibrary() {
        this.updatePaths();
        BuildoutFacet.attachLibrary(this.getModule());
    }

    @Override
    public void removeLibrary() {
        BuildoutFacet.detachLibrary(this.getModule());
    }

    public void updatePaths() {
        BuildoutFacetConfiguration config = (BuildoutFacetConfiguration)this.getConfiguration();
        VirtualFile script = this.getScript();
        if (script != null) {
            config.setPaths(BuildoutFacet.extractBuildoutPaths(script));
        }
    }

    @Nullable
    public VirtualFile getScript() {
        return LocalFileSystem.getInstance().findFileByPath(((BuildoutFacetConfiguration)this.getConfiguration()).getScriptName());
    }

    @Nullable
    public static List<String> extractBuildoutPaths(@NotNull VirtualFile script) {
        if (script == null) {
            BuildoutFacet.$$$reportNull$$$0(5);
        }
        try {
            List<String> paths = BuildoutFacet.extractFromScript(script);
            if (paths == null) {
                VirtualFile sitePy;
                VirtualFile root = script.getParent().getParent();
                String partName = FileUtilRt.getNameWithoutExtension((String)script.getName());
                if (SystemInfo.isWindows && partName.endsWith(SCRIPT_SUFFIX)) {
                    partName = partName.substring(0, partName.length() - SCRIPT_SUFFIX.length());
                }
                if ((sitePy = root.findFileByRelativePath("parts/" + partName + "/site.py")) != null) {
                    paths = BuildoutFacet.extractFromSitePy(sitePy);
                }
            }
            return paths;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @Nullable
    public static List<String> extractFromScript(@NotNull VirtualFile script) throws IOException {
        if (script == null) {
            BuildoutFacet.$$$reportNull$$$0(6);
        }
        String text2 = VfsUtilCore.loadText((VirtualFile)script);
        Pattern pat = Pattern.compile("(?:^\\s*(['\"])(.*)(\\1),\\s*$)|(\\])", 8);
        String bait_string = "sys.path[0:0]";
        int pos = text2.indexOf("sys.path[0:0]");
        ArrayList<String> ret = null;
        if (pos >= 0) {
            String value2;
            pos += "sys.path[0:0]".length();
            Matcher scanner = pat.matcher(text2);
            while (scanner.find(pos) && (value2 = scanner.group(2)) != null) {
                if (ret == null) {
                    ret = new ArrayList<String>();
                }
                ret.add(value2);
                pos = scanner.end();
            }
        }
        return ret;
    }

    public static List<String> extractFromSitePy(VirtualFile vFile) throws IOException {
        int index;
        ArrayList<String> result = new ArrayList<String>();
        String text2 = VfsUtilCore.loadText((VirtualFile)vFile);
        String[] lines = LineTokenizer.tokenize((CharSequence)text2, (boolean)false);
        for (index = 0; index < lines.length && !lines[index].startsWith("def addsitepackages("); ++index) {
        }
        while (index < lines.length && !lines[index].trim().startsWith("buildout_paths = [")) {
            ++index;
        }
        ++index;
        while (index < lines.length && !lines[index].trim().equals("]")) {
            String line2 = lines[index].trim();
            if ((line2 = StringUtil.trimEnd((String)line2, (String)",")).startsWith("'") && line2.endsWith("'")) {
                result.add(StringUtil.unescapeStringCharacters((String)line2.substring(1, line2.length() - 1)));
            }
            ++index;
        }
        return result;
    }

    @Override
    public List<String> getAdditionalPythonPath() {
        BuildoutFacetConfiguration cfg = (BuildoutFacetConfiguration)this.getConfiguration();
        return cfg.getPaths();
    }

    @Override
    public boolean acceptRootAsTopLevelPackage() {
        return false;
    }

    @Nullable
    public static BuildoutFacet getInstance(Module module) {
        return (BuildoutFacet)FacetManager.getInstance((Module)module).getFacetByType(BuildoutFacetType.ID);
    }

    public void patchCommandLineForBuildout(GeneralCommandLine commandLine) {
        Map env = commandLine.getEnvironment();
        ParametersList params = commandLine.getParametersList();
        ParamsGroup scriptParams = params.getParamsGroup("Script");
        assert (scriptParams != null);
        if (scriptParams.getParameters().size() > 0) {
            String normalScript = (String)scriptParams.getParameters().get(0);
            PythonHelper engulfer = PythonHelper.BUILDOUT_ENGULFER;
            env.put("PYCHARM_ENGULF_SCRIPT", ((BuildoutFacetConfiguration)this.getConfiguration()).getScriptName());
            scriptParams.getParametersList().replaceOrPrepend(normalScript, engulfer.asParamString());
        }
        PythonEnvUtil.addToPythonPath((Map<String, String>)env, PythonHelpersLocator.getHelpersRoot().getAbsolutePath());
    }

    @Nullable
    public File getConfigFile() {
        String scriptName = ((BuildoutFacetConfiguration)this.getConfiguration()).getScriptName();
        if (!StringUtil.isEmpty((String)scriptName)) {
            return new File(new File(scriptName).getParentFile().getParentFile(), BUILDOUT_CFG);
        }
        return null;
    }

    @Nullable
    public BuildoutCfgFile getConfigPsiFile() {
        File cfg = this.getConfigFile();
        if (cfg != null && cfg.exists()) {
            try {
                String text2 = FileUtil.loadFile((File)cfg);
                PsiFile configFile = PsiFileFactory.getInstance((Project)this.getModule().getProject()).createFileFromText(BUILDOUT_CFG, (Language)BuildoutCfgLanguage.INSTANCE, (CharSequence)text2);
                if (configFile instanceof BuildoutCfgFile) {
                    return (BuildoutCfgFile)configFile;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<File> getScripts(@Nullable BuildoutFacet buildoutFacet, VirtualFile baseDir) {
        File[] scripts;
        File configIOFile;
        File rootPath = null;
        if (buildoutFacet != null && (configIOFile = buildoutFacet.getConfigFile()) != null) {
            rootPath = configIOFile.getParentFile();
        }
        if (!(rootPath != null && rootPath.exists() || baseDir == null)) {
            rootPath = new File(baseDir.getPath());
        }
        if (rootPath != null && (scripts = new File(rootPath, "bin").listFiles((dir, name) -> {
            if (SystemInfo.isWindows) {
                return name.endsWith("-script.py");
            }
            String ext = FileUtilRt.getExtension((String)name);
            return ext.length() == 0 || FileUtil.namesEqual((String)ext, (String)"py");
        })) != null) {
            return Arrays.asList(scripts);
        }
        return Collections.emptyList();
    }

    @Nullable
    public static File findScript(@Nullable BuildoutFacet buildoutFacet, String name, VirtualFile baseDir) {
        String scriptName = SystemInfo.isWindows ? name + SCRIPT_SUFFIX : name;
        List<File> scripts = BuildoutFacet.getScripts(buildoutFacet, baseDir);
        for (File script : scripts) {
            if (!FileUtilRt.getNameWithoutExtension((String)script.getName()).equals(scriptName)) continue;
            return script;
        }
        return null;
    }

    public static void attachLibrary(Module module) {
        BuildoutFacet facet = BuildoutFacet.getInstance(module);
        if (facet == null) {
            return;
        }
        List<String> paths = ((BuildoutFacetConfiguration)facet.getConfiguration()).getPaths();
        FacetLibraryConfigurator.attachPythonLibrary(module, null, BUILDOUT_LIB_NAME, paths);
    }

    public static void detachLibrary(Module module) {
        FacetLibraryConfigurator.detachPythonLibrary(module, BUILDOUT_LIB_NAME);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/buildout/BuildoutFacet";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/buildout/BuildoutFacet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraPathForAllOpenModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractBuildoutPaths";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractFromScript";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

