/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.mako.MakoTokenTypes;
import com.jetbrains.mako.psi.MakoTagBlock;
import com.jetbrains.mako.psi.impl.MakoPsiElement;
import com.jetbrains.mako.psi.impl.MakoTagAttribute;
import com.jetbrains.mako.ref.MakoCallReference;
import com.jetbrains.mako.validation.MakoElementVisitor;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakoCall
extends MakoPsiElement
implements MakoTagBlock {
    public MakoCall(@NotNull ASTNode node) {
        if (node == null) {
            MakoCall.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Nullable
    private PsiElement getNameNode() {
        PsiElement child = this.getFirstChild();
        if (child == null) {
            return null;
        }
        ASTNode nameNode = child.getNode().findChildByType((IElementType)MakoTokenTypes.MAKO_QUALIFIED_TAG_NAME);
        if (nameNode != null) {
            return nameNode.getPsi();
        }
        child = this.findChildByType(MakoTokenTypes.MAKO_QUALIFIED_TAG_NAME);
        if (child != null) {
            return child;
        }
        return this.findChildByType(MakoTokenTypes.MAKO_TAG_NAME);
    }

    @NotNull
    public String getName() {
        PsiElement nameNode = this.getNameNode();
        if (nameNode == null) {
            return "";
        }
        PsiElement lastChild = nameNode.getLastChild();
        if (lastChild != null) {
            if (lastChild.getNode().getElementType() == MakoTokenTypes.MAKO_TAG_NAME) {
                String string = lastChild.getText();
                if (string == null) {
                    MakoCall.$$$reportNull$$$0(1);
                }
                return string;
            }
            if (lastChild.getNode().getElementType() == MakoTokenTypes.MAKO_COLON) {
                return "";
            }
        }
        String string = nameNode.getText();
        if (string == null) {
            MakoCall.$$$reportNull$$$0(2);
        }
        return string;
    }

    public String getNamespace() {
        PsiElement nameNode = this.getNameNode();
        if (nameNode == null) {
            return null;
        }
        PsiElement firstChild = nameNode.getFirstChild();
        if (firstChild != null && firstChild.getNode().getElementType() == MakoTokenTypes.MAKO_TAG_NAME) {
            return firstChild.getText();
        }
        return null;
    }

    public String getQualifiedName() {
        PsiElement nameNode = this.getNameNode();
        if (nameNode == null) {
            return null;
        }
        return nameNode.getText();
    }

    public MakoTagAttribute @NotNull [] getArguments() {
        MakoTagAttribute[] attrs = (MakoTagAttribute[])PsiTreeUtil.getChildrenOfType((PsiElement)this, MakoTagAttribute.class);
        MakoTagAttribute[] makoTagAttributeArray = attrs == null ? new MakoTagAttribute[]{} : attrs;
        if (makoTagAttributeArray == null) {
            MakoCall.$$$reportNull$$$0(3);
        }
        return makoTagAttributeArray;
    }

    @NotNull
    public Set<String> getArgumentsNames() {
        MakoTagAttribute[] attrs;
        HashSet<String> result = new HashSet<String>();
        for (MakoTagAttribute attribute : attrs = this.getArguments()) {
            result.add(attribute.getName());
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            MakoCall.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    @Override
    public String toString() {
        return "MakoCall";
    }

    @NotNull
    public MakoCallReference getReference() {
        return new MakoCallReference(this);
    }

    public TextRange getNameRange() {
        PsiElement nameNode = this.getNameNode();
        return nameNode == null ? TextRange.EMPTY_RANGE : nameNode.getTextRange();
    }

    @Override
    protected void acceptMakoVisitor(MakoElementVisitor visitor2) {
        visitor2.visitMakoCall(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/mako/psi/impl/MakoCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/mako/psi/impl/MakoCall";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentsNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

