/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.facet.DjangoFacetType;
import com.jetbrains.django.lang.template.DjangoTemplateLanguage;
import com.jetbrains.django.testRunner.DjangoTestsRunConfiguration;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.django.util.DjangoPythonUtil;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.buildout.BuildoutFacet;
import com.jetbrains.python.buildout.BuildoutFacetConfiguration;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.packaging.requirement.PyRequirementRelation;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoUtil {
    private static final Set<String> NAMES = ImmutableSet.of((Object)"urls.py", (Object)"manage.py", (Object)"settings.py", (Object)"views.py");
    private static final FileType[] TEMPLATE_FILE_TYPES = new FileType[]{StdFileTypes.HTML, StdFileTypes.XHTML, StdFileTypes.XML, StdFileTypes.JS};

    private DjangoUtil() {
    }

    @NotNull
    public static PyRequirement createRequirementAtLeast(int major, int minor) {
        PyRequirement pyRequirement = PyRequirementsKt.pyRequirement("Django", PyRequirementRelation.GTE, String.format("%s.%s", major, minor));
        if (pyRequirement == null) {
            DjangoUtil.$$$reportNull$$$0(0);
        }
        return pyRequirement;
    }

    private static boolean isProjectRoot(@Nullable PsiFileSystemItem dir) {
        return dir instanceof PsiDirectory && ((PsiDirectory)dir).findFile("manage.py") != null;
    }

    @Nullable
    public static PsiDirectory getProjectRoot(@NotNull PsiFileSystemItem folder) {
        PsiFileSystemItem f;
        if (folder == null) {
            DjangoUtil.$$$reportNull$$$0(1);
        }
        for (f = folder; f != null && !DjangoUtil.isProjectRoot(f); f = f.getParent()) {
        }
        return (PsiDirectory)f;
    }

    @Nullable
    public static Module getDjangoModule(@NotNull Project project) {
        if (project == null) {
            DjangoUtil.$$$reportNull$$$0(2);
        }
        return (Module)ContainerUtil.getFirstItem((List)ProjectFacetManager.getInstance((Project)project).getModulesWithFacet(DjangoFacetType.ID));
    }

    @Nullable
    public static String getProjectRoot(@NotNull Module module) {
        DjangoFacet facet;
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(3);
        }
        if ((facet = DjangoFacet.getInstance(module)) != null) {
            DjangoUtil.recordUsage(facet);
            return ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootPath();
        }
        return null;
    }

    private static void recordUsage(@NotNull DjangoFacet facet) {
        if (facet == null) {
            DjangoUtil.$$$reportNull$$$0(4);
        }
        if (!StringUtil.isNotEmpty((String)((DjangoFacetConfiguration)facet.getConfiguration()).getManageFilePath()) || ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootFolderFile() == null || "manage.py".equals(((DjangoFacetConfiguration)facet.getConfiguration()).getManageFilePath())) {
            // empty if block
        }
    }

    @Nullable
    public static String findRoot(Module module) {
        for (VirtualFile file2 : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            ManageFileFinder finder = new ManageFileFinder();
            VfsUtilCore.processFilesRecursively((VirtualFile)file2, (Processor)finder);
            VirtualFile manageFile = finder.myManageFile;
            if (manageFile == null) continue;
            return manageFile.getParent().getPresentableUrl();
        }
        return null;
    }

    @Nullable
    public static PsiFileSystemItem searchFileOrFolder(String path, PsiElement contextElement) {
        PsiFile fileOrFolder = DjangoUtil.searchFile(path, contextElement);
        if (fileOrFolder == null) {
            fileOrFolder = DjangoUtil.searchFolder(path, contextElement);
        }
        return fileOrFolder;
    }

    @Nullable
    public static PsiFile searchFile(String path, PsiElement contextElement) {
        PsiFile file2 = DjangoUtil.searchProjectFile(path, contextElement);
        if (file2 == null) {
            file2 = DjangoUtil.getLibraryFile(path, contextElement);
        }
        return file2;
    }

    @Nullable
    public static PsiDirectory searchFolder(@NotNull String path, @NotNull PsiElement contextElement) {
        PsiDirectory file2;
        if (path == null) {
            DjangoUtil.$$$reportNull$$$0(5);
        }
        if (contextElement == null) {
            DjangoUtil.$$$reportNull$$$0(6);
        }
        if ((file2 = DjangoUtil.searchProjectFolder(path, contextElement, null)) == null) {
            file2 = DjangoUtil.getLibraryFolder(path, contextElement);
        }
        return file2;
    }

    @Nullable
    public static PsiFile searchProjectFile(String path, @NotNull PsiElement contextElement) {
        PsiFile result;
        String elementProjectName;
        if (contextElement == null) {
            DjangoUtil.$$$reportNull$$$0(7);
        }
        PsiDirectory djangoRoot = DjangoUtil.getProjectRoot(contextElement);
        String projectName = PythonStringUtil.getFirstPrefix(path, ".");
        if (projectName.equals(elementProjectName = DjangoUtil.getProjectName(contextElement)) ? (result = DjangoUtil.searchInProject(djangoRoot, PythonStringUtil.removeFirstPrefix(path, "."))) != null : (result = DjangoUtil.searchInProject(djangoRoot, path)) != null) {
            return result;
        }
        result = DjangoPsiUtil.findFileInRoots(path, contextElement);
        return result;
    }

    @Nullable
    public static PsiDirectory searchProjectFolder(@NotNull String path, @NotNull PsiElement contextElement, @Nullable Module withModule) {
        String elementProjectName;
        String projectName;
        String viewsPath;
        PsiDirectory djangoRoot;
        PsiDirectory result;
        if (path == null) {
            DjangoUtil.$$$reportNull$$$0(8);
        }
        if (contextElement == null) {
            DjangoUtil.$$$reportNull$$$0(9);
        }
        if ((result = DjangoPsiUtil.findFolder(djangoRoot = DjangoUtil.getProjectRoot(contextElement), viewsPath = (projectName = PythonStringUtil.getFirstPrefix(path, ".")).equals(elementProjectName = DjangoUtil.getProjectName(contextElement)) ? DjangoPythonUtil.toFolderPath(PythonStringUtil.removeFirstPrefix(path, ".")) : DjangoPythonUtil.toFolderPath(path))) != null) {
            return result;
        }
        QualifiedName qName = QualifiedName.fromDottedString((String)path);
        PyQualifiedNameResolveContext context = ModuleUtilCore.findModuleForPsiElement((PsiElement)contextElement) == null && withModule != null ? PyResolveImportUtil.fromModule(withModule) : PyResolveImportUtil.fromFoothold(contextElement);
        return StreamEx.of(PyResolveImportUtil.resolveQualifiedName(qName, context)).select(PsiDirectory.class).findFirst().orElse(null);
    }

    @Nullable
    public static PsiFile searchInProject(PsiDirectory djangoRoot, String appPath) {
        String viewsPath = DjangoPythonUtil.toFilePath(appPath);
        return DjangoPsiUtil.findChild(djangoRoot, viewsPath);
    }

    @Nullable
    public static PsiFile getLibraryFile(String path, PsiElement contextElement) {
        VirtualFile file2 = DjangoPythonUtil.findLibraryFile(DjangoPythonUtil.toFilePath(path), PythonSdkUtil.findPythonSdk(contextElement));
        return file2 != null && file2.isValid() ? contextElement.getManager().findFile(file2) : null;
    }

    @Nullable
    public static PsiDirectory getLibraryFolder(String path, PsiElement contextElement) {
        VirtualFile file2 = DjangoPythonUtil.findLibraryFile(DjangoPythonUtil.toFolderPath(path), PythonSdkUtil.findPythonSdk(contextElement));
        return file2 != null ? contextElement.getManager().findDirectory(file2) : null;
    }

    @Nullable
    public static String getBuildoutRunnerScript(Module module) {
        String django_runner_name;
        VirtualFile django_runner;
        VirtualFile folder;
        VirtualFile script_file;
        BuildoutFacetConfiguration cfg;
        String script;
        BuildoutFacet facet;
        if (module != null && (facet = BuildoutFacet.getInstance(module)) != null && (script = (cfg = (BuildoutFacetConfiguration)facet.getConfiguration()).getScriptName()) != null && (script_file = LocalFileSystem.getInstance().findFileByPath(script)) != null && (folder = script_file.getParent()) != null && "bin".equals(folder.getName()) && (django_runner = folder.findChild(django_runner_name = SystemInfo.isWindows ? "django.py" : "django")) != null) {
            return django_runner.getPath().replace('/', File.separatorChar);
        }
        return null;
    }

    public static void addDjangoPathToEnv(@NotNull String djangoPath, Map<String, String> envs) {
        if (djangoPath == null) {
            DjangoUtil.$$$reportNull$$$0(10);
        }
        String djangoRoot = DjangoUtil.removeDjangoBin(djangoPath);
        PythonEnvUtil.addToPythonPath(envs, FileUtil.toSystemDependentName((String)djangoRoot));
    }

    public static String getManageScript(@Nullable Module module) {
        VirtualFile manageFile;
        if (module == null) {
            return "";
        }
        DjangoFacet facet = DjangoFacet.getInstance(module);
        if (facet != null && (manageFile = DjangoUtil.getManageFile(module)) != null) {
            return manageFile.getPath();
        }
        return "";
    }

    @Nullable
    public static String getDjangoAdmin(String sdkHome) {
        String admin = "django-admin.py";
        return PythonSdkUtil.getExecutablePath(sdkHome, admin);
    }

    @Nullable
    public static VirtualFile getSettingsFile(@NotNull Module module) {
        DjangoFacet facet;
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(11);
        }
        if ((facet = DjangoFacet.getInstance(module)) == null) {
            return null;
        }
        return DjangoUtil.getSettingsFile(facet);
    }

    @Nullable
    public static VirtualFile getSettingsFile(@NotNull DjangoFacet facet) {
        VirtualFile projectRoot;
        if (facet == null) {
            DjangoUtil.$$$reportNull$$$0(12);
        }
        if ((projectRoot = ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootFolderFile()) != null) {
            return projectRoot.findFileByRelativePath(((DjangoFacetConfiguration)facet.getConfiguration()).getSettingsFilePath());
        }
        return null;
    }

    @Nullable
    public static VirtualFile getManageFile(@NotNull Module module) {
        DjangoFacet facet;
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(13);
        }
        if ((facet = DjangoFacet.getInstance(module)) != null) {
            if (((DjangoFacetConfiguration)facet.getConfiguration()).getManageFilePath().isEmpty()) {
                return null;
            }
            VirtualFile managePyFile = VirtualFileUtil.findFile(((DjangoFacetConfiguration)facet.getConfiguration()).getManageFilePath());
            if (managePyFile != null) {
                return managePyFile;
            }
            VirtualFile projectRoot = ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootFolderFile();
            if (projectRoot != null) {
                return projectRoot.findFileByRelativePath(((DjangoFacetConfiguration)facet.getConfiguration()).getManageFilePath());
            }
        }
        return null;
    }

    public static void addDjangoSettingsToEnv(@NotNull Module module, @NotNull Map<String, String> envs) {
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(14);
        }
        if (envs == null) {
            DjangoUtil.$$$reportNull$$$0(15);
        }
        DjangoUtil.addDjangoSettingsToEnv(module, envs, true);
    }

    public static void addDjangoSettingsToEnv(@NotNull Module module, @NotNull Map<String, String> envs, boolean addManageModule) {
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(16);
        }
        if (envs == null) {
            DjangoUtil.$$$reportNull$$$0(17);
        }
        DjangoUtil.addPyCharmSettingsModule(module, envs);
        if (addManageModule) {
            DjangoUtil.addPyCharmManageModule(module, envs);
        }
    }

    private static Map<String, String> addPyCharmSettingsModule(@NotNull Module module, @NotNull Map<String, String> envs) {
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(18);
        }
        if (envs == null) {
            DjangoUtil.$$$reportNull$$$0(19);
        }
        VirtualFile settingsFile = DjangoUtil.getSettingsFile(module);
        return DjangoUtil.addSettingsModule(module, settingsFile, envs);
    }

    public static Map<String, String> addSettingsModule(@NotNull Module module, @Nullable VirtualFile settingsFile, @NotNull Map<String, String> envs) {
        String relativePath;
        VirtualFile manageFile;
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(20);
        }
        if (envs == null) {
            DjangoUtil.$$$reportNull$$$0(21);
        }
        if (envs.containsKey("DJANGO_SETTINGS_MODULE")) {
            return envs;
        }
        if (settingsFile == null) {
            return envs;
        }
        String moduleToImport = DjangoUtil.getModuleRelatedToRoot(module, settingsFile);
        if (moduleToImport == null && (manageFile = DjangoUtil.getManageFile(module)) != null && (relativePath = VirtualFileUtil.getRelativePath(manageFile.getParent(), settingsFile)) != null) {
            moduleToImport = FileUtilRt.getNameWithoutExtension((String)relativePath).replace('/', '.');
        }
        if (moduleToImport == null) {
            moduleToImport = DjangoUtil.getImportableModule(module, settingsFile);
        }
        envs.put("DJANGO_SETTINGS_MODULE", moduleToImport);
        return envs;
    }

    public static Map<String, String> addPyCharmManageModule(@NotNull Module module, @NotNull Map<String, String> envs) {
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(22);
        }
        if (envs == null) {
            DjangoUtil.$$$reportNull$$$0(23);
        }
        if (envs.containsKey("PYCHARM_DJANGO_MANAGE_MODULE")) {
            return envs;
        }
        VirtualFile manageFile = DjangoUtil.getManageFile(module);
        if (manageFile != null) {
            String manageModule = DjangoUtil.getModuleRelatedToRoot(module, manageFile);
            if (manageModule == null) {
                manageModule = manageFile.getNameWithoutExtension();
            }
            envs.put("PYCHARM_DJANGO_MANAGE_MODULE", manageModule);
        }
        return envs;
    }

    @Nullable
    private static String getModuleRelatedToRoot(@NotNull Module module, @NotNull VirtualFile file2) {
        List result;
        String projectRootString;
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(24);
        }
        if (file2 == null) {
            DjangoUtil.$$$reportNull$$$0(25);
        }
        if ((projectRootString = DjangoUtil.getProjectRoot(module)) == null) {
            return null;
        }
        VirtualFile projectRoot = VirtualFileUtil.findFile(projectRootString);
        if (projectRoot == null) {
            return null;
        }
        String relativePath = VirtualFileUtil.getRelativePath(projectRoot, file2);
        if (relativePath != null && (result = StringUtil.split((String)relativePath, (String)"/")).size() > 0) {
            result.set(result.size() - 1, FileUtilRt.getNameWithoutExtension((String)((String)result.get(result.size() - 1))));
            return StringUtil.join((Collection)result, (String)".");
        }
        return null;
    }

    @Nullable
    public static VirtualFile getCustomTestSettingsFile(@NotNull Module module, @NotNull DjangoTestsRunConfiguration configuration) {
        VirtualFile projectRoot;
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(26);
        }
        if (configuration == null) {
            DjangoUtil.$$$reportNull$$$0(27);
        }
        if (!configuration.useCustomSettings()) {
            return null;
        }
        String settings = configuration.getSettingsFile();
        if (settings == null || settings.isEmpty()) {
            return null;
        }
        DjangoFacet facet = DjangoFacet.getInstance(module);
        if (facet != null && (projectRoot = ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootFolderFile()) != null) {
            VirtualFile file2 = projectRoot.findFileByRelativePath(settings);
            if (file2 == null) {
                file2 = LocalFileSystem.getInstance().findFileByPath(settings);
            }
            return file2;
        }
        return null;
    }

    public static void addCustomTestSettingsModule(@NotNull Module module, @NotNull Map<String, String> envs, @NotNull DjangoTestsRunConfiguration configuration) {
        VirtualFile settingsFile;
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(28);
        }
        if (envs == null) {
            DjangoUtil.$$$reportNull$$$0(29);
        }
        if (configuration == null) {
            DjangoUtil.$$$reportNull$$$0(30);
        }
        if ((settingsFile = DjangoUtil.getCustomTestSettingsFile(module, configuration)) == null) {
            settingsFile = DjangoUtil.getSettingsFile(module);
        }
        DjangoUtil.addSettingsModule(module, settingsFile, envs);
    }

    public static Map<String, String> addModuleToEnv(@NotNull Module module, @NotNull Map<String, String> envs, @Nullable VirtualFile file2, @NotNull String envName) {
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(31);
        }
        if (envs == null) {
            DjangoUtil.$$$reportNull$$$0(32);
        }
        if (envName == null) {
            DjangoUtil.$$$reportNull$$$0(33);
        }
        if (file2 != null) {
            String moduleToImport = DjangoUtil.getImportableModule(module, file2);
            envs.put(envName, moduleToImport);
        }
        return envs;
    }

    public static String getSettingsModule(@NotNull Module module) {
        VirtualFile settingsFile;
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(34);
        }
        if ((settingsFile = DjangoUtil.getSettingsFile(module)) != null) {
            return DjangoUtil.getImportableModule(module, settingsFile);
        }
        return "settings";
    }

    public static String getImportableModule(@NotNull Module module, @NotNull VirtualFile file2) {
        String moduleToImport;
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(35);
        }
        if (file2 == null) {
            DjangoUtil.$$$reportNull$$$0(36);
        }
        if ((moduleToImport = QualifiedNameFinder.findShortestImportableName(module, file2)) == null) {
            moduleToImport = FileUtilRt.getNameWithoutExtension((String)file2.getName());
        }
        return moduleToImport;
    }

    public static boolean isDjangoAvailable(@NotNull Module module, String sdkHome) {
        Sdk pythonSdk2;
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(37);
        }
        if ((pythonSdk2 = PythonSdkUtil.findSdkByPath(sdkHome)) == null) {
            return false;
        }
        PyQualifiedNameResolveContext context = PyResolveImportUtil.fromSdk(module.getProject(), pythonSdk2);
        List<PsiElement> results = PyResolveImportUtil.resolveQualifiedName(QualifiedName.fromDottedString((String)"django"), context);
        return !results.isEmpty();
    }

    @NotNull
    public static List<String> getDjangoVersionParts(@NotNull PyPackage djangoPackage) {
        if (djangoPackage == null) {
            DjangoUtil.$$$reportNull$$$0(38);
        }
        List list = StringUtil.split((String)djangoPackage.getVersion(), (String)".");
        if (list == null) {
            DjangoUtil.$$$reportNull$$$0(39);
        }
        return list;
    }

    public static StringPattern createDjangoStandardProjectFileNamePattern() {
        return StandardPatterns.string().oneOf(NAMES);
    }

    @Nullable
    public static String getDjangoPath(Sdk sdk) {
        VirtualFile[] roots = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
        return DjangoUtil.getDjangoPath(roots);
    }

    @Nullable
    private static String getDjangoPath(VirtualFile[] roots) {
        for (VirtualFile root : roots) {
            VirtualFile binFolder;
            if (SystemInfo.isLinux && "python-django".equals(root.getName()) && (binFolder = root.findChild("bin")) != null) {
                return binFolder.getPath();
            }
            LocalFileSystem lfs = LocalFileSystem.getInstance();
            VirtualFile djangoBinFolder = lfs.refreshAndFindFileByIoFile(new File(root.getPath(), "django/bin"));
            if (djangoBinFolder == null) continue;
            return djangoBinFolder.getPath();
        }
        return null;
    }

    @Nullable
    public static VirtualFile findDjango(VirtualFile root) {
        return DjangoUtil.findDjango(root, 3);
    }

    @Nullable
    private static VirtualFile findDjango(final VirtualFile root, int depth) {
        final Ref result = Ref.create();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.limit((int)depth)}){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                VirtualFile rootPackage;
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2.isDirectory() && (rootPackage = DjangoUtil.findDjangoRootPackage(file2)) != null) {
                    result.set((Object)rootPackage);
                    VirtualFileVisitor.Result result2 = 1.skipTo((VirtualFile)root);
                    if (result2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return result2;
                }
                VirtualFileVisitor.Result result3 = CONTINUE;
                if (result3 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return result3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/django/util/DjangoUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/django/util/DjangoUtil$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return (VirtualFile)result.get();
    }

    @Nullable
    public static VirtualFile findDjangoRootPackage(@NotNull VirtualFile root) {
        if (root == null) {
            DjangoUtil.$$$reportNull$$$0(40);
        }
        for (VirtualFile child : root.getChildren()) {
            VirtualFile bin;
            if (!child.isDirectory() || !child.getName().equals("django") || (bin = DjangoUtil.findDjangoBin(child)) == null) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static VirtualFile findDjangoBin(@NotNull VirtualFile root) {
        if (root == null) {
            DjangoUtil.$$$reportNull$$$0(41);
        }
        for (VirtualFile child : root.getChildren()) {
            if (!child.isDirectory() || !child.getName().equals("bin")) continue;
            for (VirtualFile grandchild : child.getChildren()) {
                if (grandchild.isDirectory() || !grandchild.getName().equals("django-admin.py")) continue;
                return grandchild;
            }
        }
        return null;
    }

    public static boolean isInsideDjango(VirtualFile file2, @Nullable VirtualFile stopAt) {
        while (file2 != null) {
            if (Comparing.equal((Object)file2, (Object)stopAt)) {
                return false;
            }
            if (DjangoUtil.findDjangoRootPackage(file2) != null) {
                return true;
            }
            file2 = file2.getParent();
        }
        return false;
    }

    @Nullable
    public static String getExistingFileForName(@NotNull VirtualFile root, String path) {
        VirtualFile file2;
        if (root == null) {
            DjangoUtil.$$$reportNull$$$0(42);
        }
        if ((file2 = root.findFileByRelativePath(FileUtil.toSystemIndependentName((String)path))) != null) {
            return file2.getName();
        }
        List<String> files = DjangoUtil.getFilesInRoot(root.getPath(), FileUtilRt.getNameWithoutExtension((String)path));
        if (files.size() > 0) {
            return files.get(0);
        }
        return null;
    }

    public static List<String> getFilesInRoot(@Nullable String projectRoot, @NotNull String name) {
        File root;
        if (name == null) {
            DjangoUtil.$$$reportNull$$$0(43);
        }
        ArrayList names = Lists.newArrayList();
        if (projectRoot != null && (root = new File(projectRoot)).exists()) {
            for (File file2 : root.listFiles(new NameFileFilter(name))) {
                names.add(file2.getName());
            }
        }
        Collections.sort(names);
        return names;
    }

    @Nullable
    public static String getProjectName(PsiElement elem) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)elem);
        if (module == null) {
            return null;
        }
        DjangoFacet facet = DjangoFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        return ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectName();
    }

    public static boolean isDjangoTemplateDocument(@NotNull Document document, @NotNull Project project) {
        if (document == null) {
            DjangoUtil.$$$reportNull$$$0(44);
        }
        if (project == null) {
            DjangoUtil.$$$reportNull$$$0(45);
        }
        Ref result = Ref.create((Object)false);
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile != null) {
                result.set((Object)(psiFile.getViewProvider().getPsi((Language)DjangoTemplateLanguage.INSTANCE) != null ? 1 : 0));
            }
        });
        return (Boolean)result.get();
    }

    public static boolean isDjangoTemplateByExtension(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DjangoUtil.$$$reportNull$$$0(46);
        }
        return DjangoUtil.hasDjangoTemplateExtension(file2.getName());
    }

    public static boolean hasDjangoTemplateExtension(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        String extension = PythonStringUtil.getLastSuffix(name, ".");
        if (StringUtil.isEmpty((String)extension)) {
            return false;
        }
        FileType type = FileTypeManager.getInstance().getFileTypeByExtension(extension);
        for (FileType templateType : TEMPLATE_FILE_TYPES) {
            if (!templateType.equals(type)) continue;
            return true;
        }
        return false;
    }

    public static Presentation updateDjangoRequiredAction(AnActionEvent e) {
        Module module;
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(false);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project != null && (module = DjangoUtil.getDjangoModule(project)) != null) {
            presentation.setEnabledAndVisible(true);
            return presentation;
        }
        module = (Module)e.getData(LangDataKeys.MODULE);
        if (module != null && DjangoUtil.containsDjango(module)) {
            presentation.setEnabledAndVisible(true);
        }
        return presentation;
    }

    public static boolean containsDjango(Module module) {
        VirtualFile djangoRoot;
        VirtualFile projectRootFolderFile;
        DjangoBinSearchingPolicy policy = new DjangoBinSearchingPolicy();
        String binPath = (String)ModuleRootManager.getInstance((Module)module).processOrder((RootPolicy)policy, null);
        if (binPath != null) {
            return true;
        }
        if (DjangoUtil.getDjangoPath(ModuleRootManager.getInstance((Module)module).getContentRoots()) != null) {
            return true;
        }
        DjangoFacet djangoFacet = DjangoFacet.getInstance(module);
        return djangoFacet != null && (projectRootFolderFile = ((DjangoFacetConfiguration)djangoFacet.getConfiguration()).getProjectRootFolderFile()) != null && (djangoRoot = DjangoUtil.findDjangoRootPackage(projectRootFolderFile)) != null;
    }

    @Nullable
    public static PsiDirectory getProjectRoot(@NotNull PsiElement element) {
        Project project;
        Module module;
        if (element == null) {
            DjangoUtil.$$$reportNull$$$0(47);
        }
        if ((module = DjangoUtil.getDjangoModule(project = element.getProject())) == null) {
            return null;
        }
        VirtualFile projectRoot = VirtualFileUtil.findFile(DjangoUtil.getProjectRoot(module));
        if (projectRoot != null) {
            return PsiManager.getInstance((Project)project).findDirectory(projectRoot);
        }
        PsiFile psiFile = DjangoPsiUtil.getFile(element);
        if (psiFile == null) {
            return null;
        }
        PsiDirectory parent = psiFile.getParent();
        return parent != null ? DjangoUtil.getProjectRoot((PsiFileSystemItem)parent) : null;
    }

    @Nullable
    public static String getDjangoPath(@NotNull Module module) {
        String djangoBin;
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(48);
        }
        if ((djangoBin = (String)ModuleRootManager.getInstance((Module)module).processOrder((RootPolicy)new DjangoBinSearchingPolicy(), null)) == null) {
            djangoBin = DjangoUtil.getDjangoPath(ModuleRootManager.getInstance((Module)module).getContentRoots());
        }
        if (djangoBin != null) {
            String path = DjangoUtil.removeDjangoBin(djangoBin);
            return FileUtil.toSystemDependentName((String)path);
        }
        return null;
    }

    private static String removeDjangoBin(@NotNull String djangoBin) {
        if (djangoBin == null) {
            DjangoUtil.$$$reportNull$$$0(49);
        }
        return djangoBin.substring(0, djangoBin.length() - "django/bin".length());
    }

    public static List<String> getInstalledAppLabels(Module module) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> apps = DjangoSettingsPy.getInstalledApps(module);
        for (String app : apps) {
            result.add(DjangoUtil.getAppLabelByName(app));
        }
        return result;
    }

    @NotNull
    public static String getAppLabelByName(@NotNull String app) {
        String lastComponent;
        if (app == null) {
            DjangoUtil.$$$reportNull$$$0(50);
        }
        String string = (lastComponent = QualifiedName.fromDottedString((String)app).getLastComponent()) != null ? lastComponent : app;
        if (string == null) {
            DjangoUtil.$$$reportNull$$$0(51);
        }
        return string;
    }

    public static QualifiedName appLabelToQName(Module module, String appLabel) {
        List<String> apps = DjangoSettingsPy.getInstalledApps(module);
        for (String app : apps) {
            QualifiedName qName = QualifiedName.fromDottedString((String)app);
            if (!qName.endsWith(appLabel)) continue;
            return qName;
        }
        return null;
    }

    @NotNull
    public static List<PsiDirectory> getApplications(@NotNull Module module) {
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(52);
        }
        PyQualifiedNameResolveContext context = PyResolveImportUtil.fromModule(module).copyWithPlainDirectories();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        List list = ((StreamEx)StreamEx.of(DjangoSettingsPy.getInstalledApps(module)).flatMap(s -> PyResolveImportUtil.resolveQualifiedName(QualifiedName.fromDottedString((String)s), context).stream()).select(PsiDirectory.class).filter(directory2 -> fileIndex.isInContent(directory2.getVirtualFile()))).toList();
        if (list == null) {
            DjangoUtil.$$$reportNull$$$0(53);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/util/DjangoUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 2: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoPath";
                break;
            }
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 25: 
            case 36: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envName";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoPackage";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoBin";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequirementAtLeast";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/util/DjangoUtil";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getDjangoVersionParts";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppLabelByName";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplications";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRoot";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDjangoModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "recordUsage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "searchFolder";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "searchProjectFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "searchProjectFolder";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addDjangoPathToEnv";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getManageFile";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addDjangoSettingsToEnv";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addPyCharmSettingsModule";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addSettingsModule";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addPyCharmManageModule";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getModuleRelatedToRoot";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getCustomTestSettingsFile";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addCustomTestSettingsModule";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addModuleToEnv";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsModule";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getImportableModule";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isDjangoAvailable";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getDjangoVersionParts";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findDjangoRootPackage";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findDjangoBin";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getExistingFileForName";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getFilesInRoot";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isDjangoTemplateDocument";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isDjangoTemplateByExtension";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getDjangoPath";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "removeDjangoBin";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getAppLabelByName";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getApplications";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DjangoBinSearchingPolicy
    extends RootPolicy<String> {
        @Nullable
        public String visitJdkOrderEntry(@NotNull JdkOrderEntry jdkOrderEntry, String value2) {
            if (jdkOrderEntry == null) {
                DjangoBinSearchingPolicy.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                value2 = DjangoUtil.getDjangoPath(jdkOrderEntry.getRootFiles(OrderRootType.CLASSES));
            }
            return value2;
        }

        @Nullable
        public String visitLibraryOrderEntry(@NotNull LibraryOrderEntry libraryOrderEntry, String value2) {
            if (libraryOrderEntry == null) {
                DjangoBinSearchingPolicy.$$$reportNull$$$0(1);
            }
            if (value2 == null) {
                value2 = DjangoUtil.getDjangoPath(libraryOrderEntry.getRootFiles(OrderRootType.CLASSES));
            }
            return value2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jdkOrderEntry";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryOrderEntry";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/django/util/DjangoUtil$DjangoBinSearchingPolicy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJdkOrderEntry";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLibraryOrderEntry";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NameFileFilter
    implements FileFilter {
        private final String name;

        NameFileFilter(String name) {
            this.name = name;
        }

        @Override
        public boolean accept(File file2) {
            String name = file2.getName();
            return file2.isFile() && name.endsWith(".py") && name.contains("settings");
        }
    }

    private static class ManageFileFinder
    implements Processor<VirtualFile> {
        private VirtualFile myManageFile;

        private ManageFileFinder() {
        }

        public boolean process(VirtualFile file2) {
            if (!file2.isDirectory() && "manage.py".equals(file2.getName())) {
                this.myManageFile = file2;
                return false;
            }
            return true;
        }
    }
}

