/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.ref.url.arguments;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.django.lang.template.psi.impl.url.arguments.DjangoUrlArgument;
import com.jetbrains.django.lang.template.tags.DjangoUrlTag;
import com.jetbrains.django.model.modelApi.DjangoUrlArgumentDefinition;
import com.jetbrains.django.model.modelApi.DjangoUrlModel;
import com.jetbrains.python.BaseReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UrlArgumentReference
extends BaseReference {
    @NotNull
    private final DjangoUrlArgument myArgumentElement;

    UrlArgumentReference(@NotNull DjangoUrlArgument element) {
        if (element == null) {
            UrlArgumentReference.$$$reportNull$$$0(0);
        }
        super((PsiElement)element);
        this.myArgumentElement = element;
    }

    @Nullable
    public PsiElement resolve() {
        String name = this.myArgumentElement.getArgumentName();
        Integer index = this.myArgumentElement.getArgumentIndex();
        List<DjangoUrlArgumentDefinition<?>> arguments = this.getPatterns();
        if (arguments == null) {
            return null;
        }
        if (name != null) {
            for (DjangoUrlArgumentDefinition<?> argument : arguments) {
                if (!name.equals(argument.getName())) continue;
                return argument.getElement();
            }
        }
        if (index != null && arguments.size() > index) {
            return arguments.get(index).getElement();
        }
        return null;
    }

    @Nullable
    private DjangoUrlTag getUrlTag() {
        DjangoUrlTag urlTag = (DjangoUrlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, DjangoUrlTag.class);
        if (urlTag == null) {
            return null;
        }
        return urlTag;
    }

    @Nullable
    private List<DjangoUrlArgumentDefinition<?>> getPatterns() {
        DjangoUrlTag urlTag = this.getUrlTag();
        if (urlTag == null) {
            return null;
        }
        DjangoUrlModel url = urlTag.findAssociatedUrl();
        if (url == null) {
            return null;
        }
        return url.getArguments();
    }

    public Object @NotNull [] getVariants() {
        DjangoUrlTag urlTag = this.getUrlTag();
        if (urlTag == null) {
            if (EMPTY_ARRAY == null) {
                UrlArgumentReference.$$$reportNull$$$0(1);
            }
            return EMPTY_ARRAY;
        }
        List<DjangoUrlArgumentDefinition<?>> patternGroups = this.getPatterns();
        if (patternGroups == null) {
            if (EMPTY_ARRAY == null) {
                UrlArgumentReference.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }
        HashSet<String> candidates2 = new HashSet<String>();
        for (DjangoUrlArgumentDefinition<?> expGroup : patternGroups) {
            String groupName = expGroup.getName();
            if (groupName == null) continue;
            candidates2.add(groupName);
        }
        for (DjangoUrlArgument siblingArgument : urlTag.getArguments()) {
            String usedName = siblingArgument.getArgumentName();
            if (usedName == null) continue;
            candidates2.remove(usedName);
        }
        ArrayList<LookupElementBuilder> result = new ArrayList<LookupElementBuilder>(candidates2.size());
        for (String candidate : candidates2) {
            result.add(LookupElementBuilder.create((String)candidate).withIcon(AllIcons.Nodes.Parameter));
        }
        Object[] objectArray = result.toArray(LookupElement.EMPTY_ARRAY);
        if (objectArray == null) {
            UrlArgumentReference.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/ref/url/arguments/UrlArgumentReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/ref/url/arguments/UrlArgumentReference";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

