/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model.modelApi.templateLoaders;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.model.modelApi.templateLoaders.DjangoTemplateLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoFileSystemTemplateLoader
extends DjangoTemplateLoader {
    static final DjangoTemplateLoader INSTANCE = new DjangoFileSystemTemplateLoader(null);
    @Nullable
    private final List<VirtualFile> myForcesDirectories;

    DjangoFileSystemTemplateLoader(@Nullable Collection<VirtualFile> forcedDirectories) {
        super("django.template.loaders.filesystem.Loader");
        this.myForcesDirectories = forcedDirectories != null ? new ArrayList<VirtualFile>(forcedDirectories) : null;
    }

    @Override
    @NotNull
    public List<VirtualFile> getTemplateFolders(@NotNull DjangoModelApi djangoModelApi) {
        if (djangoModelApi == null) {
            DjangoFileSystemTemplateLoader.$$$reportNull$$$0(0);
        }
        if (this.myForcesDirectories != null) {
            List<VirtualFile> list = Collections.unmodifiableList(this.myForcesDirectories);
            if (list == null) {
                DjangoFileSystemTemplateLoader.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<String> templateDirs = DjangoSettingsPy.getOldTemplateDirs(djangoModelApi.getDjangoModule());
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        VirtualFileSystem fileSystem = djangoModelApi.getDjangoProjectRoot().getFileSystem();
        for (String templateDir : templateDirs) {
            VirtualFile dir;
            if (templateDir == null || (dir = fileSystem.findFileByPath(templateDir)) == null) continue;
            result.add(dir);
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            DjangoFileSystemTemplateLoader.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoModelApi";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/modelApi/templateLoaders/DjangoFileSystemTemplateLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/modelApi/templateLoaders/DjangoFileSystemTemplateLoader";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateFolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateFolders";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

