/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model.applications;

import com.intellij.psi.PsiDirectory;
import com.jetbrains.django.model.modelApi.DjangoModelClass;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoUnnamedApplicationModel {
    @NotNull
    protected final PsiDirectory myApplicationRootFolder;

    public DjangoUnnamedApplicationModel(@NotNull PsiDirectory applicationRootFolder) {
        if (applicationRootFolder == null) {
            DjangoUnnamedApplicationModel.$$$reportNull$$$0(0);
        }
        this.myApplicationRootFolder = applicationRootFolder;
    }

    @NotNull
    public final PsiDirectory getApplicationRootFolder() {
        PsiDirectory psiDirectory = this.myApplicationRootFolder;
        if (psiDirectory == null) {
            DjangoUnnamedApplicationModel.$$$reportNull$$$0(1);
        }
        return psiDirectory;
    }

    @NotNull
    public final List<DjangoModelClass> getModelClasses(@NotNull TypeEvalContext context) {
        PyFile model;
        if (context == null) {
            DjangoUnnamedApplicationModel.$$$reportNull$$$0(2);
        }
        if ((model = this.getModel()) == null) {
            List<DjangoModelClass> list = Collections.emptyList();
            if (list == null) {
                DjangoUnnamedApplicationModel.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<DjangoModelClass> result = DjangoUnnamedApplicationModel.getModelsFromFile(model, context);
        for (PyImportStatementBase importStatement : model.getImportBlock()) {
            PyFile file2;
            for (PyImportElement importElement : importStatement.getImportElements()) {
                PyClassType classType;
                PyTypedElement importedElement = PyUtil.as(importElement.getImportReferenceExpression(), PyTypedElement.class);
                if (importedElement == null || (classType = PyUtil.as(context.getType(importedElement), PyClassType.class)) == null || !DjangoModelClass.isModelClass(classType.getPyClass(), null)) continue;
                result.add(new DjangoModelClass(classType.getPyClass()));
            }
            if (!(importStatement instanceof PyFromImportStatement) || (file2 = DjangoUnnamedApplicationModel.getFileFromImport((PyFromImportStatement)importStatement, context)) == null) continue;
            result.addAll(DjangoUnnamedApplicationModel.getModelsFromFile(file2, context));
        }
        List<DjangoModelClass> list = result;
        if (list == null) {
            DjangoUnnamedApplicationModel.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    private static PyFile getFileFromImport(@NotNull PyFromImportStatement importStatement, @NotNull TypeEvalContext context) {
        if (importStatement == null) {
            DjangoUnnamedApplicationModel.$$$reportNull$$$0(5);
        }
        if (context == null) {
            DjangoUnnamedApplicationModel.$$$reportNull$$$0(6);
        }
        if (importStatement.getStarImportElement() == null) {
            return null;
        }
        PyReferenceExpression source2 = importStatement.getImportSource();
        if (source2 == null) {
            return null;
        }
        PyModuleType moduleType = PyUtil.as(context.getType(source2), PyModuleType.class);
        if (moduleType == null) {
            return null;
        }
        return moduleType.getModule();
    }

    @NotNull
    private static List<DjangoModelClass> getModelsFromFile(@NotNull PyFile model, @NotNull TypeEvalContext context) {
        if (model == null) {
            DjangoUnnamedApplicationModel.$$$reportNull$$$0(7);
        }
        if (context == null) {
            DjangoUnnamedApplicationModel.$$$reportNull$$$0(8);
        }
        ArrayList<DjangoModelClass> result = new ArrayList<DjangoModelClass>();
        for (PyClass possibleModelClass : model.getTopLevelClasses()) {
            if (!DjangoModelClass.isModelClass(possibleModelClass, context)) continue;
            result.add(new DjangoModelClass(possibleModelClass));
        }
        ArrayList<DjangoModelClass> arrayList = result;
        if (arrayList == null) {
            DjangoUnnamedApplicationModel.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Nullable
    public final PyFile getModel() {
        PyFile initPyInModelsFolder;
        PyFile modelsPy = PyUtil.as(this.myApplicationRootFolder.findFile("models.py"), PyFile.class);
        if (modelsPy != null) {
            return modelsPy;
        }
        PsiDirectory subdirectory = this.myApplicationRootFolder.findSubdirectory("models");
        if (subdirectory != null && (initPyInModelsFolder = PyUtil.as(subdirectory.findFile("__init__.py"), PyFile.class)) != null) {
            return initPyInModelsFolder;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationRootFolder";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/applications/DjangoUnnamedApplicationModel";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/applications/DjangoUnnamedApplicationModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationRootFolder";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelClasses";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelsFromFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModelClasses";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileFromImport";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getModelsFromFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

