/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.tags;

import com.intellij.lang.PsiBuilder;
import com.jetbrains.django.lang.template.parsing.DjangoTemplateTokenTypes;
import com.jetbrains.django.lang.template.parsing.parser.DjangoTagParser;
import com.jetbrains.django.lang.template.parsing.parser.DjangoTemplateParsing;
import com.jetbrains.django.lang.template.psi.DjangoTemplateElementTypes;
import com.jetbrains.django.lang.template.psi.impl.url.arguments.DjangoUrlArgumentsParser;
import com.jetbrains.django.ui.DjangoBundle;

public class DjangoUrlTagParser
extends DjangoTagParser<DjangoTemplateParsing> {
    @Override
    public void parse(PsiBuilder builder, PsiBuilder.Marker tagStartMarker, DjangoTemplateParsing templateParser) {
        if (templateParser.isStringLiteral()) {
            PsiBuilder.Marker urlView = builder.mark();
            templateParser.parseStringLiteral();
            urlView.done(DjangoTemplateElementTypes.URL_VIEW_IN_QUOTES);
        } else {
            PsiBuilder.Marker urlName = builder.mark();
            boolean nameParsed = true;
            if (!templateParser.parseMemberExpr(DjangoTemplateElementTypes.MEMBER_NAME)) {
                DjangoUrlTagParser.memberExpected(builder);
                nameParsed = false;
            }
            while (builder.getTokenType() == DjangoTemplateTokenTypes.COLON) {
                builder.advanceLexer();
                if (templateParser.parseMemberExpr(DjangoTemplateElementTypes.MEMBER_NAME)) continue;
                DjangoUrlTagParser.memberExpected(builder);
                nameParsed = false;
            }
            if (nameParsed) {
                urlName.done(DjangoTemplateElementTypes.URL_VIEW_NO_QUOTES);
            } else {
                urlName.drop();
            }
        }
        while (templateParser.isExpressionStart() && DjangoUrlArgumentsParser.parseUrlArgument(builder, templateParser)) {
        }
        if (builder.getTokenType() == DjangoTemplateTokenTypes.AS) {
            builder.advanceLexer();
            if (!templateParser.parseNamedExpr()) {
                builder.error(DjangoBundle.message("django.parse.error.named.expression.expected", new Object[0]));
            }
        }
        tagStartMarker.done(DjangoTemplateElementTypes.URL_TAG);
    }
}

