/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.inspection;

import com.google.common.collect.Lists;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.Consumer;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.lang.template.DjangoTemplateFileType;
import com.jetbrains.django.lang.template.DjangoTemplateFileViewProvider;
import com.jetbrains.django.lang.template.ref.DjangoStaticFileReferenceSet;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.inspections.PyUnresolvedReferenceQuickFixProvider;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnresolvedStaticReferenceInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = DjangoBundle.message("django", new Object[0]);
        if (string == null) {
            UnresolvedStaticReferenceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "DjangoUnresolvedStaticReferenceInspection";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Module module;
        FileViewProvider vp;
        if (file2 == null) {
            UnresolvedStaticReferenceInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            UnresolvedStaticReferenceInspection.$$$reportNull$$$0(2);
        }
        if (file2.getFileType().equals((Object)DjangoTemplateFileType.INSTANCE) && (vp = file2.getViewProvider()) instanceof DjangoTemplateFileViewProvider) {
            file2 = vp.getPsi(((DjangoTemplateFileViewProvider)vp).getTemplateDataLanguage());
        }
        if ((file2.getFileType().equals(HtmlFileType.INSTANCE) || file2.getFileType().equals(XmlFileType.INSTANCE)) && DjangoFacet.isPresent(module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2))) {
            UnresolvedStaticReferenceVisitor visitor2 = this.createVisitor(manager);
            file2.accept((PsiElementVisitor)visitor2);
            List<ProblemDescriptor> problems = visitor2.getProblems();
            if (!problems.isEmpty()) {
                ProblemDescriptor[] arr = new ProblemDescriptor[problems.size()];
                problems.toArray(arr);
                return arr;
            }
        }
        return super.checkFile(file2, manager, isOnTheFly);
    }

    protected UnresolvedStaticReferenceVisitor createVisitor(InspectionManager manager) {
        return new UnresolvedStaticReferenceVisitor(manager);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/lang/template/inspection/UnresolvedStaticReferenceInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/lang/template/inspection/UnresolvedStaticReferenceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UnresolvedStaticReferenceVisitor
    extends XmlRecursiveElementVisitor {
        protected final List<ProblemDescriptor> myProblems = new ArrayList<ProblemDescriptor>();
        private final InspectionManager myManager;

        public List<ProblemDescriptor> getProblems() {
            return this.myProblems;
        }

        private UnresolvedStaticReferenceVisitor(InspectionManager manager) {
            this.myManager = manager;
        }

        public void visitXmlAttributeValue(XmlAttributeValue value2) {
            for (PsiReference ref : value2.getReferences()) {
                if (!(ref instanceof DjangoStaticFileReferenceSet.DjangoStaticFileReference) || ((DjangoStaticFileReferenceSet.DjangoStaticFileReference)ref).multiResolve(false).length != 0) continue;
                this.reportUnresolvedStaticReference(ref, value2);
                break;
            }
        }

        private void reportUnresolvedStaticReference(PsiReference ref, XmlAttributeValue stringLiteral) {
            this.reportProblem(ref, (PsiElement)stringLiteral, DjangoBundle.message("inspection.unresolved-static-reference.error-msg", stringLiteral.getText()));
        }

        private void reportProblem(PsiReference ref, PsiElement elem, String msg) {
            ProblemDescriptor d = this.myManager.createProblemDescriptor(elem, new TextRange(0, elem.getTextLength()), msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, this.getQuickFixActions(ref));
            this.myProblems.add(d);
        }

        public LocalQuickFix[] getQuickFixActions(PsiReference reference) {
            ArrayList actions = Lists.newArrayList();
            for (PyUnresolvedReferenceQuickFixProvider provider : PyUnresolvedReferenceQuickFixProvider.EP_NAME.getExtensionList()) {
                provider.registerQuickFixes(reference, (Consumer<LocalQuickFix>)((Consumer)localQuickFix -> actions.add(localQuickFix)));
            }
            return actions.toArray(LocalQuickFix.EMPTY_ARRAY);
        }
    }
}

