/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.facet;

import com.intellij.DynamicBundle;
import com.intellij.facet.impl.ui.FacetErrorPanel;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UI;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.facet.DjangoStructure;
import com.jetbrains.django.facet.ManagePyEnvironmentVariablesComponent;
import com.jetbrains.django.model.applications.DjangoApplicationModel;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.model.modelApi.DjangoModelClass;
import com.jetbrains.django.model.modelApi.DjangoUrlModel;
import com.jetbrains.django.model.modelApi.templates.PyTemplateEngineSettings;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoSettingsPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance(DjangoSettingsPanel.class);
    private JPanel myPanel;
    private TextFieldWithBrowseButton myProjectRootFolder;
    private TextFieldWithBrowseButton mySettingsFileField;
    private TextFieldWithBrowseButton myManageFileField;
    private JPanel myErrorPanel;
    private ManagePyEnvironmentVariablesComponent myVariablesComponent;
    private JButton myShowStructure;
    private JBCheckBox myDoNotUseTestRunner;
    private JPanel myPlaceForFilesPattern;
    private final JBTextField myJBTrackFilePattern;
    private final FileChooserDescriptor mySettingsFileDescriptor;
    private final FileChooserDescriptor myManageFileDescriptor;
    private final TextFieldRootRelativePathAccessor textFieldAccessor;

    public DjangoSettingsPanel(final Project project) {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myJBTrackFilePattern = new JBTextField();
        this.textFieldAccessor = new TextFieldRootRelativePathAccessor();
        this.myProjectRootFolder.addBrowseFolderListener(DjangoBundle.message("select-root-folder-title", new Object[0]), DjangoBundle.message("select-root-folder-desc", new Object[0]), project, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.mySettingsFileDescriptor = FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor();
        this.myManageFileDescriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)PythonFileType.INSTANCE);
        this.mySettingsFileField.addBrowseFolderListener(DjangoBundle.message("django.select.settings.file", new Object[0]), "", project, this.mySettingsFileDescriptor, (TextComponentAccessor)this.textFieldAccessor);
        this.mySettingsFileField.setEditable(false);
        this.myManageFileField.addBrowseFolderListener(DjangoBundle.message("django.select.manage.script", new Object[0]), "", project, this.myManageFileDescriptor, (TextComponentAccessor)this.textFieldAccessor);
        this.myManageFileField.setEditable(false);
        this.myProjectRootFolder.getTextField().getDocument().addDocumentListener(this.createProjectRootDocumentListener());
        this.initErrorValidation();
        this.myShowStructure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event2) {
                DjangoStructure.show(DjangoSettingsPanel.generateTypeModel(project), DjangoSettingsPanel.this.myPanel);
            }
        });
        this.add((Component)this.myPanel, "Center");
        JPanel trackFilesPanel = UI.PanelFactory.panel((JComponent)this.myJBTrackFilePattern).withComment(DjangoBundle.message("settings.file-tracking.comment", new Object[0])).createPanel();
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.weightx = 1.0;
        cons.gridx = 0;
        this.myPlaceForFilesPattern.add((Component)trackFilesPanel, cons);
    }

    @NotNull
    private static Collection<DjangoModelApi> getApisByProject(@NotNull Project project) {
        if (project == null) {
            DjangoSettingsPanel.$$$reportNull$$$0(0);
        }
        ArrayList<DjangoModelApi> result = new ArrayList<DjangoModelApi>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            DjangoModelApi api = DjangoModelApi.create(module).getSuccessOrNull();
            if (api == null) continue;
            result.add(api);
        }
        ArrayList<DjangoModelApi> arrayList = result;
        if (arrayList == null) {
            DjangoSettingsPanel.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    private static javax.swing.tree.TreeModel generateTypeModel(@NotNull Project project) {
        if (project == null) {
            DjangoSettingsPanel.$$$reportNull$$$0(2);
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Structure");
        for (DjangoModelApi api : DjangoSettingsPanel.getApisByProject(project)) {
            DefaultMutableTreeNode applications = new DefaultMutableTreeNode("applications");
            DefaultMutableTreeNode models = new DefaultMutableTreeNode("models");
            DefaultMutableTreeNode urls = new DefaultMutableTreeNode("urls");
            DefaultMutableTreeNode templateFolders = new DefaultMutableTreeNode("template folders");
            DefaultMutableTreeNode templateEngines = new DefaultMutableTreeNode("template engines");
            for (DjangoApplicationModel djangoApplicationModel : api.getApplications()) {
                applications.add(new DefaultMutableTreeNode(djangoApplicationModel.getName()));
            }
            for (DjangoModelClass djangoModelClass : api.getModelClasses(TypeEvalContext.userInitiated(project, null))) {
                PyClass pyClass = djangoModelClass.getPyClass();
                String name = pyClass.getName();
                if (name == null) {
                    name = pyClass.getQualifiedName();
                }
                if (name == null) continue;
                models.add(new DefaultMutableTreeNode(name));
            }
            DjangoSettingsPanel.addUrlsToNode(api.getRootUrls(), urls);
            for (Pair pair : api.getTemplateFolders()) {
                VirtualFile file2 = (VirtualFile)pair.first;
                if (file2 == null) continue;
                templateFolders.add(new DefaultMutableTreeNode(file2.getPath()));
            }
            PyTemplateEngineSettings.getSettings(api.getDjangoModule()).stream().map(settings -> new DefaultMutableTreeNode(settings.toString())).forEach(templateEngines::add);
            root.add(applications);
            root.add(models);
            root.add(urls);
            root.add(templateFolders);
            root.add(templateEngines);
        }
        return new TreeModel((TreeNode)root);
    }

    private static void addUrlsToNode(@NotNull Collection<DjangoUrlModel> urls, @NotNull DefaultMutableTreeNode where) {
        if (urls == null) {
            DjangoSettingsPanel.$$$reportNull$$$0(3);
        }
        if (where == null) {
            DjangoSettingsPanel.$$$reportNull$$$0(4);
        }
        for (DjangoUrlModel urlModel : DjangoSettingsPanel.flatUnnamedUrls(urls)) {
            PyExpression expression = urlModel.getUrlNameExpression();
            if (expression == null) continue;
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(expression.getText());
            where.add(child);
            DjangoSettingsPanel.addUrlsToNode(urlModel.getSubUrls(), child);
        }
    }

    @NotNull
    private static List<DjangoUrlModel> flatUnnamedUrls(@NotNull Collection<DjangoUrlModel> urls) {
        if (urls == null) {
            DjangoSettingsPanel.$$$reportNull$$$0(5);
        }
        StreamEx normalUrls = (StreamEx)StreamEx.of(urls).filter(url -> url.getUrlNameExpression() != null);
        StreamEx unnamedUrls = (StreamEx)StreamEx.of(urls).filter(url -> url.getUrlNameExpression() == null);
        List list = ((StreamEx)StreamEx.of((Stream)unnamedUrls).flatMap(url -> url.getSubUrls().stream()).append((Stream)normalUrls)).toList();
        if (list == null) {
            DjangoSettingsPanel.$$$reportNull$$$0(6);
        }
        return list;
    }

    private void initErrorValidation() {
        this.myShowStructure.setVisible(false);
        FacetErrorPanel facetErrorPanel = new FacetErrorPanel();
        this.myErrorPanel.add((Component)facetErrorPanel.getComponent(), "Center");
        facetErrorPanel.addListener(() -> this.myShowStructure.setVisible(facetErrorPanel.isOk()));
        facetErrorPanel.getValidatorsManager().registerValidator(new FacetEditorValidator(){

            @NotNull
            public ValidationResult check() {
                ValidationResult validationResult = DjangoSettingsPanel.validateProjectRoot(DjangoSettingsPanel.this.myProjectRootFolder.getText());
                if (validationResult == null) {
                    2.$$$reportNull$$$0(0);
                }
                return validationResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/django/facet/DjangoSettingsPanel$2", "check"));
            }
        }, new JComponent[]{this.myProjectRootFolder});
        facetErrorPanel.getValidatorsManager().registerValidator(new FacetEditorValidator(){

            @NotNull
            public ValidationResult check() {
                ValidationResult validationResult = DjangoSettingsPanel.this.validateSettings("settings file", DjangoSettingsPanel.this.mySettingsFileField.getText());
                if (validationResult == null) {
                    3.$$$reportNull$$$0(0);
                }
                return validationResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/django/facet/DjangoSettingsPanel$3", "check"));
            }
        }, new JComponent[]{this.mySettingsFileField.getTextField()});
        facetErrorPanel.getValidatorsManager().registerValidator(new FacetEditorValidator(){

            @NotNull
            public ValidationResult check() {
                ValidationResult validationResult = DjangoSettingsPanel.this.validateManage("manage script", DjangoSettingsPanel.this.myManageFileField.getText());
                if (validationResult == null) {
                    4.$$$reportNull$$$0(0);
                }
                return validationResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/django/facet/DjangoSettingsPanel$4", "check"));
            }
        }, new JComponent[]{this.myManageFileField.getTextField()});
        facetErrorPanel.getValidatorsManager().validate();
    }

    private ValidationResult validateSettings(String name, String value2) {
        String file2;
        if (StringUtil.isEmpty((String)value2)) {
            return new ValidationResult(DjangoBundle.message("settings.no.value.validation.error.message", name));
        }
        String root = this.myProjectRootFolder.getText();
        VirtualFile rootFile = VirtualFileUtil.findFile(root);
        if (rootFile != null && (file2 = DjangoUtil.getExistingFileForName(rootFile, value2)) != null) {
            return ValidationResult.OK;
        }
        return new ValidationResult(DjangoBundle.message("settings.no.value.for.name.validation.error.message", name, value2));
    }

    private ValidationResult validateManage(String name, String value2) {
        if (StringUtil.isEmpty((String)value2)) {
            return new ValidationResult(DjangoBundle.message("settings.no.manage.value.validation.error.message", name));
        }
        return ValidationResult.OK;
    }

    private static ValidationResult validateProjectRoot(@Nullable String text2) {
        if (StringUtil.isEmpty((String)text2)) {
            return new ValidationResult(DjangoBundle.message("settings.project.root.validation.error.message", new Object[0]));
        }
        if (!new File(text2).exists()) {
            return new ValidationResult(DjangoBundle.message("settings.no.project.root.dir.validation.error.message", new Object[0]));
        }
        if (!new File(text2).isDirectory()) {
            return new ValidationResult(DjangoBundle.message("settings.project.root.dir.validation.error.message", new Object[0]));
        }
        return ValidationResult.OK;
    }

    private DocumentListener createProjectRootDocumentListener() {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                String root = DjangoSettingsPanel.this.myProjectRootFolder.getText();
                VirtualFile rootFile = VirtualFileUtil.findFile(root);
                if (rootFile != null) {
                    DjangoSettingsPanel.this.textFieldAccessor.setRoot(rootFile);
                    DjangoSettingsPanel.this.updateSettingsFile(rootFile);
                    DjangoSettingsPanel.this.updateManageFile(rootFile);
                }
            }
        };
    }

    private void updateSettingsFile(@NotNull VirtualFile rootFile) {
        if (rootFile == null) {
            DjangoSettingsPanel.$$$reportNull$$$0(7);
        }
        this.mySettingsFileDescriptor.setRoots(new VirtualFile[]{rootFile});
        DjangoSettingsPanel.updateDescriptorAndField(this.mySettingsFileDescriptor, this.mySettingsFileField, this.textFieldAccessor, "settings.py", rootFile);
    }

    private void updateManageFile(@NotNull VirtualFile rootFile) {
        if (rootFile == null) {
            DjangoSettingsPanel.$$$reportNull$$$0(8);
        }
        DjangoSettingsPanel.updateDescriptorAndField(this.myManageFileDescriptor, this.myManageFileField, this.textFieldAccessor, "manage.py", rootFile);
    }

    private static void updateDescriptorAndField(FileChooserDescriptor descriptor2, TextFieldWithBrowseButton textField, TextFieldRootRelativePathAccessor textFieldAccessor, String name, @NotNull VirtualFile rootFile) {
        String file2;
        if (rootFile == null) {
            DjangoSettingsPanel.$$$reportNull$$$0(9);
        }
        if ((file2 = DjangoUtil.getExistingFileForName(rootFile, name)) != null) {
            VirtualFile fileToSelect = rootFile.findChild(file2);
            descriptor2.getFileToSelect(fileToSelect);
            textFieldAccessor.setText(textField.getTextField(), file2);
        }
    }

    public void setProjectRootFolder(String folder) {
        this.myProjectRootFolder.setText(folder != null ? FileUtil.toSystemDependentName((String)folder) : "");
    }

    @Nullable
    private String getSettingsModule() {
        return DjangoSettingsPanel.getPathRelativeToDjangoRoot(this.mySettingsFileField.getText());
    }

    @Nullable
    private String getManageScript() {
        return DjangoSettingsPanel.getPathRelativeToDjangoRoot(this.myManageFileField.getText());
    }

    @Nullable
    private static String getPathRelativeToDjangoRoot(String path) {
        return FileUtil.toSystemIndependentName((String)path);
    }

    public void setSettingsModule(@Nullable String settingsFileRelPath) {
        this.setRelativePathToField(this.mySettingsFileField, settingsFileRelPath);
    }

    public void setManageScript(@Nullable String manageFileRelPath) {
        this.setRelativePathToField(this.myManageFileField, manageFileRelPath);
    }

    public void setTrackFilePattern(@NotNull String trackFilePattern) {
        if (trackFilePattern == null) {
            DjangoSettingsPanel.$$$reportNull$$$0(10);
        }
        this.myJBTrackFilePattern.setText(trackFilePattern);
    }

    @NotNull
    public String getTrackFilePattern() {
        String string = this.myJBTrackFilePattern.getText();
        if (string == null) {
            DjangoSettingsPanel.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void setRelativePathToField(@NotNull TextFieldWithBrowseButton textField, @Nullable String settingsFileRelPath) {
        VirtualFile settingsFile;
        VirtualFile root;
        if (textField == null) {
            DjangoSettingsPanel.$$$reportNull$$$0(12);
        }
        if ((root = VirtualFileUtil.findFile(this.myProjectRootFolder.getText())) != null && settingsFileRelPath != null && (settingsFile = root.findFileByRelativePath(FileUtil.toSystemIndependentName((String)settingsFileRelPath))) != null) {
            this.textFieldAccessor.setText(textField.getTextField(), FileUtil.toSystemDependentName((String)settingsFile.getPath()));
            return;
        }
        VirtualFile vFile = VirtualFileUtil.findFile(settingsFileRelPath);
        if (vFile != null) {
            textField.setText(settingsFileRelPath);
            return;
        }
        textField.setText("");
    }

    public void reset(DjangoFacetConfiguration config) {
        if (config != null) {
            VirtualFile file2 = config.getProjectRootFolderFile();
            this.setProjectRootFolder(file2 != null ? file2.getPath() : "");
            this.setSettingsModule(config.getSettingsFilePath());
            this.setManageScript(config.getManageFilePath());
            this.setTrackFilePattern(config.getTrackFilePattern());
            this.myVariablesComponent.setEnvs(config.getEnvVariables());
            this.myDoNotUseTestRunner.getModel().setSelected(config.doNotUseTestRunner());
        }
    }

    public boolean isModified(DjangoFacetConfiguration configuration) {
        return !Comparing.equal((String)this.getSettingsModule(), (String)configuration.getSettingsFilePath()) || !Comparing.equal((String)this.getManageScript(), (String)configuration.getManageFilePath()) || !Comparing.equal((String)this.getTrackFilePattern(), (String)configuration.getTrackFilePattern()) || this.myDoNotUseTestRunner.getModel().isSelected() != configuration.doNotUseTestRunner() || !Comparing.equal((Object)this.getProjectRootFolder(), (Object)configuration.getProjectRootFolderFile()) || !Comparing.equal((Object)this.myVariablesComponent.getEnvs(), configuration.getEnvVariables());
    }

    @Nullable
    private VirtualFile getProjectRootFolder() {
        return VirtualFileUtil.findFile(this.myProjectRootFolder.getText());
    }

    public void apply(DjangoFacetConfiguration configuration) {
        configuration.setSettingsFilePath(this.getSettingsModule());
        configuration.setManageFilePath(this.getManageScript());
        configuration.setTrackFilePattern(this.getTrackFilePattern());
        configuration.setProjectRootFolderFile(this.getProjectRootFolder());
        configuration.setEnvVariables(this.myVariablesComponent.getEnvs());
        configuration.setDoNotUseTestRunner(this.myDoNotUseTestRunner.getModel().isSelected());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JButton jButton;
        JPanel jPanel2;
        ManagePyEnvironmentVariablesComponent managePyEnvironmentVariablesComponent;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(9, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoSettingsPanel.class).getString("django-root-folder"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(193, 14), null));
        this.myProjectRootFolder = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 0, null, null, null));
        this.mySettingsFileField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myManageFileField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 2, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoSettingsPanel.class).getString("settings-module"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(193, 14), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoSettingsPanel.class).getString("manage-script"));
        jPanel3.add((Component)jLabel3, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(193, 14), null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(8, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myVariablesComponent = managePyEnvironmentVariablesComponent = new ManagePyEnvironmentVariablesComponent();
        jPanel3.add((Component)((Object)managePyEnvironmentVariablesComponent), new GridConstraints(5, 2, 1, 1, 0, 1, 7, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoSettingsPanel.class).getString("django.manage.py.env.settings"));
        jPanel3.add((Component)jLabel4, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(193, 14), null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoSettingsPanel.class).getString("django.manage.py"));
        jPanel3.add((Component)titledSeparator, new GridConstraints(3, 0, 1, 3, 0, 1, 7, 0, null, null, null));
        this.myErrorPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(7, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, "South");
        this.myShowStructure = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoSettingsPanel.class).getString("django.settings.show.structure"));
        jPanel4.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoSettingsPanel.class).getString("django.settings.dont.use.testrunner"));
        jPanel3.add((Component)jBLabel, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDoNotUseTestRunner = jBCheckBox = new JBCheckBox();
        jPanel3.add((Component)jBCheckBox, new GridConstraints(2, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoSettingsPanel.class).getString("django.settings.folder.pattern"));
        jPanel3.add((Component)jBLabel2, new GridConstraints(6, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPlaceForFilesPattern = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel3.add((Component)jPanel, new GridConstraints(6, 2, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/facet/DjangoSettingsPanel";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackFilePattern";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/facet/DjangoSettingsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getApisByProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "flatUnnamedUrls";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrackFilePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getApisByProject";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generateTypeModel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addUrlsToNode";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "flatUnnamedUrls";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateSettingsFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateManageFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateDescriptorAndField";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setTrackFilePattern";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setRelativePathToField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class TextFieldRootRelativePathAccessor
    implements TextComponentAccessor<JTextField> {
        private VirtualFile myRoot;

        TextFieldRootRelativePathAccessor() {
        }

        public void setRoot(@NotNull VirtualFile root) {
            if (root == null) {
                TextFieldRootRelativePathAccessor.$$$reportNull$$$0(0);
            }
            this.myRoot = root;
        }

        public String getText(JTextField textField) {
            return this.myRoot == null ? textField.getText() : VirtualFileUtil.getAbsolutePath(this.myRoot, textField.getText());
        }

        public void setText(JTextField textField, @NotNull String text2) {
            if (text2 == null) {
                TextFieldRootRelativePathAccessor.$$$reportNull$$$0(1);
            }
            String path = this.myRoot == null ? text2 : VirtualFileUtil.getRelativePath(this.myRoot, text2);
            textField.setText(FileUtil.toSystemDependentName((String)path));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/django/facet/DjangoSettingsPanel$TextFieldRootRelativePathAccessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setRoot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

