/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.console;

import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.jetbrains.django.console.DjangoConsoleOptions;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.buildout.BuildoutFacet;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleType;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PydevConsoleRunnerFactory;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoAwarePythonConsoleRunnerFactory
extends PydevConsoleRunnerFactory {
    @NonNls
    public static final String PROJECT_ROOT = "PROJECT_ROOT";
    @NonNls
    public static final String DJANGO_CONSOLE_START_COMMAND = "import sys; print('Python %s on %s' % (sys.version, sys.platform))\nimport django; print('Django %s' % django.get_version())\nsys.path.extend([WORKING_DIR_AND_PYTHON_PATHS])\nif 'setup' in dir(django): django.setup()\nimport django_manage_shell; django_manage_shell.run(PROJECT_ROOT)";
    @NonNls
    public static final String DJANGO_PROJECT_SETTINGS = "DJANGO_PROJECT_SETTINGS";

    public static String getSettings(@NotNull Module module) {
        if (module == null) {
            DjangoAwarePythonConsoleRunnerFactory.$$$reportNull$$$0(0);
        }
        return DjangoUtil.getSettingsModule(module);
    }

    @NotNull
    private static Module getModule(@NotNull Project project, @Nullable Module m) {
        Module module;
        String moduleName;
        if (project == null) {
            DjangoAwarePythonConsoleRunnerFactory.$$$reportNull$$$0(1);
        }
        if ((moduleName = DjangoConsoleOptions.getInstance(project).getState().getModuleName()) != null && (module = ModuleManager.getInstance((Project)project).findModuleByName(moduleName)) != null) {
            Module module2 = module;
            if (module2 == null) {
                DjangoAwarePythonConsoleRunnerFactory.$$$reportNull$$$0(2);
            }
            return module2;
        }
        if (m != null && DjangoFacet.isPresent(m)) {
            Module module3 = m;
            if (module3 == null) {
                DjangoAwarePythonConsoleRunnerFactory.$$$reportNull$$$0(3);
            }
            return module3;
        }
        module = DjangoUtil.getDjangoModule(project);
        if (module != null) {
            Module module4 = module;
            if (module4 == null) {
                DjangoAwarePythonConsoleRunnerFactory.$$$reportNull$$$0(4);
            }
            return module4;
        }
        throw new AssertionError((Object)"Can't get here");
    }

    @Override
    protected PydevConsoleRunnerFactory.ConsoleParameters createConsoleParameters(@NotNull Project project, @Nullable Module contextModule) {
        if (project == null) {
            DjangoAwarePythonConsoleRunnerFactory.$$$reportNull$$$0(5);
        }
        if (DjangoFacet.isPresentInAnyModule(project)) {
            return this.createDjangoConsoleParameters(DjangoAwarePythonConsoleRunnerFactory.getModule(project, contextModule));
        }
        return super.createConsoleParameters(project, contextModule);
    }

    private PydevConsoleRunnerFactory.ConsoleParameters createDjangoConsoleParameters(@NotNull Module module) {
        String customStartScript;
        List path;
        if (module == null) {
            DjangoAwarePythonConsoleRunnerFactory.$$$reportNull$$$0(6);
        }
        TransactionGuard.submitTransaction((Disposable)module, () -> FileDocumentManager.getInstance().saveAllDocuments());
        Project project = module.getProject();
        PyConsoleOptions.PyConsoleSettings settingsProvider = DjangoConsoleOptions.getInstance(project).getState();
        VirtualFile manageFile = DjangoUtil.getManageFile(module);
        String projectRoot = null;
        if (manageFile != null) {
            projectRoot = manageFile.getParent().getPath();
        }
        if (projectRoot == null) {
            projectRoot = DjangoUtil.getProjectRoot(module);
        }
        Sdk sdk = null;
        String sdkHome = settingsProvider.getSdkHome();
        if (sdkHome != null) {
            sdk = PythonSdkUtil.findSdkByPath(sdkHome);
        }
        if (sdk == null) {
            sdk = PythonSdkUtil.findPythonSdk(module);
        }
        assert (sdk != null) : String.format("Python SDK does not exist in home %s nor in module %s", sdkHome, module);
        ArrayList setupFragment = Lists.newArrayList();
        PyRemotePathMapper pathMapper = PydevConsoleRunner.getPathMapper(project, sdk, settingsProvider);
        BuildoutFacet facet = BuildoutFacet.getInstance(module);
        if (facet != null && (path = facet.getAdditionalPythonPath()) != null) {
            if (pathMapper != null) {
                path = pathMapper.convertToRemote(path);
            }
            setupFragment.add(facet.getPathPrependStatement(path));
        }
        path = DjangoAwarePythonConsoleRunnerFactory.createAppendPath(module, settingsProvider);
        if (pathMapper != null) {
            path = pathMapper.convertToRemote(path);
        }
        if ((customStartScript = settingsProvider.getCustomStartScript()).trim().length() > 0) {
            customStartScript = "\n" + customStartScript;
        }
        if (pathMapper != null && projectRoot != null) {
            projectRoot = pathMapper.convertToRemote(projectRoot);
        }
        setupFragment.add(DjangoAwarePythonConsoleRunnerFactory.constructPythonPathCommand(path, customStartScript, projectRoot, DjangoAwarePythonConsoleRunnerFactory.getSettings(module)));
        HashMap envs = Maps.newHashMap(settingsProvider.getEnvs());
        Map<String, String> environmentVariables = PydevConsoleRunner.addDefaultEnvironments(sdk, envs, project);
        DjangoUtil.addDjangoSettingsToEnv(module, environmentVariables);
        environmentVariables.put("IPYTHONENABLE", PyConsoleOptions.getInstance(project).isIpythonEnabled() ? "True" : "False");
        String root = DjangoUtil.getProjectRoot(module);
        if (pathMapper != null && root != null) {
            root = pathMapper.convertToRemote(root);
        }
        Consumer rerunAction = s -> {
            PydevConsoleRunner runner = this.createConsoleRunner(project, module);
            ((PydevConsoleRunnerImpl)runner).setConsoleTitle((String)s);
            runner.run(true);
        };
        PyConsoleType django = new PyConsoleType("django", DjangoBundle.message("django.console", new Object[0]));
        return new PydevConsoleRunnerFactory.ConsoleParameters(project, sdk, root, envs, django, settingsProvider, (Consumer<String>)rerunAction, ArrayUtilRt.toStringArray((Collection)setupFragment));
    }

    private static String constructPythonPathCommand(Collection<String> pythonPath, String command, String projectRoot, String settings) {
        String path = Joiner.on((String)", ").join((Iterable)Collections2.transform(pythonPath, input -> "'" + input.replace("\\", "\\\\").replace("'", "\\'") + "'"));
        return command.replace("WORKING_DIR_AND_PYTHON_PATHS", path).replace(PROJECT_ROOT, "\"" + projectRoot + "\"").replace(DJANGO_PROJECT_SETTINGS, settings);
    }

    private static Collection<String> createAppendPath(Module module, PyConsoleOptions.PyConsoleSettings settingsProvider) {
        Collection<String> path = PythonCommandLineState.collectPythonPath(module, settingsProvider.shouldAddContentRoots(), settingsProvider.shouldAddSourceRoots());
        String projectRoot = DjangoUtil.getProjectRoot(module);
        if (projectRoot != null) {
            path.add(FileUtil.toSystemDependentName((String)PathUtil.getCanonicalPath((String)projectRoot)));
        }
        path.add(PythonHelpersLocator.getHelperPath("pycharm"));
        path.add(PythonHelpersLocator.getHelperPath("pydev"));
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/console/DjangoAwarePythonConsoleRunnerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/console/DjangoAwarePythonConsoleRunnerFactory";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleParameters";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDjangoConsoleParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

