/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.codeInsight;

import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.django.DjangoFQNamesProvider;
import com.jetbrains.django.DjangoFunctionParams;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.model.DjangoMeta;
import com.jetbrains.django.model.DjangoModel;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.extensions.python.PyClassExtKt;
import com.jetbrains.extensions.python.PyFunctionExtKt;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class DjangoInspectionExtension
extends PyInspectionExtension {
    @NotNull
    private static final Set<String> VIEW_METHODS = Sets.newHashSet((Object[])new String[]{"get", "post", "put", "delete", "options", "http_method_not_allowed", "dispatch"});
    @NotNull
    private static final EnumSet<DjangoFunctionParams> PARAMS_TO_IGNORE = EnumSet.of(DjangoFunctionParams.VIEW_REQUEST, DjangoFunctionParams.VIEW_ARGS, DjangoFunctionParams.VIEW_KWARGS);

    @Override
    public boolean ignoreUnused(@NotNull PsiElement local, @NotNull TypeEvalContext evalContext) {
        PyClass pyClass;
        if (local == null) {
            DjangoInspectionExtension.$$$reportNull$$$0(0);
        }
        if (evalContext == null) {
            DjangoInspectionExtension.$$$reportNull$$$0(1);
        }
        if (!(local instanceof PyNamedParameter)) {
            return false;
        }
        PyFunction function = (PyFunction)ObjectUtils.tryCast((Object)ScopeUtil.getScopeOwner(local), PyFunction.class);
        if (function == null) {
            return false;
        }
        if (!DjangoFacet.isPresent(local)) {
            return false;
        }
        PsiFile containingFile = local.getContainingFile();
        boolean viewFile = "views.py".equals(containingFile.getName());
        boolean viewClass = false;
        if (!viewFile && (pyClass = function.getContainingClass()) != null && PyClassExtKt.inherits(pyClass, evalContext, DjangoFQNamesProvider.VIEW_CLASS)) {
            viewClass = VIEW_METHODS.contains(function.getName());
        }
        if (!viewFile && !viewClass) {
            return false;
        }
        for (DjangoFunctionParams param : PARAMS_TO_IGNORE) {
            if (PyFunctionExtKt.getParameter(function, param) != local) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean ignoreMissingDocstring(PyDocStringOwner docStringOwner) {
        if (docStringOwner instanceof PyClass) {
            PyClass outerClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)docStringOwner, PyClass.class);
            return DjangoModel.isDjangoModelDescendant(outerClass, null) && DjangoMeta.isMetaClass((PyClass)docStringOwner);
        }
        return false;
    }

    @Override
    public List<String> getFunctionParametersFromUsage(PsiElement elt) {
        PsiFile sourceFile = elt.getContainingFile();
        if (sourceFile != null && "urls.py".equals(sourceFile.getName()) && DjangoFacet.isPresent((PsiElement)sourceFile)) {
            return Collections.singletonList("request");
        }
        return null;
    }

    @Override
    public boolean ignoreProtectedSymbol(@NotNull PyReferenceExpression expression, @NotNull TypeEvalContext context) {
        DjangoModelApi api;
        if (expression == null) {
            DjangoInspectionExtension.$$$reportNull$$$0(2);
        }
        if (context == null) {
            DjangoInspectionExtension.$$$reportNull$$$0(3);
        }
        if ((api = DjangoModelApi.create(expression).getSuccessOrNull()) == null) {
            return false;
        }
        if (!api.isDjangoPackageMatches(DjangoUtil.createRequirementAtLeast(1, 8), false)) {
            return false;
        }
        return DjangoModel.META.isReferenceToMe((PsiReference)expression.getReference());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evalContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/django/codeInsight/DjangoInspectionExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "ignoreUnused";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "ignoreProtectedSymbol";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

