/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.annotator;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.daemon.DefaultGutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.lang.template.psi.impl.DjangoTemplateFileImpl;
import com.jetbrains.django.model.DjangoTemplateManager;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.templateLanguages.TemplateFileReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoTemplateReferenceLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (element == null) {
            DjangoTemplateReferenceLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            DjangoTemplateReferenceLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (DjangoFacet.isPresent(element)) {
            DjangoTemplateReferenceLineMarkerProvider.collectLineMarkersForElement(result, element);
        }
    }

    public static void collectLineMarkersForElement(Collection<? super RelatedItemLineMarkerInfo> result, PsiElement element) {
        String templateName;
        if (!DjangoFacet.isPresent(element)) {
            return;
        }
        TypeEvalContext context = TypeEvalContext.codeAnalysis(element.getProject(), element.getContainingFile());
        if (element instanceof PyStringLiteralExpression) {
            DjangoTemplateReferenceLineMarkerProvider.addMarkerForStringLiteral(result, (PyStringLiteralExpression)element);
            return;
        }
        PyClass classView = null;
        PsiElement identifier = null;
        PyCallExpression callExpression = null;
        if (element instanceof PyClass) {
            classView = (PyClass)element;
            identifier = classView.getNameIdentifier();
        } else if (element instanceof PyReferenceExpression) {
            PyReferenceExpression referenceExpression = (PyReferenceExpression)element;
            callExpression = PyUtil.as(referenceExpression.getParent(), PyCallExpression.class);
            if (!"as_view".equals(referenceExpression.getName()) || callExpression == null) {
                return;
            }
            PyExpression qualifier = referenceExpression.getQualifier();
            if (qualifier == null) {
                return;
            }
            PyType type = context.getType(qualifier);
            if (type instanceof PyClassType) {
                classView = ((PyClassType)type).getPyClass();
                identifier = PsiTreeUtil.getDeepestFirst((PsiElement)referenceExpression);
            }
        }
        if (classView != null && identifier != null && (templateName = DjangoTemplateReferenceLineMarkerProvider.getTemplateNameForClassBasedView(callExpression, classView, context)) != null) {
            DjangoTemplateReferenceLineMarkerProvider.addMarker(result, identifier, templateName);
        }
    }

    private static void addMarkerForStringLiteral(Collection<? super RelatedItemLineMarkerInfo> result, PyStringLiteralExpression element) {
        if (DjangoTemplateManager.isTemplateReference(element)) {
            for (PsiReference ref : element.getReferences()) {
                PsiElement file2;
                if (!(ref instanceof TemplateFileReference) || !DjangoUtil.hasDjangoTemplateExtension(((TemplateFileReference)ref).getText()) || !((file2 = ref.resolve()) instanceof DjangoTemplateFileImpl)) continue;
                result.add(DjangoTemplateReferenceLineMarkerProvider.createTemplateNavigationLineMarker(PsiTreeUtil.getDeepestFirst((PsiElement)element), Lists.newArrayList((Object[])new PsiFile[]{(PsiFile)file2})));
            }
        }
    }

    private static void addMarker(Collection<? super RelatedItemLineMarkerInfo> result, PsiElement urlPatternTarget, String name) {
        RelatedItemLineMarkerInfo<PsiElement> info = DjangoTemplateReferenceLineMarkerProvider.createTemplateNavigationLineMarker(urlPatternTarget, Collections.singletonList(name));
        if (info != null) {
            result.add(info);
        }
    }

    @Nullable
    private static String getTemplateNameForClassBasedView(@Nullable PyCallExpression call, @NotNull PyClass viewClass, @NotNull TypeEvalContext context) {
        if (viewClass == null) {
            DjangoTemplateReferenceLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (context == null) {
            DjangoTemplateReferenceLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (viewClass.isSubclass("django.views.generic.list.MultipleObjectTemplateResponseMixin", context) || viewClass.isSubclass("django.views.generic.detail.SingleObjectTemplateResponseMixin", context)) {
            String className;
            PyClassType classType;
            QualifiedName appQName;
            if (DjangoTemplateReferenceLineMarkerProvider.getKeywordArgOrClassAttributeString(call, viewClass, "template_name") != null) {
                return null;
            }
            String templateNameSuffix = DjangoTemplateReferenceLineMarkerProvider.getKeywordArgOrClassAttributeString(call, viewClass, "template_name_suffix");
            PyExpression model = DjangoTemplateReferenceLineMarkerProvider.getKeywordArgOrClassAttribute(call, viewClass, "model", context);
            PyClass cls = DjangoTemplateReferenceLineMarkerProvider.getModelClass(model, viewClass.getProject());
            if (templateNameSuffix != null && cls != null && (appQName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)cls.getContainingFile().getContainingDirectory())) != null && appQName.getComponentCount() > 0 && (classType = PyUtil.as(context.getType(model), PyClassType.class)) != null && (className = classType.getPyClass().getName()) != null) {
                return appQName.getLastComponent() + '/' + className.toLowerCase(Locale.getDefault()) + templateNameSuffix + ".html";
            }
        }
        return null;
    }

    @Nullable
    private static PyClass getModelClass(@Nullable PyExpression model, @NotNull Project project) {
        if (project == null) {
            DjangoTemplateReferenceLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (model == null) {
            return null;
        }
        PyType type = TypeEvalContext.deepCodeInsight(project).getType(model);
        if (type instanceof PyClassType) {
            return ((PyClassType)type).getPyClass();
        }
        return null;
    }

    @Nullable
    private static String getKeywordArgOrClassAttributeString(@Nullable PyCallExpression call, PyClass viewClass, String name) {
        return PyPsiUtils.strValue(DjangoTemplateReferenceLineMarkerProvider.getKeywordArgOrClassAttribute(call, viewClass, name, null));
    }

    @Nullable
    private static PyExpression getKeywordArgOrClassAttribute(@Nullable PyCallExpression call, PyClass viewClass, String name, @Nullable TypeEvalContext context) {
        PyExpression keywordArg;
        if (call != null && (keywordArg = call.getKeywordArgument(name)) != null) {
            return keywordArg;
        }
        PyTargetExpression classAttr = viewClass.findClassAttribute(name, true, context);
        if (classAttr != null) {
            return classAttr.findAssignedValue();
        }
        return null;
    }

    @Nullable
    private static <T extends PsiElement> RelatedItemLineMarkerInfo<T> createTemplateNavigationLineMarker(T element, Collection<String> names) {
        Module module = ModuleUtilCore.findModuleForPsiElement(element);
        if (module == null) {
            return null;
        }
        List<PsiFile> templates = DjangoTemplateReferenceLineMarkerProvider.getTemplates(module, names);
        return DjangoTemplateReferenceLineMarkerProvider.createTemplateNavigationLineMarker(element, templates);
    }

    @Nullable
    private static <T extends PsiElement> RelatedItemLineMarkerInfo<T> createTemplateNavigationLineMarker(T element, List<PsiFile> templates) {
        if (templates != null && !templates.isEmpty()) {
            PsiFile template = templates.iterator().next();
            String templateName = template.getName();
            String msg = templates.size() == 1 ? DjangoBundle.message("goto-template-name", templateName) : DjangoBundle.message("goto-templates", new Object[0]);
            return new RelatedItemLineMarkerInfo(element, element.getTextRange(), AllIcons.FileTypes.Html, 11, (Function)new ConstantFunction((Object)msg), (GutterIconNavigationHandler)new DefaultGutterIconNavigationHandler(templates, msg), GutterIconRenderer.Alignment.RIGHT, (Collection)GotoRelatedItem.createItems(templates, (String)"Templates"));
        }
        return null;
    }

    private static List<PsiFile> getTemplates(@NotNull Module module, @NotNull Collection<String> names) {
        if (module == null) {
            DjangoTemplateReferenceLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (names == null) {
            DjangoTemplateReferenceLineMarkerProvider.$$$reportNull$$$0(6);
        }
        DjangoTemplateManager templateManager = DjangoTemplateManager.getInstance(module);
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        for (String name : names) {
            PsiFile ref = templateManager.getTemplate(name);
            if (ref == null) continue;
            result.add(ref);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/django/annotator/DjangoTemplateReferenceLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNavigationMarkers";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getTemplateNameForClassBasedView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getModelClass";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getTemplates";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

