/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cython.types;

import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import com.jetbrains.cython.CythonNames;
import com.jetbrains.cython.types.CythonType;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CythonBuiltinType
implements CythonType {
    private final String myBaseName;
    private final boolean myIsDefaultName;
    private final Sign mySign;
    private final Longness myLongness;

    public CythonBuiltinType(List<String> tokens) {
        String baseName = "int";
        boolean isDefaultName = true;
        Sign sign = Sign.DEFAULT;
        Longness longness = Longness.DEFAULT;
        for (String token : tokens) {
            if ("unsigned".equals(token)) {
                sign = Sign.UNSIGNED;
                continue;
            }
            if ("signed".equals(token)) {
                sign = Sign.SIGNED;
                continue;
            }
            if ("short".equals(token)) {
                longness = Longness.SHORT;
                continue;
            }
            if ("long".equals(token)) {
                longness = Longness.LONG;
                continue;
            }
            if (!CythonNames.BASE_C_TYPES.contains((Object)token) && !CythonNames.BASE_CYTHON_TYPES.contains((Object)token)) continue;
            isDefaultName = false;
            baseName = token;
        }
        this.myBaseName = baseName;
        this.myIsDefaultName = isDefaultName;
        this.mySign = sign;
        this.myLongness = longness;
    }

    @Override
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        if (name == null) {
            CythonBuiltinType.$$$reportNull$$$0(0);
        }
        if (direction == null) {
            CythonBuiltinType.$$$reportNull$$$0(1);
        }
        if (resolveContext == null) {
            CythonBuiltinType.$$$reportNull$$$0(2);
        }
        return new ResolveResultList();
    }

    @Override
    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public String getName() {
        String longness;
        String sign;
        switch (this.mySign) {
            case UNSIGNED: {
                sign = "unsigned ";
                break;
            }
            case SIGNED: {
                sign = "signed ";
                break;
            }
            default: {
                sign = "";
            }
        }
        switch (this.myLongness) {
            case SHORT: {
                longness = "short ";
                break;
            }
            case LONG: {
                longness = "long ";
                break;
            }
            default: {
                longness = "";
            }
        }
        return (sign + longness + (this.myIsDefaultName ? "" : this.myBaseName)).trim();
    }

    @Override
    public boolean isBuiltin() {
        return true;
    }

    @Override
    public void assertValid(String message) {
    }

    public String getBaseName() {
        return this.myBaseName;
    }

    public Longness getLongness() {
        return this.myLongness;
    }

    public Sign getSign() {
        return this.mySign;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "direction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "resolveContext";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cython/types/CythonBuiltinType";
        objectArray[2] = "resolveMember";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Sign {
        DEFAULT,
        UNSIGNED,
        SIGNED;

    }

    public static enum Longness {
        DEFAULT,
        SHORT,
        LONG;

    }
}

