/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cython.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cython.parser.CythonDeclParsing;
import com.jetbrains.cython.parser.CythonParsingContext;
import com.jetbrains.cython.parser.CythonTokenTypes;
import com.jetbrains.cython.psi.elementTypes.CythonElementTypes;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.parsing.ExpressionParsing;

public class CythonExpressionParsing
extends ExpressionParsing {
    public CythonExpressionParsing(CythonParsingContext context) {
        super(context);
    }

    @Override
    public CythonParsingContext getParsingContext() {
        return (CythonParsingContext)this.myContext;
    }

    @Override
    protected IElementType getReferenceType() {
        return CythonElementTypes.REFERENCE_EXPRESSION;
    }

    @Override
    protected boolean parseUnaryExpression(boolean isTargetExpression) {
        if (this.atToken(PyTokenTypes.AND)) {
            this.parseAmpersandExpression(isTargetExpression);
            return true;
        }
        if (this.atToken(PyTokenTypes.LT)) {
            this.parseTypeCast(isTargetExpression);
            return true;
        }
        if (this.atToken(PyTokenTypes.IDENTIFIER, "sizeof")) {
            this.parseSizeOfExpression();
            return true;
        }
        if (this.atToken(PyTokenTypes.IDENTIFIER, "new") && this.parseNewExpression()) {
            return true;
        }
        return super.parseUnaryExpression(isTargetExpression);
    }

    @Override
    protected void parseComprehensionRange(boolean generatorExpression) {
        if (this.atToken(PyTokenTypes.IN_KEYWORD)) {
            this.nextToken();
            boolean result = generatorExpression ? this.parseORTestExpression(false, false) : this.parseTupleExpression(false, false, true);
            if (!result) {
                this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
            }
        } else if (this.atToken(PyTokenTypes.FROM_KEYWORD)) {
            this.nextToken();
            this.parseExpression();
            if (this.atToken(CythonTokenTypes.BY_KEYWORD)) {
                this.nextToken();
                this.parseExpression();
            }
        } else {
            this.myBuilder.error(PythonProBundle.message("cython.expected.symbols", "'in'", "'from'"));
        }
    }

    private void parseSizeOfExpression() {
        CythonDeclParsing parser = this.getParsingContext().getDeclParser();
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.nextToken();
        this.checkMatches(PyTokenTypes.LPAR, PyPsiBundle.message("PARSE.expected.lpar", new Object[0]));
        parser.parseBaseTypeDecl(false);
        parser.parseNameDecl(true, false, false);
        this.checkMatches(PyTokenTypes.RPAR, PyPsiBundle.message("PARSE.expected.rpar", new Object[0]));
        marker.done((IElementType)CythonElementTypes.SIZEOF_EXPRESSION);
    }

    private boolean parseNewExpression() {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.nextToken();
        if (this.parseExpressionOptional()) {
            marker.done((IElementType)CythonElementTypes.NEW_EXPRESSION);
            return true;
        }
        marker.rollbackTo();
        return false;
    }

    private void parseTypeCast(boolean isTargetExpression) {
        this.assertCurrentToken(PyTokenTypes.LT);
        PsiBuilder builder = this.myContext.getBuilder();
        PsiBuilder.Marker marker = builder.mark();
        this.nextToken();
        CythonDeclParsing declParser = this.getParsingContext().getDeclParser();
        declParser.parseBaseTypeDecl(false);
        declParser.parseNameDecl(true, false, false);
        if (this.atToken(CythonTokenTypes.QUESTION)) {
            this.nextToken();
        }
        this.checkMatches(PyTokenTypes.GT, PythonProBundle.message("cython.gt.expected"));
        this.parseUnaryExpression(isTargetExpression);
        marker.done((IElementType)CythonElementTypes.TYPECAST_EXPRESSION);
    }

    private void parseAmpersandExpression(boolean isTargetExpression) {
        this.assertCurrentToken(PyTokenTypes.AND);
        PsiBuilder builder = this.myContext.getBuilder();
        PsiBuilder.Marker marker = builder.mark();
        this.nextToken();
        this.parseUnaryExpression(isTargetExpression);
        marker.done((IElementType)CythonElementTypes.ADDRESS_EXPRESSION);
    }
}

