/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cython.debug;

import com.google.common.collect.Sets;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cython.CythonFileType;
import com.jetbrains.cython.CythonLanguageDialect;
import com.jetbrains.cython.parser.CythonTokenTypes;
import com.jetbrains.cython.psi.CythonBaseTypeDecl;
import com.jetbrains.cython.psi.CythonVariable;
import com.jetbrains.cython.psi.CythonVariableList;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import com.jetbrains.python.debugger.PyLineBreakpointType;
import java.util.Set;

public class CythonLineBreakpointType
extends PyLineBreakpointType {
    public static final String ID = "cython-line";
    private static final String NAME = "Cython Line Breakpoint";
    private static final Set<IElementType> UNSTOPPABLE_ELEMENT_TYPES = Sets.newHashSet((Object[])new IElementType[]{PyTokenTypes.TRIPLE_QUOTED_STRING, PyTokenTypes.SINGLE_QUOTED_STRING, PyTokenTypes.SINGLE_QUOTED_UNICODE, PyTokenTypes.DOCSTRING, CythonTokenTypes.CDEF_KEYWORD});
    private static final Class<? extends PsiElement>[] UNSTOPPABLE_ELEMENTS = new Class[]{PsiWhiteSpace.class, PsiComment.class, CythonBaseTypeDecl.class, CythonVariable.class, CythonVariableList.class};

    public CythonLineBreakpointType() {
        super(ID, NAME, new PyDebuggerEditorsProvider());
    }

    @Override
    protected FileType getFileType() {
        return CythonFileType.INSTANCE;
    }

    @Override
    protected Language getFileLanguage() {
        return CythonLanguageDialect.getInstance();
    }

    @Override
    protected boolean isPsiElementStoppable(PsiElement psiElement) {
        Language elementLanguage = psiElement.getLanguage();
        return elementLanguage == PythonLanguage.INSTANCE || elementLanguage == CythonLanguageDialect.getInstance();
    }

    @Override
    protected Set<IElementType> getUnstoppableElementTypes() {
        return UNSTOPPABLE_ELEMENT_TYPES;
    }

    @Override
    protected Class<? extends PsiElement>[] getUnstoppableElements() {
        return UNSTOPPABLE_ELEMENTS;
    }

    @Override
    public boolean isSuspendThreadSupported() {
        return true;
    }

    @Override
    public String getBreakpointsDialogHelpTopic() {
        return "reference.dialogs.breakpoints";
    }
}

