/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.ref;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.appengine.facet.AppEngineFacet;
import com.jetbrains.appengine.facet.AppEngineFacetConfiguration;
import com.jetbrains.appengine.util.AppEngineUtil;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.BaseReference;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;

public class AppHandlerScriptReference
extends BaseReference {
    private static final String EXTENSION_PYTHON_FILE = PythonFileType.INSTANCE.getDefaultExtension();

    public AppHandlerScriptReference(YAMLKeyValue element) {
        super((PsiElement)element);
    }

    public PsiElement resolve() {
        String filePath = ((YAMLKeyValue)this.myElement).getValueText();
        VirtualFile file2 = this.findFile(filePath);
        if (file2 != null) {
            return this.myElement.getManager().findFile(file2);
        }
        if (AppEngineUtil.isPython27Runtime((YAMLFile)this.myElement.getContainingFile())) {
            PyQualifiedNameResolveContext context = PyResolveImportUtil.fromFoothold(this.myElement).copyWithMembers();
            List<PsiElement> results = PyResolveImportUtil.resolveQualifiedName(QualifiedName.fromDottedString((String)filePath), context);
            return !results.isEmpty() ? results.get(0) : null;
        }
        return null;
    }

    private VirtualFile findFile(String filePath) {
        VirtualFile root;
        filePath = StringUtil.trimStart((String)filePath, (String)"/");
        VirtualFile contentRoot = this.getContentRoot();
        if (contentRoot != null) {
            return contentRoot.findFileByRelativePath(filePath);
        }
        String sdkFolder = AppEngineFacet.getSdkFolder(this.myElement);
        if (sdkFolder != null && (root = VirtualFileUtil.findFile(sdkFolder)) != null) {
            return root.findFileByRelativePath(filePath);
        }
        return null;
    }

    private VirtualFile getContentRoot() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
        if (module == null) {
            return null;
        }
        AppEngineFacetConfiguration config = AppEngineFacet.getConfig(module);
        if (config == null) {
            return null;
        }
        return config.getProjectRootFolderFile();
    }

    public Object @NotNull [] getVariants() {
        VirtualFile contentRoot = this.getContentRoot();
        if (contentRoot == null) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                AppHandlerScriptReference.$$$reportNull$$$0(0);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        TypeEvalContext context = TypeEvalContext.codeCompletion(this.myElement.getProject(), CompletionUtil.getOriginalOrSelf((PsiElement)this.myElement).getContainingFile());
        PythonFileFinder finder = new PythonFileFinder(contentRoot, context);
        VfsUtilCore.processFilesRecursively((VirtualFile)contentRoot, (Processor)finder);
        Set<String> paths = finder.getPaths();
        Object[] result = new String[paths.size()];
        paths.toArray(result);
        if (result == null) {
            AppHandlerScriptReference.$$$reportNull$$$0(1);
        }
        return result;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            AppHandlerScriptReference.$$$reportNull$$$0(2);
        }
        return this.myElement.replace((PsiElement)YAMLElementGenerator.getInstance((Project)this.myElement.getProject()).createYamlKeyValue("script", newElementName));
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        String prefix = this.getPrefix();
        int start = prefix.length();
        return new TextRange(start, this.myElement.getText().length());
    }

    private String getPrefix() {
        String text2 = this.myElement.getText();
        int keyEnd = text2.indexOf(":");
        if (keyEnd == -1) {
            return text2;
        }
        ++keyEnd;
        while (keyEnd < text2.length() && Character.isWhitespace(text2.charAt(keyEnd))) {
            ++keyEnd;
        }
        return text2.substring(0, keyEnd);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/appengine/ref/AppHandlerScriptReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/appengine/ref/AppHandlerScriptReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PythonFileFinder
    implements Processor<VirtualFile> {
        private final Set<String> myPaths;
        private final VirtualFile myRoot;
        @NotNull
        private final TypeEvalContext myContext;

        private PythonFileFinder(@NotNull VirtualFile root, TypeEvalContext context) {
            if (root == null) {
                PythonFileFinder.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PythonFileFinder.$$$reportNull$$$0(1);
            }
            this.myPaths = new HashSet<String>();
            this.myRoot = root;
            this.myContext = context;
        }

        public boolean process(VirtualFile virtualFile2) {
            if (!virtualFile2.isDirectory() && EXTENSION_PYTHON_FILE.equals(virtualFile2.getExtension())) {
                PsiFile psiFile;
                if (AppEngineUtil.isPython27Runtime((YAMLFile)AppHandlerScriptReference.this.myElement.getContainingFile()) && (psiFile = AppHandlerScriptReference.this.myElement.getManager().findFile(virtualFile2)) instanceof PyFile && this.findWSGIApps((PyFile)psiFile)) {
                    return true;
                }
                String relativePath = VfsUtilCore.getRelativePath((VirtualFile)this.myRoot, (VirtualFile)virtualFile2, (char)'/');
                if (relativePath != null) {
                    this.myPaths.add(relativePath);
                }
            }
            return true;
        }

        private boolean findWSGIApps(PyFile file2) {
            List<PyTargetExpression> attributes = file2.getTopLevelAttributes();
            boolean foundApps = false;
            for (PyTargetExpression attribute : attributes) {
                String classQName;
                PyType type;
                PyExpression value2 = attribute.findAssignedValue();
                if (value2 == null || !((type = this.myContext.getType(value2)) instanceof PyClassType) || !"google.appengine.ext.webapp.WSGIApplication".equals(classQName = ((PyClassType)type).getClassQName()) && !"webapp2.WSGIApplication".equals(classQName)) continue;
                this.myPaths.add(QualifiedNameFinder.findShortestImportableName(AppHandlerScriptReference.this.myElement, file2.getVirtualFile()) + "." + attribute.getName());
                foundApps = true;
            }
            return foundApps;
        }

        public Set<String> getPaths() {
            return this.myPaths;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/appengine/ref/AppHandlerScriptReference$PythonFileFinder";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

