/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.facet;

import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.appengine.facet.AppEngineFacetTab;
import com.jetbrains.appengine.facet.AppEngineWizardSettingsHolder;
import com.jetbrains.django.util.VirtualFileUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class AppEngineFacetConfiguration
implements FacetConfiguration {
    @NonNls
    private static final String ATTR_ROOT_FOLDER = "rootFolder";
    @NonNls
    private static final String ATTR_SDK_FOLDER = "sdkFolder";
    private String myProjectRoot;
    private VirtualFile myProjectRootFolderFile;
    private String mySdkFolder;

    public FacetEditorTab[] createEditorTabs(FacetEditorContext facetEditorContext, FacetValidatorsManager facetValidatorsManager) {
        return new FacetEditorTab[]{new AppEngineFacetTab(this)};
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myProjectRoot = JDOMExternalizerUtil.readField((Element)element, (String)ATTR_ROOT_FOLDER);
        this.mySdkFolder = JDOMExternalizerUtil.readField((Element)element, (String)ATTR_SDK_FOLDER);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_ROOT_FOLDER, (String)this.myProjectRoot);
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_SDK_FOLDER, (String)this.mySdkFolder);
    }

    public String getProjectRoot() {
        return this.myProjectRoot;
    }

    public void setProjectRoot(String projectRoot) {
        this.myProjectRoot = projectRoot;
    }

    public String getSdkFolder() {
        return this.mySdkFolder;
    }

    public void setSdkFolder(String folder) {
        this.mySdkFolder = folder;
    }

    public void setProjectRootFolderFile(VirtualFile file2) {
        this.myProjectRootFolderFile = file2;
    }

    public VirtualFile getProjectRootFolderFile() {
        if (this.myProjectRootFolderFile != null) {
            return this.myProjectRootFolderFile;
        }
        return VirtualFileUtil.findFile(this.getProjectRoot());
    }

    public static AppEngineFacetConfiguration fromProjectDirectory(VirtualFile baseDir) {
        AppEngineFacetConfiguration configuration = new AppEngineFacetConfiguration();
        configuration.setProjectRoot(baseDir.getPath());
        if (!StringUtil.isEmptyOrSpaces((String)AppEngineWizardSettingsHolder.getDefaultAppEngineSdkFolder())) {
            configuration.setSdkFolder(AppEngineWizardSettingsHolder.getDefaultAppEngineSdkFolder());
        }
        return configuration;
    }
}

