/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run.rhino;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ws.http.request.run.HttpClientResponseHandlerExecutor;
import com.intellij.ws.http.request.run.HttpClientSession;
import com.intellij.ws.http.request.run.HttpRequestGlobalContext;
import com.intellij.ws.http.request.run.HttpResponseExecutionResult;
import com.intellij.ws.http.request.run.console.HttpResponseOutputAdapter;
import com.intellij.ws.http.request.run.rhino.HttpClientRhinoReader;
import com.intellij.ws.http.request.run.rhino.HttpResponseHeader;
import com.intellij.ws.rest.client.RestClientBundle;
import com.intellij.ws.rest.client.RestClientResponse;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class HttpClientRhinoResponseHandler
implements HttpClientResponseHandlerExecutor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ws.http.request.run.rhino.HttpClientRhinoResponseHandler");
    private static final String FUNCTION_NAME = "jsHandler";
    private final Project myProject;
    @Nullable
    private HttpResponseOutputAdapter myPrinter;

    public HttpClientRhinoResponseHandler(@NotNull Project project) {
        if (project == null) {
            HttpClientRhinoResponseHandler.$$$reportNull$$$0(0);
        }
        this.myPrinter = null;
        this.myProject = project;
    }

    @NotNull
    public static HttpClientRhinoResponseHandler create(@NotNull Project project) {
        if (project == null) {
            HttpClientRhinoResponseHandler.$$$reportNull$$$0(1);
        }
        return new HttpClientRhinoResponseHandler(project);
    }

    @Override
    public void configureStdout(@NotNull HttpResponseOutputAdapter printer) {
        if (printer == null) {
            HttpClientRhinoResponseHandler.$$$reportNull$$$0(2);
        }
        this.myPrinter = printer;
    }

    @Override
    @NotNull
    public HttpResponseExecutionResult execute(@NotNull HttpClientSession session, @NotNull RestClientResponse response, @NotNull String script) throws ExecutionException {
        HttpResponseExecutionResult httpResponseExecutionResult;
        Script jsScript;
        if (session == null) {
            HttpClientRhinoResponseHandler.$$$reportNull$$$0(3);
        }
        if (response == null) {
            HttpClientRhinoResponseHandler.$$$reportNull$$$0(4);
        }
        if (script == null) {
            HttpClientRhinoResponseHandler.$$$reportNull$$$0(5);
        }
        String text = this.readJsHandlerTemplate().replace("<CUSTOM_SCRIPT_PLACEHOLDER>", script);
        if (LOG.isTraceEnabled()) {
            LOG.trace(text);
        }
        try {
            jsScript = HttpClientRhinoResponseHandler.compileScript(text);
        }
        catch (RhinoException e) {
            this.printStderr(e.getMessage());
            throw new ExecutionException(e.getMessage());
        }
        long start = System.currentTimeMillis();
        Context context = Context.enter();
        try {
            ScriptableObject scope = context.initStandardObjects();
            jsScript.exec(context, (Scriptable)scope);
            Object obj = scope.get(FUNCTION_NAME, (Scriptable)scope);
            if (!(obj instanceof Function)) {
                this.printStderr(RestClientBundle.message("rest.client.request.response.handler.failed.on.execution", new Object[0]));
                throw new ExecutionException("Failed during executing response handler");
            }
            HttpRequestGlobalContext.HttpClientVariables global = HttpRequestGlobalContext.getInstance(this.myProject).getGlobal();
            boolean isJson = StringUtil.equalsIgnoreCase((CharSequence)response.getContentType().getMimeType(), (CharSequence)ContentType.APPLICATION_JSON.getMimeType());
            Object[] args = new Object[]{isJson, HttpClientRhinoResponseHandler.toVariablesArray(global, (Scriptable)scope), session.content, session.statusCode, session.contentType.mimeType, session.contentType.charset, HttpClientRhinoResponseHandler.toHeaderNames(session.headers)};
            Object result = ((Function)obj).call(context, (Scriptable)scope, (Scriptable)scope, args);
            if (!(result instanceof NativeObject)) {
                this.printStderr(RestClientBundle.message("rest.client.request.response.handler.failed.on.execution", new Object[0]));
                throw new ExecutionException("Failed during executing response handler");
            }
            global.clearAll();
            NativeObject resultObj = (NativeObject)result;
            Map<String, String> variables = HttpClientRhinoReader.readVariables(resultObj, (Scriptable)scope);
            for (Map.Entry<String, String> entry : variables.entrySet()) {
                global.set(entry.getKey(), entry.getValue());
            }
            this.printStdout(HttpClientRhinoReader.readStdout(resultObj, (Scriptable)scope));
            HttpResponseExecutionResult httpResponseExecutionResult2 = new HttpResponseExecutionResult(HttpClientRhinoReader.readTests(resultObj, context, (Scriptable)scope));
            httpResponseExecutionResult = httpResponseExecutionResult2;
        }
        catch (RhinoException e) {
            this.printStderr(e.getMessage());
            throw new ExecutionException(e.getMessage());
        }
        finally {
            LOG.debug("Finished Rhino execution in " + (System.currentTimeMillis() - start) + "ms");
        }
        if (httpResponseExecutionResult == null) {
            HttpClientRhinoResponseHandler.$$$reportNull$$$0(6);
        }
        return httpResponseExecutionResult;
    }

    @Override
    public void close() {
        if (Context.getCurrentContext() != null) {
            Context.exit();
        }
    }

    @NotNull
    private static NativeArray toVariablesArray(@NotNull HttpRequestGlobalContext.HttpClientVariables global, @NotNull Scriptable scope) {
        if (global == null) {
            HttpClientRhinoResponseHandler.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            HttpClientRhinoResponseHandler.$$$reportNull$$$0(8);
        }
        Object[] vars = global.getAllVars().entrySet().toArray();
        NativeArray array = new NativeArray(vars);
        array.setPrototype(ScriptableObject.getClassPrototype((Scriptable)scope, (String)"Array"));
        NativeArray nativeArray = array;
        if (nativeArray == null) {
            HttpClientRhinoResponseHandler.$$$reportNull$$$0(9);
        }
        return nativeArray;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    protected String readJsHandlerTemplate() throws ExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static HttpResponseHeader @NotNull [] toHeaderNames(@NotNull HttpClientSession.HttpResponseHeaders headers) {
        if (headers == null) {
            HttpClientRhinoResponseHandler.$$$reportNull$$$0(11);
        }
        HttpResponseHeader[] responseHeaders = new HttpResponseHeader[headers.headers.length];
        for (int i = 0; i < headers.headers.length; ++i) {
            Header header = headers.headers[i];
            responseHeaders[i] = new HttpResponseHeader(header.getName(), header.getValue());
        }
        if (responseHeaders == null) {
            HttpClientRhinoResponseHandler.$$$reportNull$$$0(12);
        }
        return responseHeaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Script compileScript(@NotNull String str) {
        if (str == null) {
            HttpClientRhinoResponseHandler.$$$reportNull$$$0(13);
        }
        long start = System.currentTimeMillis();
        Context context = Context.enter();
        context.setOptimizationLevel(9);
        Script script = context.compileString(str, "<jsHandler script>", 1, null);
        Script script2 = script;
        if (script2 == null) {
            HttpClientRhinoResponseHandler.$$$reportNull$$$0(14);
        }
        return script2;
        finally {
            Context.exit();
            LOG.debug("Compiled Rhino script in " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    private void printStdout(@NotNull String text) {
        if (text == null) {
            HttpClientRhinoResponseHandler.$$$reportNull$$$0(15);
        }
        if (this.myPrinter != null) {
            this.myPrinter.print(text, ConsoleViewContentType.NORMAL_OUTPUT);
        }
    }

    private void printStderr(@NotNull String text) {
        if (text == null) {
            HttpClientRhinoResponseHandler.$$$reportNull$$$0(16);
        }
        if (this.myPrinter != null) {
            this.myPrinter.print(text, ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/rhino/HttpClientRhinoResponseHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "global";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headers";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/rhino/HttpClientRhinoResponseHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toVariablesArray";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "readJsHandlerTemplate";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toHeaderNames";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "compileScript";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "configureStdout";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toVariablesArray";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "toHeaderNames";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "compileScript";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "printStdout";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "printStderr";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

