/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions.generation;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.net.HTTPMethod;
import com.intellij.ws.http.request.HttpRequestPsiFactory;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.HttpRequestVariableSubstitutor;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.psi.HttpRequestTarget;
import com.intellij.ws.http.request.psi.impl.HttpRequestPsiImplUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001d\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\u0006H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ws/actions/generation/HttpRequestUrlInfo;", "", "methods", "", "Lcom/intellij/util/net/HTTPMethod;", "url", "", "(Ljava/util/Set;Ljava/lang/String;)V", "getMethods", "()Ljava/util/Set;", "getUrl", "()Ljava/lang/String;", "toString", "Companion", "intellij.restClient"})
public final class HttpRequestUrlInfo {
    @NotNull
    private final Set<HTTPMethod> methods;
    @NotNull
    private final String url;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String toString() {
        return "HttpRequestUrlInfo(methods=" + this.methods + ", url='" + this.url + "')";
    }

    @NotNull
    public final Set<HTTPMethod> getMethods() {
        return this.methods;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    private HttpRequestUrlInfo(Set<? extends HTTPMethod> methods, String url) {
        this.methods = methods;
        this.url = url;
    }

    public /* synthetic */ HttpRequestUrlInfo(Set methods, String url, DefaultConstructorMarker $constructor_marker) {
        this(methods, url);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J&\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ws/actions/generation/HttpRequestUrlInfo$Companion;", "", "()V", "checkGeneratedUrlIsEqualsTo", "", "request", "Lcom/intellij/ws/http/request/psi/HttpRequest;", "url", "", "create", "Lcom/intellij/ws/actions/generation/HttpRequestUrlInfo;", "project", "Lcom/intellij/openapi/project/Project;", "methods", "", "Lcom/intellij/util/net/HTTPMethod;", "intellij.restClient"})
    public static final class Companion {
        @Nullable
        public final HttpRequestUrlInfo create(@NotNull Project project, @NotNull Set<? extends HTTPMethod> methods, @NotNull String url) {
            HttpRequest request;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull(methods, (String)"methods");
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            if (StringsKt.isBlank((CharSequence)url) || methods.isEmpty()) {
                return null;
            }
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isReadAccessAllowed()) {
                return null;
            }
            String dummyRequest = "GET " + url;
            HttpRequestPsiFile httpRequestPsiFile = HttpRequestPsiFactory.createDummyFile(project, dummyRequest);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)httpRequestPsiFile), (String)"HttpRequestPsiFactory.cr\u2026le(project, dummyRequest)");
            HttpRequestPsiFile file = httpRequestPsiFile;
            HttpRequest httpRequest = request = HttpRequestPsiUtils.getFirstRequest((PsiFile)file);
            if ((httpRequest != null ? httpRequest.getRequestTarget() : null) == null || !this.checkGeneratedUrlIsEqualsTo(request, url) || PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)request))) {
                return null;
            }
            return new HttpRequestUrlInfo(methods, url, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean checkGeneratedUrlIsEqualsTo(HttpRequest request, String url) {
            HttpRequestTarget httpRequestTarget = request.getRequestTarget();
            if (httpRequestTarget == null) return false;
            HttpRequestTarget httpRequestTarget2 = httpRequestTarget;
            boolean bl = false;
            boolean bl2 = false;
            HttpRequestTarget requestTarget = httpRequestTarget2;
            boolean bl3 = false;
            String string = HttpRequestPsiImplUtil.getHttpPath(requestTarget, HttpRequestVariableSubstitutor.empty());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"HttpRequestPsiImplUtil.g\u2026iableSubstitutor.empty())");
            String httpPath = string;
            if (!Intrinsics.areEqual((Object)httpPath, (Object)StringsKt.trimStart((String)url, (char[])new char[]{'/'}))) return false;
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

