/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions.generation;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.psi.HttpRequestTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class HttpHostChooser {
    private static final String MAIN_HOST_CHOOSE_VAR = "FIRST_HOST";
    private static final String OTHER_HOST_VAR = "OTHER_HOST";
    private static final String CHOOSE_HOST_COMMAND = "Choose.Host.Action";
    private static final String DEFAULT_HOST = "http://localhost";
    private final List<HttpRequestTarget> myRequestTargets;
    private final Project myProject;
    private final HttpRequestPsiFile myFile;
    private List<RangeHighlighter> myHighlighters;
    private static final ExtensionPointName<HttpHostChooserHostsProvider> EP_NAME = ExtensionPointName.create((String)"com.jetbrains.restClient.httpHostChooserHostsProvider");

    public HttpHostChooser(@NotNull @NotNull Collection<@NotNull HttpRequestTarget> requestTargets2) {
        if (requestTargets2 == null) {
            HttpHostChooser.$$$reportNull$$$0(0);
        }
        this.myRequestTargets = new ArrayList<HttpRequestTarget>(requestTargets2);
        assert (!requestTargets2.isEmpty());
        this.myProject = this.myRequestTargets.get(0).getProject();
        this.myFile = (HttpRequestPsiFile)this.myRequestTargets.get(0).getContainingFile();
    }

    public void chooseHost() {
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor();
        if (fileEditor == null) {
            return;
        }
        final Editor editor = ((TextEditor)fileEditor).getEditor();
        HttpRequestTarget firstHost = this.myRequestTargets.get(0);
        PsiNavigationSupport.getInstance().createNavigatable(this.myProject, this.myFile.getVirtualFile(), firstHost.getTextOffset()).navigate(true);
        TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl((PsiElement)this.myFile);
        Collection<LookupElement> lookupElements = this.findHosts();
        TextRange beginningRange = new TextRange(0, 0);
        templateBuilder.replaceElement((PsiElement)firstHost, beginningRange, MAIN_HOST_CHOOSE_VAR, (Expression)new ConstantNode((Result)new TextResult(DEFAULT_HOST)).withLookupItems(lookupElements), true);
        this.myRequestTargets.stream().skip(1L).forEach(otherHost -> templateBuilder.replaceElement((PsiElement)otherHost, beginningRange, OTHER_HOST_VAR, MAIN_HOST_CHOOSE_VAR, false));
        WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)CHOOSE_HOST_COMMAND, null, () -> {
            Template template = templateBuilder.buildInlineTemplate();
            editor.getCaretModel().moveToOffset(this.myFile.getTextRange().getStartOffset());
            TemplateManager.getInstance((Project)this.myProject).startTemplate(editor, template, (TemplateEditingListener)new TemplateEditingAdapter(){

                public void templateFinished(@NotNull Template template, boolean brokenOff) {
                    if (template == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    HttpHostChooser.this.removeHighlighters(editor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/ws/actions/generation/HttpHostChooser$1", "templateFinished"));
                }
            });
            this.highlightTemplate(template, editor);
            TemplateState state = TemplateManagerImpl.getTemplateState((Editor)editor);
            if (state == null) {
                return;
            }
            Disposer.register((Disposable)state, () -> this.removeHighlighters(editor));
        }, (PsiFile[])new PsiFile[0]);
    }

    private void removeHighlighters(@NotNull Editor editor) {
        if (editor == null) {
            HttpHostChooser.$$$reportNull$$$0(1);
        }
        if (this.myHighlighters != null) {
            HighlightManager instance = HighlightManager.getInstance((Project)this.myProject);
            for (RangeHighlighter highlighter : this.myHighlighters) {
                instance.removeSegmentHighlighter(editor, highlighter);
            }
            this.myHighlighters = null;
        }
    }

    @NotNull
    private @NotNull Collection<@NotNull LookupElement> findHosts() {
        Collection collection = EP_NAME.extensions().flatMap(provider -> provider.getHosts(this.myProject, this.myFile)).distinct().map(host -> LookupElementBuilder.create((String)host).withIcon(AllIcons.General.Web)).collect(Collectors.toList());
        if (collection == null) {
            HttpHostChooser.$$$reportNull$$$0(2);
        }
        return collection;
    }

    private void highlightTemplate(Template template, Editor editor) {
        TemplateState state = TemplateManagerImpl.getTemplateState((Editor)editor);
        if (state != null) {
            HashMap<TextRange, TextAttributes> textAttributes = new HashMap<TextRange, TextAttributes>();
            EditorColorsManager colorsManager = EditorColorsManager.getInstance();
            for (int i = 0; i < state.getSegmentsCount(); ++i) {
                TextRange range2 = state.getSegmentRange(i);
                String name = template.getSegmentName(i);
                if (MAIN_HOST_CHOOSE_VAR.equals(name)) {
                    textAttributes.put(range2, colorsManager.getGlobalScheme().getAttributes(EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES));
                    continue;
                }
                if (!OTHER_HOST_VAR.equals(name)) continue;
                textAttributes.put(range2, colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES));
            }
            this.myHighlighters = new ArrayList<RangeHighlighter>();
            HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
            textAttributes.forEach((range, attributes) -> highlightManager.addOccurrenceHighlight(editor, range.getStartOffset(), range.getEndOffset(), attributes, 0, this.myHighlighters, null));
            for (RangeHighlighter highlighter : this.myHighlighters) {
                highlighter.setGreedyToLeft(true);
                highlighter.setGreedyToRight(true);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestTargets";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/actions/generation/HttpHostChooser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/actions/generation/HttpHostChooser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findHosts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeHighlighters";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface HttpHostChooserHostsProvider {
        public Stream<String> getHosts(Project var1, HttpRequestPsiFile var2);
    }
}

