/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.utils;

import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.util.ObjectUtils;
import com.sixrr.inspectjs.utils.BoolUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NonNls
public class ConditionalUtils {
    private ConditionalUtils() {
    }

    @Contract(value="null -> false")
    public static boolean returnsTrue(@Nullable JSStatement statement) {
        return ConditionalUtils.returnsLiteralWithKind(statement, JSLiteralExpressionKind.TRUE);
    }

    @Contract(value="null -> false")
    public static boolean returnsFalse(@Nullable JSStatement statement) {
        return ConditionalUtils.returnsLiteralWithKind(statement, JSLiteralExpressionKind.FALSE);
    }

    private static boolean returnsLiteralWithKind(@Nullable JSStatement statement, @NotNull JSLiteralExpressionKind kind) {
        JSReturnStatement returnStatement;
        if (kind == null) {
            ConditionalUtils.$$$reportNull$$$0(0);
        }
        if ((returnStatement = (JSReturnStatement)ObjectUtils.tryCast((Object)statement, JSReturnStatement.class)) == null) {
            return false;
        }
        JSExpression expression = returnStatement.getExpression();
        return ConditionalUtils.isLiteralWithKind(expression, kind);
    }

    private static boolean isAssignmentToLiteralWithKind(@Nullable JSStatement statement, @NotNull JSLiteralExpressionKind kind) {
        JSExpressionStatement expressionStatement;
        if (kind == null) {
            ConditionalUtils.$$$reportNull$$$0(1);
        }
        if ((expressionStatement = (JSExpressionStatement)ObjectUtils.tryCast((Object)statement, JSExpressionStatement.class)) == null) {
            return false;
        }
        JSAssignmentExpression assignmentExpression = (JSAssignmentExpression)ObjectUtils.tryCast((Object)expressionStatement.getExpression(), JSAssignmentExpression.class);
        if (assignmentExpression == null) {
            return false;
        }
        JSExpression rOperand = assignmentExpression.getROperand();
        return ConditionalUtils.isLiteralWithKind(rOperand, kind);
    }

    @Contract(value="null, _ -> false")
    static boolean isLiteralWithKind(@Nullable JSExpression expression, @NotNull JSLiteralExpressionKind kind) {
        if (kind == null) {
            ConditionalUtils.$$$reportNull$$$0(2);
        }
        return expression instanceof JSLiteralExpression && ((JSLiteralExpression)expression).getExpressionKind(false) == kind;
    }

    @Contract(value="null -> false")
    public static boolean isAssignmentToTrue(@Nullable JSStatement statement) {
        return ConditionalUtils.isAssignmentToLiteralWithKind(statement, JSLiteralExpressionKind.TRUE);
    }

    @Contract(value="null -> false")
    public static boolean isAssignmentToFalse(@Nullable JSStatement statement) {
        return ConditionalUtils.isAssignmentToLiteralWithKind(statement, JSLiteralExpressionKind.FALSE);
    }

    @NotNull
    public static String castToBoolean(@NotNull JSExpression expression) {
        if (expression == null) {
            ConditionalUtils.$$$reportNull$$$0(3);
        }
        String conditionText = expression.getText();
        if (BoolUtils.isBoolean(expression, true)) {
            String string = conditionText;
            if (string == null) {
                ConditionalUtils.$$$reportNull$$$0(4);
            }
            return string;
        }
        boolean skipPars = expression instanceof JSReferenceExpression || expression instanceof JSCallExpression || expression instanceof JSParenthesizedExpression || expression instanceof JSArrayLiteralExpression || expression instanceof JSThisExpression || expression instanceof JSFunctionExpression || expression instanceof JSIndexedPropertyAccessExpression || expression instanceof JSLiteralExpression || expression instanceof JSObjectLiteralExpression;
        String string = skipPars ? "!!" + conditionText : "!!(" + conditionText + ")";
        if (string == null) {
            ConditionalUtils.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/inspectjs/utils/ConditionalUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/inspectjs/utils/ConditionalUtils";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "castToBoolean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "returnsLiteralWithKind";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAssignmentToLiteralWithKind";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isLiteralWithKind";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "castToBoolean";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

