/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptExtendedConfigImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImports;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportConfigResolveContextImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportResolveContext;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportsResolverProvider;
import com.intellij.lang.typescript.tsconfig.checkers.TypeScriptConfigDirectoryInclude;
import com.intellij.lang.typescript.tsconfig.checkers.TypeScriptConfigFilesInclude;
import com.intellij.lang.typescript.tsconfig.checkers.TypeScriptConfigIncludeBase;
import com.intellij.lang.typescript.tsconfig.checkers.TypeScriptConfigPatternInclude;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TypeScriptConfigBase
implements TypeScriptConfig {
    private static final Function<PsiFile, TypeScriptConfig> MAP_TO_CONFIG = file2 -> {
        if (JSLibraryUtil.isProbableLibraryFile(file2.getVirtualFile())) {
            return null;
        }
        return TypeScriptConfigBase.getConfig(file2);
    };
    private final NotNullLazyValue<TypeScriptFileImportsImpl> myImportStructure = NotNullLazyValue.createValue(() -> new TypeScriptFileImportsImpl(this.getProject(), this));
    private final NotNullLazyValue<TypeScriptConfigIncludeBase> myIncludeChecker = new NotNullLazyValue<TypeScriptConfigIncludeBase>(){

        @NotNull
        protected TypeScriptConfigIncludeBase compute() {
            if (TypeScriptConfigBase.this.hasIncludesList()) {
                return new TypeScriptConfigPatternInclude(TypeScriptConfigBase.this);
            }
            if (TypeScriptConfigBase.this.hasFilesList()) {
                return new TypeScriptConfigFilesInclude(TypeScriptConfigBase.this);
            }
            return new TypeScriptConfigDirectoryInclude(TypeScriptConfigBase.this);
        }
    };
    private final NotNullLazyValue<TypeScriptImportResolveContext> myResolveContext = new NotNullLazyValue<TypeScriptImportResolveContext>(){

        @NotNull
        protected TypeScriptImportResolveContext compute() {
            return new TypeScriptImportConfigResolveContextImpl(TypeScriptConfigBase.this);
        }
    };
    private final NotNullLazyValue<TypeScriptFileImportsResolver> myImportResolver = new NotNullLazyValue<TypeScriptFileImportsResolver>(){

        @NotNull
        protected TypeScriptFileImportsResolver compute() {
            Project project = TypeScriptConfigBase.this.getProject();
            TypeScriptConfigBase config2 = TypeScriptConfigBase.this;
            TypeScriptFileImportsResolver typeScriptFileImportsResolver = TypeScriptImportsResolverProvider.getResolver(project, config2);
            if (typeScriptFileImportsResolver == null) {
                3.$$$reportNull$$$0(0);
            }
            return typeScriptFileImportsResolver;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigBase$3", "compute"));
        }
    };

    TypeScriptConfigBase() {
    }

    @Nullable
    static TypeScriptConfig parseAndCacheConfig(@Nullable VirtualFile file2, PsiManager manager2) {
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile psiFile = manager2.findFile(file2);
        if (psiFile == null) {
            return null;
        }
        return (TypeScriptConfig)CachedValuesManager.getCachedValue((PsiElement)psiFile, () -> {
            TypeScriptConfig config2 = (TypeScriptConfig)MAP_TO_CONFIG.fun((Object)psiFile);
            if (config2 == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{psiFile});
            }
            SmartList deps = new SmartList((Object)psiFile);
            TypeScriptConfigBase.addAdditionalDepsForConfig(config2, (Collection<Object>)deps, manager2);
            if (deps.size() > 0) {
                deps.add(VirtualFileManager.getInstance());
            }
            return CachedValueProvider.Result.create((Object)config2, (Collection)deps);
        });
    }

    private static void addAdditionalDepsForConfig(@NotNull TypeScriptConfig config2, @NotNull Collection<Object> depends, @NotNull PsiManager manager2) {
        if (config2 == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(0);
        }
        if (depends == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(1);
        }
        if (manager2 == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(2);
        }
        VirtualFile virtualFile = config2.getConfigFile();
        for (VirtualFile file2 : config2.getDependencies()) {
            if (file2.equals(virtualFile)) continue;
            PsiFile psiFile = manager2.findFile(file2);
            depends.add(psiFile != null ? psiFile : file2);
        }
    }

    static TypeScriptConfig getConfig(@NotNull PsiFile rawFile) {
        if (rawFile == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(3);
        }
        return TypeScriptConfigBase.getConfig(rawFile, new HashSet());
    }

    @Nullable
    static TypeScriptConfig getConfig(@NotNull PsiFile rawFile, @NotNull Collection<? super VirtualFile> visited) {
        if (rawFile == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(4);
        }
        if (visited == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!visited.add((VirtualFile)rawFile.getVirtualFile())) {
            return null;
        }
        TypeScriptConfigImpl simpleConfig = TypeScriptConfigImpl.getSimpleConfigImpl(rawFile);
        if (simpleConfig == null) {
            return null;
        }
        VirtualFile parent = simpleConfig.getExtendsParent();
        if (parent == null) {
            return simpleConfig;
        }
        PsiManager manager2 = rawFile.getManager();
        PsiFile parentFile = manager2.findFile(parent);
        if (parentFile == null) {
            return simpleConfig;
        }
        TypeScriptConfig parentConfig = TypeScriptConfigBase.getConfig(parentFile, visited);
        if (parentConfig == null) {
            return simpleConfig;
        }
        return new TypeScriptExtendedConfigImpl(simpleConfig, parentConfig);
    }

    @Override
    @NotNull
    public final TypeScriptConfig.ModuleResolution getEffectiveResolution() {
        TypeScriptConfig.ModuleResolution resolution = this.getResolution();
        if (resolution != TypeScriptConfig.ModuleResolution.UNKNOWN) {
            TypeScriptConfig.ModuleResolution moduleResolution = resolution;
            if (moduleResolution == null) {
                TypeScriptConfigBase.$$$reportNull$$$0(6);
            }
            return moduleResolution;
        }
        TypeScriptConfig.ModuleTarget module = this.getModule();
        TypeScriptConfig.ModuleResolution moduleResolution = module == TypeScriptConfig.ModuleTarget.COMMON_JS ? TypeScriptConfig.ModuleResolution.NODE : TypeScriptConfig.ModuleResolution.CLASSIC;
        if (moduleResolution == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(7);
        }
        return moduleResolution;
    }

    @Override
    @NotNull
    public final TypeScriptConfigIncludeBase getInclude() {
        TypeScriptConfigIncludeBase typeScriptConfigIncludeBase = (TypeScriptConfigIncludeBase)this.myIncludeChecker.getValue();
        if (typeScriptConfigIncludeBase == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(8);
        }
        return typeScriptConfigIncludeBase;
    }

    @Override
    @NotNull
    public final TypeScriptImportResolveContext getResolveContext() {
        TypeScriptImportResolveContext typeScriptImportResolveContext = (TypeScriptImportResolveContext)this.myResolveContext.getValue();
        if (typeScriptImportResolveContext == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(9);
        }
        return typeScriptImportResolveContext;
    }

    @Override
    @NotNull
    public final TypeScriptFileImportsResolver getImportResolver() {
        TypeScriptFileImportsResolver typeScriptFileImportsResolver = (TypeScriptFileImportsResolver)this.myImportResolver.getValue();
        if (typeScriptFileImportsResolver == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(10);
        }
        return typeScriptFileImportsResolver;
    }

    @Override
    @NotNull
    public final TypeScriptFileImports getConfigImportResolveStructure() {
        TypeScriptFileImports typeScriptFileImports = (TypeScriptFileImports)this.myImportStructure.getValue();
        if (typeScriptFileImports == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(11);
        }
        return typeScriptFileImports;
    }

    @Override
    public final boolean allowSyntheticDefaultImports() {
        return this.esModuleInterop() || this.declaredAllowSyntheticDefaultImports();
    }

    protected abstract boolean declaredAllowSyntheticDefaultImports();

    @NotNull
    protected abstract Project getProject();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depends";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigBase";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveResolution";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInclude";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveContext";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportResolver";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigImportResolveStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalDepsForConfig";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConfig";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

