/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.JSInsertThisFix;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class TypeScriptSuspiciousConstructorParameterAssignmentInspection
extends JSInspection {
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            TypeScriptSuspiciousConstructorParameterAssignmentInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            TypeScriptSuspiciousConstructorParameterAssignmentInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            TypeScriptSuspiciousConstructorParameterAssignmentInspection.$$$reportNull$$$0(2);
        }
        return new JSElementVisitor(){

            public void visitJSFunctionDeclaration(JSFunction node) {
                if (!node.isConstructor()) {
                    return;
                }
                if (node instanceof TypeScriptFunction && ((TypeScriptFunction)node).isOverloadDeclaration()) {
                    return;
                }
                JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)node);
                if (containingClass == null) {
                    return;
                }
                JSAttributeList list2 = containingClass.getAttributeList();
                if (list2 != null && TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)containingClass)) {
                    return;
                }
                this.checkSuspiciousFieldParamAssignments(node);
            }

            private void checkSuspiciousFieldParamAssignments(final @NotNull JSFunction constructor) {
                Set fieldParamNames;
                if (constructor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((fieldParamNames = Arrays.stream(constructor.getParameterVariables()).filter(TypeScriptPsiUtil::isFieldParameter).map(v -> v.getName()).filter(n -> n != null).collect(Collectors.toSet())).size() == 0) {
                    return;
                }
                constructor.acceptChildren((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

                    public void visitJSAssignmentExpression(JSAssignmentExpression node) {
                        JSExpression lOperand = node.getLOperand();
                        if (lOperand instanceof JSDefinitionExpression) {
                            lOperand = ((JSDefinitionExpression)lOperand).getExpression();
                        }
                        if (!(lOperand instanceof JSReferenceExpression) || ((JSReferenceExpression)lOperand).getQualifier() != null) {
                            return;
                        }
                        String name = ((JSReferenceExpression)lOperand).getReferenceName();
                        if (!fieldParamNames.contains(name)) {
                            return;
                        }
                        JSFunction function2 = JSPsiImplUtils.getParentFunctionThroughLambdas((PsiElement)node);
                        if (function2 != constructor) {
                            return;
                        }
                        holder.registerProblem((PsiElement)lOperand, JavaScriptBundle.message((String)"typescript.suspicious.constructor.parameter.assignment", (Object[])new Object[0]), new LocalQuickFix[]{new JSInsertThisFix(lOperand)});
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/lang/typescript/inspections/TypeScriptSuspiciousConstructorParameterAssignmentInspection$1", "checkSuspiciousFieldParamAssignments"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/inspections/TypeScriptSuspiciousConstructorParameterAssignmentInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/inspections/TypeScriptSuspiciousConstructorParameterAssignmentInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

