/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.react;

import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.frameworks.react.JSXPropTypesUtil;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.inspections.JSArrowFunctionBracesCanBeRemovedInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionDeclaration;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.react.ReactFunctionalToClassComponentHandler;
import com.intellij.lang.javascript.refactoring.react.extractComponent.ReactExtractComponentHandler;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactClassToFunctionalComponentHandler
implements RefactoringActionHandler {
    private static final String DEFAULT_COMPONENT_NAME = "Component";

    public boolean isAvailable(@NotNull JSClass clazz) {
        if (clazz == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(0);
        }
        if (ReactXmlExtension.isAcceptableClassComponent(clazz) != ThreeState.YES) {
            return false;
        }
        if (JSRefactoringUtil.isAbstract((PsiElement)clazz, (JSAttributeListOwner)clazz)) {
            return false;
        }
        if (JSClassSearch.searchClassInheritors(clazz, false).findFirst() != null) {
            return false;
        }
        for (JSElement member : clazz.getMembers()) {
            if (!(member instanceof JSElementBase) || ((JSElementBase)member).getJSContext() == JSContext.STATIC && member instanceof JSField) continue;
            if (member instanceof JSFunction && ((JSFunction)member).isConstructor()) {
                if (ReactClassToFunctionalComponentHandler.isTrivialConstructor((JSFunction)member)) continue;
                return false;
            }
            if (StringUtil.equals((CharSequence)member.getName(), (CharSequence)"render") && !ReactClassToFunctionalComponentHandler.referencesState(member)) continue;
            return false;
        }
        return true;
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(2);
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(3);
        }
        this.invoke(project, editor, file2);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        JSClass clazz;
        if (project == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(6);
        }
        if ((clazz = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(editor.getCaretModel().getOffset()), JSClass.class, (boolean)false)) == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JavaScriptBundle.message((String)"react.class.to.function.caret.at.class", (Object[])new Object[0]));
            ReactClassToFunctionalComponentHandler.showErrorHint(project, editor, message);
            return;
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)clazz, editor, ReactClassToFunctionalComponentHandler.getRefactoringTitle())) {
            return;
        }
        String introducedName = clazz.getName();
        List<JSField> staticFields = ReactClassToFunctionalComponentHandler.getStaticFields(clazz);
        if (StringUtil.isEmpty((String)introducedName)) {
            if (staticFields.size() > 0) {
                introducedName = ReactClassToFunctionalComponentHandler.showNameDialog(project, (JSNamedElement)clazz);
                if (StringUtil.isEmpty((String)introducedName)) {
                    return;
                }
            } else {
                introducedName = DEFAULT_COMPONENT_NAME;
            }
        }
        ArrayList typeUsages = new ArrayList();
        MultiMap conflicts = new MultiMap();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> {
            SearchScope useScope = clazz.getUseScope();
            String elementDescription = StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)clazz, (boolean)false));
            ReferencesSearch.search((PsiElement)clazz, (SearchScope)useScope).forEach(psiReference -> {
                PsiElement refElement = psiReference.getElement();
                if (refElement instanceof JSReferenceExpression && refElement.getParent() instanceof TypeScriptSingleType) {
                    typeUsages.add((TypeScriptSingleType)refElement.getParent());
                } else if (refElement instanceof JSXmlLiteralExpression && ((JSXmlLiteralExpression)refElement).getAttribute("ref") != null) {
                    conflicts.putValue((Object)refElement, (Object)JavaScriptBundle.message((String)"refactoring.react.class.to.functional.conflict.used.with.ref", (Object[])new Object[]{elementDescription}));
                }
            });
        }), JavaScriptBundle.message((String)"javascript.refactoring.searching.usages", (Object[])new Object[0]), true, project)) {
            return;
        }
        if (!BaseRefactoringProcessor.processConflicts((Project)project, (MultiMap)conflicts)) {
            return;
        }
        String finalIntroducedName = introducedName;
        WriteCommandAction.runWriteCommandAction((Project)project, (String)ReactClassToFunctionalComponentHandler.getRefactoringTitle(), null, () -> ReactClassToFunctionalComponentHandler.doRefactoringInWriteAction(finalIntroducedName, clazz, editor, staticFields, typeUsages), (PsiFile[])new PsiFile[0]);
    }

    private static void doRefactoringInWriteAction(@NotNull String introducedName, @NotNull JSClass clazz, @NotNull Editor editor, @NotNull List<JSField> staticFields, @NotNull List<TypeScriptSingleType> typeUsages) {
        JSBlockStatement replacementPsi;
        String replacementText;
        boolean hasSfcTypeDeclaration;
        JSParameterList createdFunctionParameterList;
        String codeTemplateName;
        JSNamedElement createdNamedElement;
        JSField defaultPropsField;
        if (introducedName == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(7);
        }
        if (clazz == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(9);
        }
        if (staticFields == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(10);
        }
        if (typeUsages == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(11);
        }
        boolean isTypedDialect = DialectDetector.hasFeature((PsiElement)clazz, JSLanguageFeature.TYPES);
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)clazz.getProject());
        Properties properties = fileTemplateManager.getDefaultProperties();
        if (!StringUtil.isEmpty((String)introducedName)) {
            properties.setProperty("NAME", introducedName);
        }
        JSField propTypesField = ReactClassToFunctionalComponentHandler.findByName(staticFields, "propTypes");
        if (!isTypedDialect && propTypesField != null && propTypesField.getInitializer() != null) {
            properties.setProperty("PROP_TYPES", propTypesField.getInitializer().getText());
        }
        if ((defaultPropsField = ReactClassToFunctionalComponentHandler.findByName(staticFields, "defaultProps")) != null && defaultPropsField.getInitializer() != null) {
            properties.setProperty("DEFAULT_PROPS", defaultPropsField.getInitializer().getText());
        }
        PsiFile createdFile = (createdNamedElement = ReactExtractComponentHandler.expandTemplate((PsiElement)clazz, properties, codeTemplateName = ReactExtractComponentHandler.getCodeTemplateName(ReactExtractComponentHandler.ComponentType.Function, isTypedDialect), JSNamedElement.class)) != null ? createdNamedElement.getContainingFile() : null;
        JSFunction createdFunction = JSPsiImplUtils.getPossibleFunction((PsiElement)createdNamedElement);
        JSElement createdFunctionBody = (JSElement)ObjectUtils.coalesce((Object)ReactFunctionalToClassComponentHandler.findFunctionBlockBody(createdFunction), (Object)JSPsiImplUtils.tryGetArrowFunctionReturnExpression(createdFunction));
        JSParameterList jSParameterList = createdFunctionParameterList = createdFunction != null ? createdFunction.getParameterList() : null;
        if (createdFunctionBody == null || createdFunctionParameterList == null) {
            String message = JavaScriptBundle.message((String)"refactoring.react.could.not.find.in.template", (Object[])new Object[]{introducedName, codeTemplateName});
            ReactClassToFunctionalComponentHandler.showErrorHint(clazz.getProject(), editor, message);
            return;
        }
        JSFunction renderMethod = clazz.findFunctionByNameAndKind("render", JSFunction.FunctionKind.SIMPLE);
        JSBlockStatement renderMethodBody = ReactFunctionalToClassComponentHandler.findFunctionBlockBody(renderMethod);
        JSExpression renderReturnExpression = JSArrowFunctionBracesCanBeRemovedInspection.getSingleExpression(renderMethodBody);
        String typedDialectPropsType = ReactClassToFunctionalComponentHandler.getPropsTypeFromClassGenericArgument(clazz);
        String propsParameterName = ReactClassToFunctionalComponentHandler.getParameterName(createdFunctionParameterList, 0, "props");
        String contextParameterName = ReactClassToFunctionalComponentHandler.getParameterName(createdFunctionParameterList, 1, "context");
        TypeScriptSingleType createdSfcTypeDeclaration = ReactFunctionalToClassComponentHandler.getSFCTypeDeclaration(createdNamedElement);
        if (createdNamedElement instanceof JSAttributeListOwner) {
            ReactFunctionalToClassComponentHandler.copyExportStatus((JSNamedElement)clazz, (JSAttributeListOwner)createdNamedElement);
        }
        ReactFunctionalToClassComponentHandler.copyReturnType((JSNamedElement)renderMethod, (JSNamedElement)createdFunction);
        boolean bl = hasSfcTypeDeclaration = createdSfcTypeDeclaration != null;
        if (hasSfcTypeDeclaration && !StringUtil.isEmpty((String)typedDialectPropsType)) {
            String genericSfcText = createdSfcTypeDeclaration.getQualifiedTypeName() + "<" + typedDialectPropsType + ">";
            createdSfcTypeDeclaration.replace((PsiElement)JSPsiElementFactory.createTypeScriptType(genericSfcText, (PsiElement)createdSfcTypeDeclaration));
        }
        Ref hasProps = new Ref((Object)Boolean.FALSE);
        Ref hasContext = new Ref((Object)Boolean.FALSE);
        if (createdFunctionBody instanceof JSExpression && renderReturnExpression != null) {
            replacementText = ReactClassToFunctionalComponentHandler.processRenderMethod((JSElement)renderReturnExpression, propsParameterName, contextParameterName, (Ref<Boolean>)hasProps, (Ref<Boolean>)hasContext);
            replacementPsi = JSPsiElementFactory.createJSExpression((String)ObjectUtils.coalesce((Object)replacementText, (Object)"null"), (PsiElement)clazz);
        } else {
            replacementText = ReactClassToFunctionalComponentHandler.processRenderMethod((JSElement)renderMethodBody, propsParameterName, contextParameterName, (Ref<Boolean>)hasProps, (Ref<Boolean>)hasContext);
            replacementPsi = JSPsiElementFactory.createJSStatement((String)ObjectUtils.coalesce((Object)replacementText, (Object)"{}"), (PsiElement)clazz, JSBlockStatement.class);
        }
        createdFunctionBody.replace((PsiElement)replacementPsi);
        createdFunctionParameterList.replace((PsiElement)ReactClassToFunctionalComponentHandler.createParameterList(hasProps.get() == Boolean.TRUE ? propsParameterName : null, !hasSfcTypeDeclaration ? typedDialectPropsType : null, hasContext.get() == Boolean.TRUE ? contextParameterName : null, (PsiElement)createdFunction));
        ReactClassToFunctionalComponentHandler.copyStaticFields(introducedName, createdFile, ContainerUtil.filter(staticFields, field -> field != defaultPropsField && field != propTypesField));
        PsiElement resultElement = ReactClassToFunctionalComponentHandler.expressionAwareReplace((JSNamedElement)clazz, createdFile, createdNamedElement);
        ReactClassToFunctionalComponentHandler.moveCaretToElement(editor, resultElement);
        FormatFixer.create(resultElement, FormatFixer.Mode.Reformat).fixFormat();
        ES6CreateImportUtil.optimizeImports(resultElement);
        for (TypeScriptSingleType typeUsage : typeUsages) {
            typeUsage.replace((PsiElement)JSChangeUtil.createTypeScriptType("typeof " + typeUsage.getText(), (PsiElement)typeUsage));
        }
    }

    private static void copyStaticFields(@NotNull String introducedName, @NotNull PsiFile createdFile, @NotNull List<JSField> fields) {
        if (introducedName == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(12);
        }
        if (createdFile == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(13);
        }
        if (fields == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(14);
        }
        for (JSField field : fields) {
            JSExpression initializer = field.getInitializer();
            if (initializer == null) continue;
            SyntaxTraverser.psiTraverser((PsiElement)initializer).filter(JSThisExpression.class).forEach(thisExpr -> thisExpr.replace(JSPsiElementFactory.createJSExpression(introducedName, (PsiElement)initializer)));
            PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)field);
            JSStatement statement = JSPsiElementFactory.createJSStatement(introducedName + "." + field.getName() + "=" + initializer.getText(), (PsiElement)field);
            statement = (JSStatement)createdFile.add((PsiElement)statement);
            JSDocumentationUtils.moveJSDoc(docComment, (PsiElement)statement);
        }
    }

    @Nullable
    private static JSField findByName(@NotNull List<JSField> staticFields, @NotNull String property) {
        if (staticFields == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(15);
        }
        if (property == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(16);
        }
        return (JSField)ContainerUtil.find(staticFields, field -> StringUtil.equals((CharSequence)field.getName(), (CharSequence)property));
    }

    @NotNull
    public static PsiElement expressionAwareReplace(@NotNull JSNamedElement toReplace, @NotNull PsiFile createdFile, @NotNull JSNamedElement createdDeclaration) {
        if (toReplace == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(17);
        }
        if (createdFile == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(18);
        }
        if (createdDeclaration == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(19);
        }
        boolean templateHasMultipleTopLevelEntities = ReactClassToFunctionalComponentHandler.getFileLevelEntitiesCount(createdFile) > 1;
        boolean declarationCanBeConvertedToExpression = createdDeclaration instanceof JSFunctionDeclaration || createdDeclaration instanceof JSClass;
        PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)toReplace);
        if (toReplace instanceof JSExpression) {
            JSSourceElement sourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)toReplace, JSSourceElement.class);
            assert (sourceElement != null);
            if (declarationCanBeConvertedToExpression) {
                if (toReplace.getParent() instanceof ES6ExportDefaultAssignment) {
                    PsiElement result2 = toReplace.replace((PsiElement)ReactClassToFunctionalComponentHandler.convertToExpression(createdDeclaration));
                    if (templateHasMultipleTopLevelEntities) {
                        createdDeclaration.delete();
                        JSChangeUtil.doAddRangeAfter(sourceElement.getParent(), createdFile.getFirstChild(), createdFile.getLastChild(), (PsiElement)sourceElement);
                    }
                    PsiElement psiElement = result2;
                    if (psiElement == null) {
                        ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(20);
                    }
                    return psiElement;
                }
                if (!templateHasMultipleTopLevelEntities) {
                    JSExpression expression = ReactClassToFunctionalComponentHandler.convertToExpression(createdDeclaration);
                    PsiElement result3 = toReplace.replace((PsiElement)expression);
                    JSDocumentationUtils.moveJSDoc(docComment, result3);
                    PsiElement psiElement = result3;
                    if (psiElement == null) {
                        ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(21);
                    }
                    return psiElement;
                }
            }
            JSNamedElement jsDocTarget = createdDeclaration instanceof JSVariable ? createdDeclaration.getParent() : createdDeclaration;
            JSDocumentationUtils.moveJSDoc(docComment, (PsiElement)jsDocTarget);
            JSChangeUtil.doAddRangeBefore(sourceElement.getParent(), createdFile.getFirstChild(), createdFile.getLastChild(), (PsiElement)sourceElement);
            PsiElement psiElement = toReplace.replace((PsiElement)ReactClassToFunctionalComponentHandler.createReferenceTo(createdDeclaration));
            if (psiElement == null) {
                ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(22);
            }
            return psiElement;
        }
        return ReactClassToFunctionalComponentHandler.replaceSourceElement((PsiElement)toReplace, createdDeclaration, createdFile, docComment);
    }

    private static int getFileLevelEntitiesCount(@NotNull PsiFile createdFile) {
        if (createdFile == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(23);
        }
        return (int)Arrays.stream(createdFile.getChildren()).filter(JSChangeUtil::isSourceElementOrComment).count();
    }

    public static void moveCaretToElement(@NotNull Editor editor, @NotNull PsiElement element) {
        if (editor == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(24);
        }
        if (element == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(25);
        }
        editor.getCaretModel().moveToOffset(element.getTextOffset());
    }

    private static JSExpression convertToExpression(@NotNull JSNamedElement declaration) {
        if (declaration == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(26);
        }
        assert (declaration instanceof JSFunctionDeclaration || declaration instanceof JSClass);
        return JSPsiElementFactory.createJSExpression(declaration.getText(), (PsiElement)declaration, JSExpression.class);
    }

    private static JSReferenceExpression createReferenceTo(@NotNull JSNamedElement createdDeclaration) {
        if (createdDeclaration == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(27);
        }
        String name = createdDeclaration.getName();
        assert (name != null);
        return JSPsiElementFactory.createJSExpression(name, (PsiElement)createdDeclaration, JSReferenceExpression.class);
    }

    @NotNull
    private static PsiElement replaceSourceElement(@NotNull PsiElement toReplace, @NotNull JSNamedElement createdDeclaration, @NotNull PsiFile createdFile, @Nullable PsiComment docComment) {
        if (toReplace == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(28);
        }
        if (createdDeclaration == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(29);
        }
        if (createdFile == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(30);
        }
        JSSourceElement sourceElementToReplace = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)toReplace, JSSourceElement.class, (boolean)false);
        JSSourceElement createdSourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)createdDeclaration, JSSourceElement.class, (boolean)false);
        assert (sourceElementToReplace != null && createdSourceElement != null);
        PsiElement resultDeclaration = sourceElementToReplace.replace((PsiElement)createdSourceElement);
        PsiElement jsDocTarget = resultDeclaration instanceof JSVariable ? resultDeclaration.getParent() : resultDeclaration;
        JSDocumentationUtils.moveJSDoc(docComment, jsDocTarget);
        createdDeclaration.delete();
        if (ReactClassToFunctionalComponentHandler.getFileLevelEntitiesCount(createdFile) > 0) {
            JSChangeUtil.doAddRangeAfter(resultDeclaration.getParent(), createdFile.getFirstChild(), createdFile.getLastChild(), resultDeclaration);
        }
        Object object = resultDeclaration instanceof JSVarStatement ? ((JSVarStatement)resultDeclaration).getVariables()[0] : resultDeclaration;
        if (object == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(31);
        }
        return object;
    }

    @NotNull
    private static List<JSField> getStaticFields(@NotNull JSClass jsClass) {
        if (jsClass == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(32);
        }
        List<JSField> list2 = Arrays.stream(jsClass.getFields()).filter(field -> field.getJSContext() == JSContext.STATIC).sorted(Comparator.comparingInt(PsiElement::getTextOffset)).collect(Collectors.toList());
        if (list2 == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(33);
        }
        return list2;
    }

    @Nullable
    private static String getPropsTypeFromClassGenericArgument(@NotNull JSClass clazz) {
        JSTypeDeclaration genericArgument;
        if (clazz == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(34);
        }
        return (genericArgument = JSXPropTypesUtil.getClassComponentGenericDeclaration(clazz, false)) != null ? genericArgument.getText() : null;
    }

    @NotNull
    private static JSParameterList createParameterList(@Nullable String propsParameterName, @Nullable String propsTypeText, @Nullable String contextParameterName, @NotNull PsiElement context) {
        if (context == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(35);
        }
        StringBuilder text = new StringBuilder("(");
        if (!StringUtil.isEmpty((String)propsParameterName)) {
            text.append(propsParameterName);
            if (!StringUtil.isEmpty((String)propsTypeText)) {
                text.append(": ").append(propsTypeText);
            }
        }
        if (!StringUtil.isEmpty((String)contextParameterName)) {
            text.append(", ").append(contextParameterName);
        }
        text.append(")");
        JSFunction function2 = JSPsiElementFactory.createJSSourceElement("function dummy" + text + "{}", context, JSFunction.class);
        JSParameterList jSParameterList = Objects.requireNonNull(function2.getParameterList());
        if (jSParameterList == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(36);
        }
        return jSParameterList;
    }

    @Nullable
    private static String processRenderMethod(@Nullable JSElement toProcess, @NotNull String propsParameterName, @NotNull String contextParameterName, @NotNull Ref<Boolean> hasProps, @NotNull Ref<Boolean> hasContext) {
        if (propsParameterName == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(37);
        }
        if (contextParameterName == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(38);
        }
        if (hasProps == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(39);
        }
        if (hasContext == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(40);
        }
        if (toProcess == null) {
            return null;
        }
        HashMap referencesToReplace = new HashMap();
        ReactClassToFunctionalComponentHandler.processThisReferences(toProcess, (Processor<JSReferenceExpression>)((Processor)element -> {
            if (StringUtil.equals((CharSequence)element.getReferenceName(), (CharSequence)"props")) {
                referencesToReplace.put(element, propsParameterName);
                hasProps.set((Object)Boolean.TRUE);
            } else if (StringUtil.equals((CharSequence)element.getReferenceName(), (CharSequence)"context")) {
                referencesToReplace.put(element, contextParameterName);
                hasContext.set((Object)Boolean.TRUE);
            }
            return true;
        }));
        return ReactExtractComponentHandler.replaceOccurrences(toProcess, toProcess.getTextRange(), referencesToReplace);
    }

    private static boolean referencesState(@NotNull JSElement member) {
        if (member == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(41);
        }
        return !ReactClassToFunctionalComponentHandler.processThisReferences(member, (Processor<JSReferenceExpression>)((Processor)referenceExpression -> !StringUtil.equals((CharSequence)referenceExpression.getReferenceName(), (CharSequence)"state") && !StringUtil.equals((CharSequence)referenceExpression.getReferenceName(), (CharSequence)"setState")));
    }

    private static boolean processThisReferences(@NotNull JSElement member, @NotNull Processor<JSReferenceExpression> processor) {
        if (member == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(42);
        }
        if (processor == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(43);
        }
        return PsiTreeUtil.processElements((PsiElement)member, element -> {
            JSReferenceExpression referenceExpression;
            return !(element instanceof JSReferenceExpression) || !((referenceExpression = (JSReferenceExpression)element).getQualifier() instanceof JSThisExpression) || processor.process((Object)referenceExpression);
        });
    }

    @NotNull
    private static String getParameterName(@NotNull JSParameterList createdFunctionParameters, int index, String defaultName) {
        String name;
        JSParameterListElement[] parameters;
        if (createdFunctionParameters == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(44);
        }
        if ((parameters = createdFunctionParameters.getParameters()).length > index && !StringUtil.isEmpty((String)(name = parameters[index].getName()))) {
            String string = name;
            if (string == null) {
                ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(45);
            }
            return string;
        }
        String string = defaultName;
        if (string == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(46);
        }
        return string;
    }

    private static boolean isTrivialConstructor(@NotNull JSFunction member) {
        JSBlockStatement block;
        if (member == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(47);
        }
        if ((block = member.getBlock()) == null) {
            return true;
        }
        for (JSSourceElement item : block.getStatementListItems()) {
            if (item instanceof JSFunction || JSRefactoringUtil.isSuperCall(item) || ReactClassToFunctionalComponentHandler.isStateAssignment(item)) continue;
            return false;
        }
        return true;
    }

    private static boolean isStateAssignment(@NotNull JSSourceElement item) {
        if (item == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(48);
        }
        if (!(item instanceof JSExpressionStatement)) {
            return false;
        }
        JSExpression expression = ((JSExpressionStatement)item).getExpression();
        if (!(expression instanceof JSAssignmentExpression)) {
            return false;
        }
        JSDefinitionExpression definitionExpression = ((JSAssignmentExpression)expression).getDefinitionExpression();
        return definitionExpression != null && StringUtil.equals((CharSequence)definitionExpression.getName(), (CharSequence)"state");
    }

    @Nullable
    public static String showNameDialog(@NotNull Project project, @NotNull JSNamedElement elementForName) {
        if (project == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(49);
        }
        if (elementForName == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(50);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return DEFAULT_COMPONENT_NAME;
        }
        PsiElement scope = (PsiElement)ObjectUtils.coalesce((Object)JSUseScopeProvider.getUseScopeElement(elementForName), (Object)elementForName.getContainingFile());
        InputValidatorEx nameValidator = ReactExtractComponentHandler.createNameValidator(scope);
        return Messages.showInputDialog((Project)project, (String)"Component Name:", (String)ReactClassToFunctionalComponentHandler.getRefactoringTitle(), (Icon)Messages.getQuestionIcon(), null, (InputValidator)nameValidator);
    }

    private static void showErrorHint(@NotNull Project project, @NotNull Editor editor, String message) {
        if (project == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(51);
        }
        if (editor == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(52);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)ReactClassToFunctionalComponentHandler.getRefactoringTitle(), null);
    }

    public static String getRefactoringTitle() {
        return JavaScriptBundle.message((String)"refactoring.react.class.to.functional.refactoring.title", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 33: 
            case 36: 
            case 45: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 33: 
            case 36: 
            case 45: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: 
            case 9: 
            case 24: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introducedName";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticFields";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeUsages";
                break;
            }
            case 13: 
            case 18: 
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 17: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReplace";
                break;
            }
            case 19: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdDeclaration";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 33: 
            case 36: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/react/ReactClassToFunctionalComponentHandler";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propsParameterName";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextParameterName";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasProps";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasContext";
                break;
            }
            case 41: 
            case 42: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdFunctionParameters";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementForName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/react/ReactClassToFunctionalComponentHandler";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "expressionAwareReplace";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceSourceElement";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticFields";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterList";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoringInWriteAction";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "copyStaticFields";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "expressionAwareReplace";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 33: 
            case 36: 
            case 45: 
            case 46: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getFileLevelEntitiesCount";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretToElement";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "convertToExpression";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceTo";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "replaceSourceElement";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getStaticFields";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getPropsTypeFromClassGenericArgument";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createParameterList";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processRenderMethod";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "referencesState";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processThisReferences";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getParameterName";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isTrivialConstructor";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isStateAssignment";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "showNameDialog";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 33: 
            case 36: 
            case 45: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

