/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard.operations;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.guard.operations.JSApplyTypeOperationContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSTypeOperation;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSApplyTypeOperationContextImpl
implements JSApplyTypeOperationContext {
    @NotNull
    private final ProcessingContext myProcessingContext;
    @NotNull
    private final ProcessingContext mySubtypingProcessingContext;
    @NotNull
    private final NotNullLazyValue<JSType> myDeclaredTypeProvider;
    @Nullable
    private final JSType myRealType;
    @NotNull
    private final JSExpression myReference;
    @NotNull
    private final JSTypeSource mySource;
    private final boolean myUseAutoVariableType;
    private final boolean myUseAutoArrayType;
    private final boolean myIsTypeScript;
    private final boolean myStrictNullCheck;
    @NotNull
    private final Set<JSType> myEvolvingArrays;
    @NotNull
    private final Map<JSTypeOperation, Map<JSType, JSType>> myCachedOperations;

    @NotNull
    private static JSType getDeclaredType(@Nullable JSType startType, boolean isTypeScript, @NotNull JSTypeSource source, boolean useAutoVariableType) {
        if (source == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(0);
        }
        if (startType != null) {
            JSType jSType = JSTypeGuardChecker.getExactType(startType);
            if (jSType == null) {
                JSApplyTypeOperationContextImpl.$$$reportNull$$$0(1);
            }
            return jSType;
        }
        JSAnyType jSAnyType = isTypeScript && useAutoVariableType ? JSNamedTypeFactory.createType("Object", source, JSContext.INSTANCE) : JSAnyType.get(source);
        if (jSAnyType == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(2);
        }
        return jSAnyType;
    }

    public JSApplyTypeOperationContextImpl(@NotNull JSReferenceExpression reference, @Nullable JSType startType, boolean useAutoArrayType, boolean useAutoVariableType, boolean strictNullCheck) {
        if (reference == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(3);
        }
        this.myEvolvingArrays = new THashSet();
        this.myCachedOperations = new THashMap();
        this.myProcessingContext = JSTypeComparingContextService.getProcessingContextWithCache((PsiElement)reference);
        this.mySubtypingProcessingContext = JSTypeComparingContextService.getSubtypingProcessingContext((PsiElement)reference);
        this.myRealType = startType;
        this.myReference = reference;
        this.myIsTypeScript = DialectDetector.isTypeScript((PsiElement)reference);
        this.mySource = startType == null || startType instanceof JSAnyType ? JSTypeSourceFactory.createTypeSource((PsiElement)this.myReference, this.myIsTypeScript) : startType.getSource();
        this.myUseAutoVariableType = useAutoVariableType;
        this.myUseAutoArrayType = useAutoArrayType;
        this.myStrictNullCheck = strictNullCheck;
        this.myDeclaredTypeProvider = NotNullLazyValue.createValue(() -> JSApplyTypeOperationContextImpl.getDeclaredType(startType, this.myIsTypeScript, this.mySource, useAutoVariableType));
    }

    @Override
    @NotNull
    public ProcessingContext getProcessingContext() {
        ProcessingContext processingContext = this.myProcessingContext;
        if (processingContext == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(4);
        }
        return processingContext;
    }

    @Override
    @NotNull
    public ProcessingContext getSubtypingProcessingContext() {
        ProcessingContext processingContext = this.mySubtypingProcessingContext;
        if (processingContext == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(5);
        }
        return processingContext;
    }

    @Override
    @NotNull
    public JSExpression getContextReference() {
        JSExpression jSExpression = this.myReference;
        if (jSExpression == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(6);
        }
        return jSExpression;
    }

    @Override
    @NotNull
    public JSType getDeclaredType() {
        JSType jSType = (JSType)this.myDeclaredTypeProvider.getValue();
        if (jSType == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(7);
        }
        return jSType;
    }

    @Override
    @Nullable
    public JSType getRealType() {
        return this.myRealType;
    }

    @Override
    public boolean isAutoVariableType() {
        return this.myUseAutoVariableType;
    }

    @Override
    @NotNull
    public JSType narrowTypeByDiscriminant(@NotNull JSType type, @NotNull String propertyName, @NotNull Function<JSType, JSType> convertType) {
        JSType narrowedPropType;
        if (type == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(8);
        }
        if (propertyName == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(9);
        }
        if (convertType == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(10);
        }
        if (!this.myIsTypeScript) {
            JSType jSType = type;
            if (jSType == null) {
                JSApplyTypeOperationContextImpl.$$$reportNull$$$0(11);
            }
            return jSType;
        }
        JSType propType = JSApplyTypeOperationContextImpl.getTypeOfPropertyOfType(type, propertyName);
        JSType jSType = narrowedPropType = propType == null ? null : (JSType)convertType.fun((Object)propType);
        if (narrowedPropType == null) {
            JSType jSType2 = type;
            if (jSType2 == null) {
                JSApplyTypeOperationContextImpl.$$$reportNull$$$0(12);
            }
            return jSType2;
        }
        if (narrowedPropType instanceof TypeScriptNeverJSTypeImpl) {
            JSType jSType3 = this.processNeverType(type, narrowedPropType);
            if (jSType3 == null) {
                JSApplyTypeOperationContextImpl.$$$reportNull$$$0(13);
            }
            return jSType3;
        }
        JSType result2 = propType == narrowedPropType ? type : TypeScriptTypeRelations.filterType(type, (Predicate<? super JSType>)((Predicate)el -> TypeScriptTypeRelations.isTypeComparableTo(JSApplyTypeOperationContextImpl.getTypeOfPropertyOfType(el, propertyName), narrowedPropType, this.getProcessingContext())), (PsiElement)this.getContextReference());
        JSType jSType4 = this.processNeverType(type, result2);
        if (jSType4 == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(14);
        }
        return jSType4;
    }

    @Override
    @Nullable
    public JSType expandOperationType(@NotNull JSType type) {
        PsiElement expression;
        if (type == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(15);
        }
        if (type instanceof JSPsiBasedTypeOfType && PsiTreeUtil.isAncestor((PsiElement)(expression = ((JSPsiBasedTypeOfType)type).getElement()), (PsiElement)this.myReference, (boolean)false)) {
            return null;
        }
        return JSTypeGuardChecker.getExactType(type);
    }

    @Override
    @Nullable
    public JSType getCachedResult(@NotNull JSTypeOperation operation, @NotNull JSType type) {
        Map<JSType, JSType> cacheValue;
        if (operation == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(16);
        }
        if (type == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(17);
        }
        return (cacheValue = this.myCachedOperations.get(operation)) == null ? null : cacheValue.get(type);
    }

    @Override
    public void putCacheResult(@NotNull JSTypeOperation operation, @NotNull JSType type, @NotNull JSType resultType) {
        if (operation == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(18);
        }
        if (type == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(19);
        }
        if (resultType == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(20);
        }
        Map result2 = this.myCachedOperations.computeIfAbsent(operation, key -> new THashMap());
        result2.put(type, resultType);
    }

    @Override
    @NotNull
    public JSTypeSource getDefaultTypeSource() {
        JSTypeSource jSTypeSource = this.mySource;
        if (jSTypeSource == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(21);
        }
        return jSTypeSource;
    }

    @Override
    public boolean strictNullChecks() {
        return this.myStrictNullCheck;
    }

    @Override
    public boolean isAutoArrayType() {
        return this.myUseAutoArrayType;
    }

    @Override
    @NotNull
    public JSType getNarrowedType(@NotNull JSType type, @NotNull JSType candidate, boolean assumeTrue, @NotNull JSTypeGuardChecker.TypeRelation relation) {
        JSType assignableType;
        if (type == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(22);
        }
        if (candidate == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(23);
        }
        if (relation == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(24);
        }
        if (!assumeTrue) {
            JSType jSType = TypeScriptTypeRelations.filterType(type, (Predicate<? super JSType>)((Predicate)t -> !relation.isRelated((JSType)t, candidate)), (PsiElement)this.myReference);
            if (jSType == null) {
                JSApplyTypeOperationContextImpl.$$$reportNull$$$0(25);
            }
            return jSType;
        }
        if (JSTypeUtils.unwrapType(type) instanceof JSUnionType && !((assignableType = TypeScriptTypeRelations.filterType(type, (Predicate<? super JSType>)((Predicate)t -> relation.isRelated((JSType)t, candidate)), (PsiElement)this.myReference)) instanceof TypeScriptNeverJSTypeImpl)) {
            JSType jSType = assignableType;
            if (jSType == null) {
                JSApplyTypeOperationContextImpl.$$$reportNull$$$0(26);
            }
            return jSType;
        }
        if (TypeScriptTypeRelations.isTypeSubtypeOf(candidate, type, this.mySubtypingProcessingContext)) {
            JSType jSType = candidate;
            if (jSType == null) {
                JSApplyTypeOperationContextImpl.$$$reportNull$$$0(27);
            }
            return jSType;
        }
        if (TypeScriptTypeRelations.isTypeAssignableTo(type, candidate, this.myProcessingContext)) {
            JSType jSType = type;
            if (jSType == null) {
                JSApplyTypeOperationContextImpl.$$$reportNull$$$0(28);
            }
            return jSType;
        }
        if (TypeScriptTypeRelations.isTypeAssignableTo(candidate, type, this.myProcessingContext)) {
            JSType jSType = candidate;
            if (jSType == null) {
                JSApplyTypeOperationContextImpl.$$$reportNull$$$0(29);
            }
            return jSType;
        }
        return JSApplyTypeOperationContextImpl.getIntersectionTypeWithProcessingDecorators(type, candidate);
    }

    @NotNull
    private static JSType getIntersectionTypeWithProcessingDecorators(@NotNull JSType type, @NotNull JSType candidate) {
        if (type == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(30);
        }
        if (candidate == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(31);
        }
        JSType jSType = JSCompositeTypeFactory.createIntersectionType((Collection<? extends JSType>)ContainerUtil.immutableList((Object[])new JSType[]{type, candidate}), candidate.getSource());
        if (jSType == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(32);
        }
        return jSType;
    }

    @Override
    public JSType processNeverType(@Nullable JSType type, @Nullable JSType resultOrNeverType) {
        if (this.myIsTypeScript) {
            return resultOrNeverType;
        }
        return resultOrNeverType instanceof TypeScriptNeverJSTypeImpl ? type : resultOrNeverType;
    }

    @Override
    public boolean isEvolvingArrayType(@NotNull JSType arrayType) {
        if (arrayType == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(33);
        }
        return this.myEvolvingArrays.contains(arrayType);
    }

    @Override
    @NotNull
    public JSType getEvolvingArrayType(@NotNull JSType parameterType) {
        if (parameterType == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(34);
        }
        JSArrayTypeImpl type = new JSArrayTypeImpl(parameterType, this.getDefaultTypeSource());
        this.myEvolvingArrays.add(type);
        JSArrayTypeImpl jSArrayTypeImpl = type;
        if (jSArrayTypeImpl == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(35);
        }
        return jSArrayTypeImpl;
    }

    @Override
    @NotNull
    public JSType finalizeEvolvingArrayType(@NotNull JSType arrayType) {
        if (arrayType == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(36);
        }
        if (arrayType instanceof JSArrayType && !((JSArrayType)arrayType).isPrimitive()) {
            JSType type = ((JSArrayType)arrayType).getType();
            if (type instanceof TypeScriptNeverJSTypeImpl) {
                JSType jSType = this.getDeclaredType();
                if (jSType == null) {
                    JSApplyTypeOperationContextImpl.$$$reportNull$$$0(37);
                }
                return jSType;
            }
            this.myEvolvingArrays.remove(arrayType);
        }
        JSType jSType = arrayType;
        if (jSType == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(38);
        }
        return jSType;
    }

    @Nullable
    public static JSType getTypeOfPropertyOfType(@Nullable JSType type, @NotNull String propertyName) {
        if (propertyName == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(39);
        }
        if (type == null) {
            return null;
        }
        JSRecordType recordType = JSTypeUtils.removeNullableComponents(type).asRecordType();
        JSRecordType.PropertySignature signature = recordType.findPropertySignature(propertyName);
        if (signature == null) {
            return null;
        }
        JSType jsType = signature.getJSType();
        if (signature.isOptional() && jsType != null) {
            jsType = TypeScriptTypeGuard.wrapWithUndefined(jsType, jsType.getSource());
        }
        return JSTypeGuardChecker.getExactType(jsType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 35: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 35: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 35: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/operations/JSApplyTypeOperationContextImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 8: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertType";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 23: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relation";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/operations/JSApplyTypeOperationContextImpl";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessingContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubtypingProcessingContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextReference";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByDiscriminant";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTypeSource";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getNarrowedType";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntersectionTypeWithProcessingDecorators";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvolvingArrayType";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "finalizeEvolvingArrayType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredType";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 35: 
            case 37: 
            case 38: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByDiscriminant";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "expandOperationType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCachedResult";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "putCacheResult";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getNarrowedType";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getIntersectionTypeWithProcessingDecorators";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isEvolvingArrayType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getEvolvingArrayType";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "finalizeEvolvingArrayType";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getTypeOfPropertyOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 35: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

