/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.stubs.JSBaseTypesIndex;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.types.evaluable.JSDestructuringTypeImpl;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStubIndexingUtils {
    public static void addImplicitNamespaces(@NotNull JSQualifiedName elementQualifiedName, @NotNull Collection<? super JSImplicitElement> outElements, @Nullable PsiElement element) {
        if (elementQualifiedName == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(0);
        }
        if (outElements == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(1);
        }
        for (JSQualifiedName parent = elementQualifiedName.getParent(); parent != null; parent = parent.getParent()) {
            JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(parent.getName(), element).setNamespace(parent.getParent()).setProperties(JSImplicitElement.Property.MinorImportance).setType(JSImplicitElement.Type.Namespace);
            outElements.add((JSImplicitElement)new JSImplicitElementImpl(builder));
        }
    }

    public static void processExtendCall(@NotNull JSReferenceExpression typeExpression, @NotNull JSReferenceExpression baseTypeExpression, @NotNull JSContext extensionContext, @NotNull JSElementIndexingData outIndexingData) {
        if (typeExpression == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(2);
        }
        if (baseTypeExpression == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(3);
        }
        if (extensionContext == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(4);
        }
        if (outIndexingData == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(5);
        }
        JSStubIndexingUtils.processExtendCall(JSStubIndexingUtils.getNamespaceFromReferenceExpression(typeExpression, extensionContext), JSStubIndexingUtils.getNamespaceFromReferenceExpression(baseTypeExpression, extensionContext), outIndexingData);
    }

    @NotNull
    public static JSNamespace getNamespaceFromReferenceExpression(@NotNull JSReferenceExpression referenceExpression, @NotNull JSContext jsContext) {
        JSQualifiedName qualifiedName;
        JSNamespace ns;
        if (referenceExpression == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(6);
        }
        if (jsContext == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(7);
        }
        if ((ns = JSSymbolUtil.evaluateNamespaceLocally(referenceExpression)) == null) {
            ns = JSSymbolUtil.createNamespaceFromReferenceExpression(referenceExpression, jsContext, true);
        }
        if (ns != null) {
            qualifiedName = ns.getQualifiedName();
            if (ns.getJSContext() != JSContext.UNKNOWN) {
                jsContext = JSTypeUtils.combineJSContexts(jsContext, ns.getJSContext());
            }
        } else {
            qualifiedName = null;
        }
        JSNamespace jSNamespace = JSNamedTypeFactory.createNamespace(qualifiedName, jsContext, (PsiElement)referenceExpression, false);
        if (jSNamespace == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(8);
        }
        return jSNamespace;
    }

    public static void processExtendCall(@NotNull JSNamespace ns, @NotNull JSNamespace baseNs, @NotNull JSElementIndexingData outIndexingData) {
        if (ns == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(9);
        }
        if (baseNs == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(10);
        }
        if (outIndexingData == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(11);
        }
        JSQualifiedName qName = ns.getQualifiedName();
        JSQualifiedName baseQName = baseNs.getQualifiedName();
        if (qName == null || baseQName == null) {
            return;
        }
        if (ns.getJSContext() != JSContext.STATIC && baseNs.getJSContext() != JSContext.STATIC) {
            outIndexingData.addBaseType(JSBaseTypesIndex.getTextForProcessingHierarchy(qName, JSContext.INSTANCE), JSBaseTypesIndex.getTextForProcessingHierarchy(baseQName, JSContext.INSTANCE));
        }
        if (ns.getJSContext() != JSContext.INSTANCE && baseNs.getJSContext() != JSContext.INSTANCE) {
            outIndexingData.addBaseType(JSBaseTypesIndex.getTextForProcessingHierarchy(qName, JSContext.STATIC), JSBaseTypesIndex.getTextForProcessingHierarchy(baseQName, JSContext.STATIC));
        }
        if (ns.getJSContext() != JSContext.INSTANCE && baseNs.getJSContext() != JSContext.STATIC) {
            outIndexingData.addBaseType(JSBaseTypesIndex.getTextForProcessingHierarchy(qName, JSContext.STATIC), JSBaseTypesIndex.getTextForProcessingHierarchy(baseQName, JSContext.INSTANCE));
        }
        if (ns.getJSContext() != JSContext.STATIC && baseNs.getJSContext() != JSContext.INSTANCE) {
            outIndexingData.addBaseType(JSBaseTypesIndex.getTextForProcessingHierarchy(qName, JSContext.INSTANCE), JSBaseTypesIndex.getTextForProcessingHierarchy(baseQName, JSContext.STATIC));
        }
    }

    public static boolean keepsInitializerStub(@NotNull JSInitializerOwner initializerOwner) {
        if (initializerOwner == null) {
            JSStubIndexingUtils.$$$reportNull$$$0(12);
        }
        return JSStubIndexingUtils.isInStubTree(initializerOwner.getInitializer());
    }

    public static boolean isInStubTree(@Nullable JSExpression element) {
        if ((element = JSUtils.unparenthesize(element)) == null) {
            return false;
        }
        ASTNode elementNode = element.getNode();
        IElementType initializerElementType = elementNode.getElementType();
        return initializerElementType instanceof IStubElementType && ((IStubElementType)initializerElementType).shouldCreateStub(elementNode);
    }

    public static boolean needSerializeType(@Nullable JSType type) {
        if (type instanceof JSWidenType) {
            type = ((JSWidenType)type).getOriginalType();
        }
        return !(type instanceof JSDestructuringTypeImpl);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementQualifiedName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outElements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseTypeExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionContext";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outIndexingData";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseNs";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializerOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceFromReferenceExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addImplicitNamespaces";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processExtendCall";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceFromReferenceExpression";
                break;
            }
            case 8: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "keepsInitializerStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

