/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSModuleElementsProcessor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitMemberForComputedPropertyImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptMergedTypeImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyInstanceContextElement;
import com.intellij.lang.javascript.psi.resolve.processors.JSModuleElementsResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSQualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeFunctionPropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSExtendingTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JsonObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualifiedItemProcessor<T extends ResultSink>
extends SinkResolveProcessor<T>
implements JSQualifiedItemProcessor,
JSModuleElementsProcessor {
    protected final boolean myEcma;
    protected final boolean myTypeScript;
    public TypeResolveState resolved = TypeResolveState.Unknown;

    public QualifiedItemProcessor(T sink, PsiFile containingFile) {
        super(sink);
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)ObjectUtils.coalesce((Object)this.place, (Object)containingFile));
        this.myEcma = holder != null && holder.isECMA4;
        this.myTypeScript = holder != null && holder.isTypeScript;
        this.setToProcessHierarchy(true);
    }

    protected void forceResolvedState() {
        this.resolved = TypeResolveState.Resolved;
    }

    @Override
    public final void process(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, @Nullable PsiElement source) {
        if (type == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(0);
        }
        if (evaluateContext == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(1);
        }
        if (evaluateContext.ensureProcessed(type = type.substitute())) {
            return;
        }
        this.processImpl(type, evaluateContext, source);
    }

    protected void processImpl(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, @Nullable PsiElement source) {
        PsiElement element;
        JSType constraintType;
        if (type == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(2);
        }
        if (evaluateContext == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(3);
        }
        if (type instanceof JSGenericParameterImpl && (constraintType = ((JSGenericParameterImpl)type).getConstraintType()) != null) {
            type = constraintType;
        }
        if (type instanceof JSRecordType) {
            this.processRecordTypeImpl((JSRecordType)type);
            if (this.myTypeScript && type.getSource().isStrict() && this.resolved != TypeResolveState.PrefixUnknown) {
                this.forceResolvedState();
            }
            return;
        }
        if (type instanceof JsonObjectType && (element = type.getSourceElement()) instanceof JsonElement) {
            this.processResolvedElement(element, evaluateContext);
        }
        if (type instanceof JSExtendingTypeImpl) {
            this.process(((JSExtendingTypeImpl)type).getType(), evaluateContext, source);
            int level = ((ResultSink)this.getResultSink()).getNestingLevel();
            ((ResultSink)this.getResultSink()).setNestingLevel(level + 1);
            this.process(((JSExtendingTypeImpl)type).getParentType(), evaluateContext, source);
            ((ResultSink)this.getResultSink()).setNestingLevel(level);
            return;
        }
        if (!JSTypeUtils.processExpandedType(this, type, evaluateContext, source)) {
            return;
        }
        this.processActionScriptClass(type, evaluateContext, source);
    }

    private void processActionScriptClass(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, @Nullable PsiElement source) {
        PsiElement clazz;
        if (type == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(4);
        }
        if (evaluateContext == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(5);
        }
        if (!this.myEcma && !(source instanceof XmlBackedJSClass)) {
            return;
        }
        String typeString = JSTypeUtils.getQualifiedNameMatchingType(type, true);
        if (type instanceof JSAnyType || typeString == null) {
            return;
        }
        PsiElement placeParent = this.place.getParent();
        boolean setTypeContext = placeParent instanceof JSReferenceListMember;
        PsiElement psiElement = clazz = source instanceof JSClass || source instanceof XmlFile ? source : JSClassResolver.findClassFromNamespace(typeString, this.place);
        if (clazz instanceof JSQualifiedNamedElement && this.needProcessTypeMembers(source, clazz)) {
            PsiElement typeSource = evaluateContext.getSource();
            AccessibilityProcessingHandler.processWithStatic(this, false, () -> {
                this.addTypeFromClass(type, evaluateContext, typeString, typeSource, setTypeContext, (JSQualifiedNamedElement)clazz);
                return true;
            });
        }
        if (type instanceof JSObjectType) {
            this.resolved = TypeResolveState.Unknown;
        } else if (!(clazz instanceof JSQualifiedNamedElement) && type.getSource().isStrict()) {
            this.forceResolvedState();
        }
    }

    @Override
    public void processNamespace(@NotNull JSNamespace namespace, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
        if (namespace == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(6);
        }
        if (evaluateContext == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(7);
        }
        this.process((JSType)namespace, evaluateContext, source);
    }

    @Override
    public void processResolvedElement(@NotNull PsiElement element, @NotNull JSEvaluationResultContext evaluateContext) {
        if (element == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(8);
        }
        if (evaluateContext == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(9);
        }
        if (!QualifiedItemProcessor.processResolvedElement(element, evaluateContext, this, this.place)) {
            this.forceResolvedState();
        }
    }

    public static boolean processResolvedElement(@NotNull PsiElement element, @NotNull JSEvaluationResultContext evaluateContext, @NotNull JSResolveProcessor processor, @NotNull PsiElement place) {
        if (element == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(10);
        }
        if (evaluateContext == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(12);
        }
        if (place == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(13);
        }
        if (element instanceof JsonElement) {
            JsonValue value = null;
            if (element instanceof JsonFile) {
                JsonFile file2 = (JsonFile)element;
                value = (JsonValue)AstLoadingFilter.forceAllowTreeLoading((PsiFile)file2, () -> file2.getTopLevelValue());
            } else if (element instanceof JsonProperty) {
                value = ((JsonProperty)element).getValue();
            } else if (element instanceof JsonValue) {
                value = (JsonValue)element;
            }
            if (value instanceof JsonObject) {
                String name = processor.getName();
                if (name != null) {
                    JsonProperty property = ((JsonObject)value).findProperty(name);
                    if (property != null) {
                        processor.execute((PsiElement)property, ResolveState.initial());
                        return false;
                    }
                } else {
                    List list2 = ((JsonObject)value).getPropertyList();
                    for (JsonProperty property : list2) {
                        processor.execute((PsiElement)property, ResolveState.initial());
                    }
                }
            }
        } else if (element instanceof JSFile) {
            JSModuleElementsProcessor moduleElementsProcessor;
            JSModuleElementsProcessor jSModuleElementsProcessor = moduleElementsProcessor = processor instanceof JSModuleElementsProcessor ? (JSModuleElementsProcessor)processor : new JSModuleElementsResolveProcessor(processor);
            if (!ES6PsiUtil.processExportDeclarationInScope((JSElement)((JSFile)element), moduleElementsProcessor, evaluateContext, null)) {
                return false;
            }
        } else {
            JSReferenceExpression expression;
            if (element instanceof StylesheetFile) {
                CssStylesheet stylesheet = ((StylesheetFile)element).getStylesheet();
                if (stylesheet != null) {
                    QualifiedItemProcessor.processCssClasses(stylesheet, processor);
                }
                return false;
            }
            if (element instanceof JSClassExpression) {
                boolean isStatic = !(evaluateContext.peekJSElementToApply() instanceof JSApplyInstanceContextElement);
                return AccessibilityProcessingHandler.processWithStatic(processor, isStatic, () -> element.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), element, place));
            }
            if (element instanceof JSPackageWrapper && (expression = evaluateContext.getProcessedExpression()) != null) {
                element.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), (PsiElement)expression, (PsiElement)expression);
                return false;
            }
        }
        return true;
    }

    private static void processCssClasses(@NotNull CssStylesheet stylesheet, @NotNull JSResolveProcessor processor) {
        if (stylesheet == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(15);
        }
        for (CssRuleset cssRuleset : stylesheet.getRulesets()) {
            QualifiedItemProcessor.processCssClasses(cssRuleset, processor);
        }
    }

    private static void processCssClasses(@NotNull CssRuleset cssRuleset, @NotNull JSResolveProcessor processor) {
        if (cssRuleset == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(17);
        }
        for (CssSelector cssSelector : cssRuleset.getSelectors()) {
            for (CssSimpleSelector simpleSelector : cssSelector.getSimpleSelectors()) {
                for (CssSelectorSuffix selectorSuffix : simpleSelector.getSelectorSuffixes()) {
                    String name;
                    if (!(selectorSuffix instanceof CssClass) || (name = selectorSuffix.getName()) == null) continue;
                    processor.execute((PsiElement)selectorSuffix, ResolveState.initial());
                }
            }
        }
        for (CssSelector cssSelector : cssRuleset.getNestedRulesets()) {
            QualifiedItemProcessor.processCssClasses((CssRuleset)cssSelector, processor);
        }
    }

    private void processRecordTypeImpl(@NotNull JSRecordType type) {
        JSRecordType.IndexSignature indexer;
        List<PsiElement> results;
        String name;
        if (type == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(18);
        }
        if (type == JSTypeCastUtil.NO_RECORD_TYPE) {
            return;
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        if (sourceElement == null && ApplicationManager.getApplication().isUnitTestMode()) {
            Logger.getInstance(this.getClass()).error((Throwable)((Object)new AssertionError((Object)"Record type source must be not empty")));
        }
        boolean isSimpleRecordWithDefinedSource = type instanceof JSSimpleRecordTypeImpl && sourceElement != null && sourceElement.isValid();
        boolean isTypeScriptObjectType = sourceElement instanceof TypeScriptObjectType;
        if (isSimpleRecordWithDefinedSource && (sourceElement instanceof JSClassExpression || isTypeScriptObjectType)) {
            boolean processBaseDeclarations;
            Stream<JSType> constructors = JSTypeUtils.getFunctionType((JSType)type, true, this.place);
            this.getAccessibilityProcessingHandler().setProcessStatics(constructors.findAny().isPresent());
            boolean bl = processBaseDeclarations = sourceElement.processDeclarations((PsiScopeProcessor)this, ResolveState.initial(), sourceElement, this.place) || isTypeScriptObjectType && QualifiedItemProcessor.hasOnlyIndexers(this.getResults());
            if (processBaseDeclarations && isTypeScriptObjectType) {
                boolean hasCallSignature = false;
                boolean hasConstructSignature = false;
                for (TypeScriptTypeMember typeMember : ((TypeScriptObjectType)sourceElement).getTypeMembers()) {
                    hasCallSignature |= typeMember instanceof JSRecordType.CallSignature && !((JSRecordType.CallSignature)typeMember).hasNew();
                    hasConstructSignature |= typeMember instanceof JSRecordType.CallSignature && ((JSRecordType.CallSignature)typeMember).hasNew();
                }
                this.processSuperClassMembers(sourceElement, hasCallSignature, hasConstructSignature);
            }
            return;
        }
        if (isSimpleRecordWithDefinedSource && sourceElement instanceof JSObjectLiteralExpression) {
            for (JSProperty property : ((JSObjectLiteralExpression)sourceElement).getProperties()) {
                if (this.execute((PsiElement)property, ResolveState.initial())) continue;
                return;
            }
        }
        boolean isDynamicResolve = !isSimpleRecordWithDefinedSource && this.getResultSink() instanceof ResolveResultSink && (sourceElement == null || !DialectDetector.isTypeScript(sourceElement));
        for (JSRecordType.PropertySignature typeMember : type.getProperties()) {
            String name2 = this.getName();
            if (name2 != null && !name2.equals(typeMember.getMemberName()) || this.processRecordTypeMember(sourceElement, isSimpleRecordWithDefinedSource, isDynamicResolve, (JSRecordType.TypeMember)typeMember)) continue;
            return;
        }
        if (sourceElement != null && sourceElement.isValid() && DialectDetector.isTypeScript(sourceElement)) {
            boolean hasCallSignature = false;
            boolean hasConstructSignature = false;
            List signatures = type.getCallSignatures();
            for (JSRecordType.CallSignature signature : signatures) {
                hasCallSignature |= !signature.hasNew();
                hasConstructSignature |= signature.hasNew();
            }
            this.processSuperClassMembers(sourceElement, hasCallSignature, hasConstructSignature);
        }
        if ((name = this.getName()) != null && type.hasIndexers() && ((results = this.getResults()) == null || results.isEmpty()) && (indexer = type.findIndexer(JSRecordType.IndexSignatureKind.STRING)) != null && !indexer.isForComputedProperty()) {
            PsiElement element = indexer.getMemberSource().getSingleElement();
            if (element == null) {
                element = sourceElement;
            }
            this.execute((PsiElement)new TypeScriptImplicitMemberForComputedPropertyImpl(name, indexer.getMemberType(), element, false), ResolveState.initial());
        }
    }

    public static boolean hasOnlyIndexers(List<PsiElement> results) {
        return results != null && results.stream().allMatch(e -> e instanceof TypeScriptIndexSignature);
    }

    private boolean processRecordTypeMember(@Nullable PsiElement sourceElement, boolean isSimpleRecordWithDefinedSource, boolean isDynamicResolve, @NotNull JSRecordType.TypeMember typeMember) {
        if (typeMember == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(19);
        }
        Collection<PsiElement> elements = QualifiedItemProcessor.getElementsForTypeMember(typeMember, sourceElement, !isSimpleRecordWithDefinedSource);
        boolean added = false;
        for (PsiElement element : elements) {
            if (element == null) continue;
            if (isDynamicResolve) {
                this.addPossibleCandidateResult(element, null);
                continue;
            }
            if (element instanceof JSImplicitElement && !(element instanceof TypeScriptProxyImplicitElement)) {
                this.addResult(element);
                continue;
            }
            if (this.execute(element, ResolveState.initial())) continue;
            added = true;
        }
        return !added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSuperClassMembers(@NotNull PsiElement sourceElement, boolean hasCallSignature, boolean hasConstructSignature) {
        if (sourceElement == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(20);
        }
        int level = ((ResultSink)this.getResultSink()).getNestingLevel();
        boolean processStatics = this.getAccessibilityProcessingHandler().isProcessStatics();
        ((ResultSink)this.getResultSink()).setNestingLevel(10);
        this.getAccessibilityProcessingHandler().setProcessStatics(false);
        try {
            String classParentName = hasCallSignature || hasConstructSignature ? JSTypeUtils.getFunctionTypeName(sourceElement.getContainingFile(), hasConstructSignature) : "Object";
            for (JSQualifiedNamedElement object : TypeScriptClassResolver.getInstance().findElementsByQNameFilteredByConfig(classParentName, sourceElement)) {
                TypeScriptQualifiedItemProcessor.processNamespaceChildren(this, ResolveState.initial(), sourceElement, this.place, (PsiElement)object);
            }
        }
        finally {
            ((ResultSink)this.getResultSink()).setNestingLevel(level);
            this.getAccessibilityProcessingHandler().setProcessStatics(processStatics);
        }
    }

    @NotNull
    public static Collection<PsiElement> getElementsForTypeMember(@NotNull JSRecordType.TypeMember typeMember, @Nullable PsiElement sourceElement, boolean createImplicitElement) {
        if (typeMember == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(21);
        }
        if (typeMember instanceof PsiElement) {
            List<PsiElement> list2 = Collections.singletonList((PsiElement)typeMember);
            if (list2 == null) {
                QualifiedItemProcessor.$$$reportNull$$$0(22);
            }
            return list2;
        }
        if (typeMember instanceof JSCompositeFunctionPropertySignatureImpl) {
            ArrayList<PsiElement> results = new ArrayList<PsiElement>();
            for (JSRecordType.PropertySignature signature : ((JSCompositeFunctionPropertySignatureImpl)typeMember).getMembers()) {
                results.addAll(QualifiedItemProcessor.getElementsForTypeMember((JSRecordType.TypeMember)signature, sourceElement, createImplicitElement));
            }
            ArrayList<PsiElement> arrayList = results;
            if (arrayList == null) {
                QualifiedItemProcessor.$$$reportNull$$$0(23);
            }
            return arrayList;
        }
        JSRecordType.MemberSource ownSource = typeMember.getMemberSource();
        if (createImplicitElement && typeMember instanceof JSRecordType.PropertySignature) {
            JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)typeMember;
            JSType propertySignatureType = propertySignature.getJSType();
            return QualifiedItemProcessor.createImplicitElements(sourceElement, propertySignature, propertySignatureType);
        }
        List list3 = ContainerUtil.createMaybeSingletonList((Object)ownSource.getSingleElement());
        if (list3 == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(24);
        }
        return list3;
    }

    @NotNull
    private static Collection<PsiElement> createImplicitElements(@Nullable PsiElement sourceElement, @NotNull JSRecordType.PropertySignature propertySignature, @Nullable JSType propertySignatureType) {
        JSRecordType.MemberSource source;
        if (propertySignature == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(25);
        }
        if (!(source = propertySignature.getMemberSource()).isMerged()) {
            PsiElement propertySource = source.getSingleElement();
            final boolean hasType = propertySignatureType != null;
            final boolean isConst = propertySignature.isConst();
            PsiElement provider = (PsiElement)ObjectUtils.coalesce((Object)propertySource, (Object)sourceElement);
            String name = propertySignature.getMemberName();
            JSLocalImplicitElementImpl element = provider != null ? new JSLocalImplicitElementImpl(name, propertySignatureType, provider, null){

                @Override
                public boolean hasMinorImportance() {
                    return !hasType;
                }

                @Override
                public boolean isConst() {
                    return isConst;
                }
            } : null;
            List list2 = ContainerUtil.createMaybeSingletonList((Object)((Object)element));
            if (list2 == null) {
                QualifiedItemProcessor.$$$reportNull$$$0(26);
            }
            return list2;
        }
        List elements = source.getAllSourceElements();
        boolean readonly = propertySignature.isConst() || source.isReadonly() || source.isForceReadonly();
        boolean optional = propertySignature.isOptional() && source.isOptional() || source.isForceOptional();
        boolean hasSingleDoc = source.hasSingleDocumentation();
        Collection collection = elements.stream().filter(e -> e != null).map(e -> new TypeScriptMergedTypeImplicitElementImpl(propertySignature.getMemberName(), propertySignatureType, (PsiElement)e, readonly, optional, hasSingleDoc, source.getSourceKind())).collect(Collectors.toList());
        if (collection == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(27);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypeFromClass(JSType type, JSEvaluateContext evaluateContext, String typeString, PsiElement typeSource, boolean setTypeContext, JSQualifiedNamedElement jsClass) {
        JSExpression placeQualifier;
        JSReferenceExpression evaluateQualifier;
        if ("RemoteObject".equals(jsClass.getName()) && typeSource instanceof JSOffsetBasedImplicitElement && ((JSOffsetBasedImplicitElement)typeSource).getType() == JSImplicitElement.Type.Tag) {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)((JSOffsetBasedImplicitElement)typeSource).getElementAtOffset(), XmlTag.class);
            for (XmlTag method : tag.findSubTags("method", tag.getNamespace())) {
                if (!this.execute((PsiElement)method, ResolveState.initial())) break;
            }
            this.forceResolvedState();
            return;
        }
        boolean statics = false;
        if (!(!JSPsiImplUtils.isTheSameClass(typeSource, jsClass) || (evaluateQualifier = evaluateContext.getProcessedExpression()) == null || (placeQualifier = evaluateQualifier.getQualifier()) instanceof JSCallExpression || evaluateQualifier.getParent() instanceof JSCallExpression || evaluateQualifier.getParent() instanceof JSParenthesizedExpression || placeQualifier instanceof JSParenthesizedExpression)) {
            statics = true;
        }
        if (type instanceof JSNamedType && ((JSNamedType)type).isStaticOrInstance() == JSContext.STATIC) {
            statics = true;
        }
        this.getAccessibilityProcessingHandler().setProcessStatics(statics);
        if (statics) {
            this.setTypeName(jsClass.getQualifiedName());
        }
        boolean saveSetTypeContext = this.isTypeContext();
        boolean saveToProcessMembers = this.isToProcessMembers();
        if (setTypeContext) {
            this.setTypeContext(setTypeContext);
            this.setToProcessMembers(false);
        }
        try {
            JSAttributeList attrList;
            if (!this.resolved.isResolved() && ("XML".equals(typeString) || "XMLList".equals(typeString))) {
                this.resolved = TypeResolveState.PrefixUnknown;
            }
            if (!jsClass.processDeclarations((PsiScopeProcessor)this, ResolveState.initial(), (PsiElement)jsClass, this.place)) {
                this.forceResolvedState();
            }
            if (this.myEcma && ((attrList = ((JSAttributeListOwner)jsClass).getAttributeList()) == null || !attrList.hasModifier(JSAttributeList.ModifierType.DYNAMIC))) {
                this.forceResolvedState();
            }
        }
        finally {
            if (setTypeContext) {
                this.setTypeContext(saveSetTypeContext);
                this.setToProcessMembers(saveToProcessMembers);
            }
        }
    }

    protected boolean needProcessTypeMembers(PsiElement element, PsiElement clazz) {
        return clazz instanceof JSClass;
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(28);
        }
        if (state == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(29);
        }
        if (this.needPackages() && !(element instanceof JSPackageWrapper)) {
            return true;
        }
        if (this.resolved == TypeResolveState.PrefixUnknown && this.myName != null && element instanceof JSFunction && !(this.place.getParent() instanceof JSCallExpression)) {
            return true;
        }
        boolean b = super.execute(element, state);
        if (this.myEcma && this.getResult() != null) {
            this.forceResolvedState();
        }
        return b;
    }

    @Override
    public void prefixResolved() {
        if (this.myEcma || this.myTypeScript) {
            this.forceResolvedState();
        }
    }

    @Override
    protected void elementIsNotAccessible(PsiElement element) {
        super.elementIsNotAccessible(element);
        if (this.myEcma || this.myTypeScript) {
            this.forceResolvedState();
        }
    }

    @Override
    public void setUnknownElement(@NotNull PsiElement element) {
        if (element == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(30);
        }
        if (!(element instanceof XmlToken)) {
            boolean currentIsNotResolved = QualifiedItemProcessor.isDummyResolve(element, this.place);
            this.resolved = currentIsNotResolved ? TypeResolveState.PrefixUnknown : TypeResolveState.Unknown;
        }
    }

    private static boolean isDummyResolve(PsiElement element, PsiElement place) {
        if (place instanceof JSReferenceExpressionImpl) {
            JSExpression originalQualifier = BaseJSSymbolProcessor.getOriginalQualifier(((JSReferenceExpressionImpl)place).getResolveQualifier());
            if (originalQualifier instanceof JSCallExpression) {
                originalQualifier = ((JSCallExpression)originalQualifier).getMethodExpression();
            }
            return originalQualifier == element;
        }
        return false;
    }

    public boolean noMoreResultsPossible() {
        return this.resolved == TypeResolveState.Resolved || this.resolved == TypeResolveState.Undefined && (this.myTypeScript || this.myEcma) || this.resolved == TypeResolveState.PrefixUnknown && this.myEcma;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 8: 
            case 10: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stylesheet";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssRuleset";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMember";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/QualifiedItemProcessor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySignature";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/QualifiedItemProcessor";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsForTypeMember";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createImplicitElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processActionScriptClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processNamespace";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processResolvedElement";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processCssClasses";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processRecordTypeImpl";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processRecordTypeMember";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processSuperClassMembers";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getElementsForTypeMember";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createImplicitElements";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setUnknownElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum TypeResolveState {
        Unknown,
        Resolved,
        ResolvedAllowsExtras,
        Undefined,
        PrefixUnknown;


        public boolean isResolved() {
            return this == Resolved || this == ResolvedAllowsExtras;
        }

        public boolean isSuitableForReferenceResolve() {
            return this.isResolved() || this == Undefined;
        }
    }
}

