/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.nashorn.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.ecmascript6.parsing.ES6ExpressionParser;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.nashorn.NashornJSElementTypes;
import com.intellij.lang.javascript.nashorn.parsing.NashornJSParser;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;

public class NashornJSExpressionParser
extends ES6ExpressionParser<NashornJSParser> {
    protected NashornJSExpressionParser(NashornJSParser parser) {
        super(parser);
    }

    @Override
    public void parseArgumentList() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.LPAR);
        PsiBuilder.Marker arglist = this.builder.mark();
        this.parseArgumentListNoMarker();
        if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
            this.parseObjectLiteralExpression(false);
        }
        arglist.done(NashornJSElementTypes.ARGUMENT_LIST);
    }

    @Override
    protected boolean parseDialectSpecificMemberExpressionPart(Ref<PsiBuilder.Marker> markerRef) {
        if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
            PsiBuilder.Marker arglist = this.builder.mark();
            this.parseObjectLiteralExpression(false);
            arglist.done(NashornJSElementTypes.ARGUMENT_LIST);
        }
        return false;
    }

    @Override
    public boolean parsePrimaryExpression() {
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken == JSTokenTypes.HEREDOC_BOUND) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.HEREDOC_BODY) {
                this.builder.advanceLexer();
            }
            NashornJSExpressionParser.checkMatches(this.builder, JSTokenTypes.HEREDOC_BOUND, "javascript.parser.message.expected.heredoc.closing.identifier");
            marker.done(NashornJSElementTypes.HEREDOC);
            return true;
        }
        return super.parsePrimaryExpression();
    }

    @Override
    public boolean isPropertyNameStart(IElementType elementType) {
        return super.isPropertyNameStart(elementType) || elementType == JSTokenTypes.BACKQUOTE;
    }

    @Override
    protected boolean parsePropertyNoMarker(PsiBuilder.Marker property) {
        if (this.builder.getTokenType() == JSTokenTypes.BACKQUOTE) {
            this.parseStringTemplate();
            this.parsePropertyInitializer(false);
            property.done(JSStubElementTypes.PROPERTY);
            property.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
            return true;
        }
        return super.parsePropertyNoMarker(property);
    }
}

