/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.ecmascript6.actions.ES6AddImportExecutor;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.ImportCommonJSModuleFix;
import com.intellij.lang.javascript.modules.JSModuleFixDescriptor;
import com.intellij.lang.javascript.modules.JSPlaceTail;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportES6ModuleFix
extends ImportCommonJSModuleFix {
    private final NotNullLazyValue<String> myInsertedText;

    public ImportES6ModuleFix(@NotNull PsiElement node, @NotNull JSModuleFixDescriptor descriptor2, @Nullable JSPlaceTail tail, String quoteString, boolean needHint) {
        if (node == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(1);
        }
        super(node, descriptor2, tail, quoteString, needHint);
        this.myInsertedText = new NotNullLazyValue<String>(){

            @NotNull
            protected String compute() {
                ImportData data = ImportES6ModuleFix.this.getImportData();
                String importedElementText = data.getRawText();
                String string = data.getDeclarationPrefixWithKeyword() + " " + importedElementText + " from " + ImportES6ModuleFix.this.myQuotes + ImportES6ModuleFix.this.getPath() + ImportES6ModuleFix.this.myQuotes;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix$1", "compute"));
            }
        };
    }

    @Override
    protected void executeImpl(@NotNull PsiElement element, @Nullable Editor editor, @NotNull PsiElement scope) {
        if (element == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(3);
        }
        ImportData importData = this.getImportData();
        new ES6AddImportExecutor(editor, element).createImportOrUseExisting(importData, null, this.myQuotes + this.getPath() + this.myQuotes);
        this.replaceReferences(element, editor);
    }

    @NotNull
    private PsiElement correctReplaceTarget(@NotNull PsiElement reference) {
        if (reference == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(4);
        }
        if (reference instanceof JSReferenceExpression) {
            PsiElement target;
            JSReferenceExpression replaceTarget = (JSReferenceExpression)reference;
            PsiElement psiElement = target = this.myTail == null ? null : this.myTail.getTailToReplaceReference();
            if (target == null) {
                while (replaceTarget.getQualifier() instanceof JSReferenceExpression) {
                    replaceTarget = (JSReferenceExpression)replaceTarget.getQualifier();
                }
            }
            JSReferenceExpression jSReferenceExpression = replaceTarget;
            if (jSReferenceExpression == null) {
                ImportES6ModuleFix.$$$reportNull$$$0(5);
            }
            return jSReferenceExpression;
        }
        PsiElement psiElement = reference;
        if (psiElement == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    @Override
    protected void replaceReferences(PsiElement element, Editor editor) {
        String name;
        PsiElement replaceTarget = this.correctReplaceTarget(element);
        if (replaceTarget instanceof JSReferenceExpression && (name = ((JSReferenceExpression)replaceTarget).getReferenceName()) != null) {
            this.replaceWithNewReference(replaceTarget, editor, name);
        }
    }

    @Override
    protected PsiElement createRequire(@NotNull PsiElement context) {
        if (context == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(7);
        }
        String newText = this.getInsertedText() + JSCodeStyleSettings.getSemicolon(context);
        return JSPsiElementFactory.createJSSourceElement(newText, context);
    }

    private String getInsertedText() {
        return (String)this.myInsertedText.getValue();
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"js.inspection.es6.modules.dependencies.family.name", (Object[])new Object[0]);
        if (string == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private ImportData getImportData() {
        String importedName = this.myFixDescriptor.getImportedName();
        ES6ImportPsiUtil.ImportExportType type = this.myFixDescriptor.getImportType();
        String exportedName = this.myFixDescriptor.getExportedName();
        if (exportedName != null) {
            ES6ImportPsiUtil.ImportExportType typeToUse;
            ES6ImportPsiUtil.ImportExportType importExportType = typeToUse = type != null ? type : ES6ImportPsiUtil.ImportExportType.SPECIFIER;
            if (exportedName.equals(importedName)) {
                return new ImportData(importedName, typeToUse);
            }
            return new ImportData(exportedName, importedName, typeToUse);
        }
        if (type != null) {
            return new ImportData(importedName, type);
        }
        if (this.myTail != null) {
            String tail = this.myTail.getStrings()[0];
            return new ImportData(tail == null ? importedName : tail, ES6ImportPsiUtil.ImportExportType.SPECIFIER);
        }
        return new ImportData(importedName, ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL);
    }

    private boolean isFlowTypeContext() {
        if (!this.myFixDescriptor.isFlowType()) {
            return false;
        }
        PsiElement element = this.getStartElement();
        if (element == null) {
            return false;
        }
        return DialectDetector.isFlow(element);
    }

    @Override
    protected void insertCreatedElement(@NotNull PsiElement scope, @Nullable Editor editor, @NotNull PsiElement created) {
        if (scope == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(9);
        }
        if (created == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(10);
        }
        ES6CreateImportUtil.findPlaceAndInsertES6Import(scope, created, this.getPath(), editor);
    }

    @Nls
    @NotNull
    public String getText() {
        String wholeImportWrapQuote = ES6ImportPsiUtil.invertQuote(this.myQuotes);
        String string = IdeBundle.message((String)"quickfix.text.insert.0", (Object[])new Object[]{wholeImportWrapQuote + this.getInsertedText() + wholeImportWrapQuote});
        if (string == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/ImportES6ModuleFix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "created";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/ImportES6ModuleFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "correctReplaceTarget";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeImpl";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "correctReplaceTarget";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRequire";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "insertCreatedElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ImportData
    extends ES6ImportPsiUtil.CreateImportExportInfo {
        @Override
        public boolean shouldCreateImportTypeOnly() {
            return this.isTypeContext();
        }

        ImportData(@Nullable String exportedName, @NotNull String importedName, ES6ImportPsiUtil.ImportExportType importType) {
            if (importType == null) {
                ImportData.$$$reportNull$$$0(0);
            }
            super(exportedName, importedName, importType, true, ImportES6ModuleFix.this.isFlowTypeContext());
        }

        ImportData(@NotNull String importedName, ES6ImportPsiUtil.ImportExportType importType) {
            if (importedName == null) {
                ImportData.$$$reportNull$$$0(1);
            }
            if (importType == null) {
                ImportData.$$$reportNull$$$0(2);
            }
            super(null, importedName, importType, true, ImportES6ModuleFix.this.isFlowTypeContext());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "importType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "importedName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/modules/ImportES6ModuleFix$ImportData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

