/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSStringTemplateConvertVisibilityOfLineSeparatorsIntention
extends JavaScriptIntention
implements ES6CoolRefactoring {
    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.$$$reportNull$$$0(1);
        }
        if (!super.isAvailable(project, editor, element) || !DialectDetector.hasFeature(element, JSLanguageFeature.STRING_TEMPLATES)) {
            return false;
        }
        JSStringTemplateExpression stringTemplateExpression = JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.getStringTemplate(element);
        if (stringTemplateExpression == null) {
            return false;
        }
        boolean hasStringParts = false;
        boolean hasNewlines = false;
        boolean hasEscapedNewLines = false;
        for (ASTNode child : stringTemplateExpression.getNode().getChildren(TokenSet.ANY)) {
            if (child.getElementType() != JSTokenTypes.STRING_TEMPLATE_PART) continue;
            hasStringParts = true;
            String text = child.getText();
            if ((hasNewlines |= JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.hasNewline(text)) && (hasEscapedNewLines |= JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.hasEscapedNewline(text))) break;
        }
        return hasStringParts && this.isAcceptable(hasNewlines, hasEscapedNewLines);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        JSStringTemplateExpression stringTemplateExpression;
        if (project == null) {
            JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.$$$reportNull$$$0(3);
        }
        if ((stringTemplateExpression = JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.getStringTemplate(element)) != null) {
            String replacementText = this.replaceAllTemplateParts(stringTemplateExpression);
            JSExpression replacementPsi = JSPsiElementFactory.createJSExpression(replacementText, (PsiElement)stringTemplateExpression);
            stringTemplateExpression.replace(replacementPsi);
        }
    }

    protected abstract boolean isAcceptable(boolean var1, boolean var2);

    @NotNull
    protected abstract String replaceStringPart(@NotNull String var1);

    private String replaceAllTemplateParts(@NotNull JSStringTemplateExpression template) {
        if (template == null) {
            JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.$$$reportNull$$$0(4);
        }
        StringBuilder result2 = new StringBuilder();
        for (ASTNode child : template.getNode().getChildren(TokenSet.ANY)) {
            if (child.getElementType() == JSTokenTypes.STRING_TEMPLATE_PART) {
                result2.append(this.replaceStringPart(child.getText()));
                continue;
            }
            result2.append(child.getText());
        }
        return result2.toString();
    }

    private static boolean hasNewline(@Nullable String string) {
        return string != null && StringUtil.containsChar((String)string, (char)'\n');
    }

    private static boolean hasEscapedNewline(@Nullable String string) {
        return string != null && string.contains("\\n");
    }

    @Nullable
    private static JSStringTemplateExpression getStringTemplate(@NotNull PsiElement element) {
        if (element == null) {
            JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.$$$reportNull$$$0(5);
        }
        return element instanceof JSStringTemplateExpression ? (JSStringTemplateExpression)element : (JSStringTemplateExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSStringTemplateExpression.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/intentions/JSStringTemplateConvertVisibilityOfLineSeparatorsIntention";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceAllTemplateParts";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getStringTemplate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

