/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSConditionOwner;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInferParametersIntention
extends JavaScriptIntention
implements LowPriorityAction {
    private String myText = JavaScriptBundle.message((String)"js.infer.parameter.types.intention", (Object[])new Object[0]);

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSInferParametersIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSInferParametersIntention.$$$reportNull$$$0(1);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)element.getContainingFile())) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaScriptBundle.message((String)"js.infer.parameter.types.intention.failure.readonly.text", (Object[])new Object[0]), (String)JavaScriptBundle.message((String)"js.infer.parameter.types.intention.failure.title", (Object[])new Object[0]), null);
            return;
        }
        Pair<JSFunction, JSCallLikeExpression> pair = JSInferParametersIntention.findSignature(element);
        assert (pair != null);
        JSFunction signature = (JSFunction)pair.first;
        JSParameterListElement[] parametersList = signature.getParameters();
        JSType[] inferredTypes = new JSType[parametersList.length];
        boolean[] proposeGenerics = new boolean[parametersList.length];
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> JSInferParametersIntention.doInferTypes(signature, parametersList, inferredTypes, proposeGenerics)), JavaScriptBundle.message((String)"js.infer.parameter.types.intention.progress.text", (Object[])new Object[0]), true, project)) {
            return;
        }
        boolean hasAny = false;
        for (JSType type : inferredTypes) {
            if (type == null || type instanceof JSAnyType) continue;
            hasAny = true;
            break;
        }
        if (!hasAny) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaScriptBundle.message((String)"js.infer.parameter.types.intention.failure.text", (Object[])new Object[0]), (String)JavaScriptBundle.message((String)"js.infer.parameter.types.intention.failure.title", (Object[])new Object[0]), null);
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> JSInferParametersIntention.setInferredTypes(signature, inferredTypes, proposeGenerics, parametersList));
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static void setInferredTypes(JSFunction signature, JSType[] inferredTypes, boolean[] proposeGenerics, JSParameterListElement[] parameters) {
        JSParameterList newList;
        PsiElement nameIdentifier = signature.getNameIdentifier();
        boolean avoidGenerics = nameIdentifier == null || !PsiTreeUtil.isAncestor((PsiElement)signature, (PsiElement)nameIdentifier, (boolean)true) || !DialectDetector.hasFeature((PsiElement)signature, JSLanguageFeature.GENERICS) || signature instanceof TypeScriptTypeParameterListOwner && ((TypeScriptTypeParameterListOwner)signature).getTypeParameters().length != 0;
        SmartList genericNames = new SmartList();
        boolean hasTypes = DialectDetector.hasFeature((PsiElement)signature, JSLanguageFeature.TYPES);
        JSParameterList oldList = signature.getParameterList();
        JSParameterList jSParameterList = newList = oldList == null ? null : JSChangeSignatureUtil.addParenthesesIfNeeded(oldList);
        if (newList != oldList) {
            parameters = newList.getParameters();
        }
        for (int i = 0; i < inferredTypes.length; ++i) {
            PsiElement colon;
            JSType type = inferredTypes[i];
            if (type == null) continue;
            JSParameter parameter = (JSParameter)parameters[i];
            PsiElement typeAnchor = parameter.getNameIdentifier();
            PsiElement nextOne = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)typeAnchor);
            if (PsiUtilCore.getElementType((PsiElement)nextOne) == JSTokenTypes.QUEST) {
                typeAnchor = nextOne;
            }
            if (!avoidGenerics && proposeGenerics[i]) {
                String name = JSNameSuggestionsUtil.ensureUniqueVariableName("T" + i, (PsiElement)signature, (Collection<String>)genericNames, false);
                colon = parameter.addAfter(JSChangeUtil.createTokenElement((PsiElement)signature, JSTokenTypes.COLON, ":"), typeAnchor);
                parameter.addAfter(Objects.requireNonNull(JSChangeUtil.tryCreateTypeElement(name, (PsiElement)signature)), colon);
                genericNames.add(name);
                continue;
            }
            String text = type.getTypeText(JSType.TypeTextFormat.CODE);
            if (hasTypes) {
                colon = parameter.addAfter(JSChangeUtil.createTokenElement((PsiElement)signature, JSTokenTypes.COLON, ":"), typeAnchor);
                parameter.addAfter(Objects.requireNonNull(JSChangeUtil.tryCreateTypeElement(text, (PsiElement)signature)), colon);
                continue;
            }
            JSDocumentationUtils.createOrUpdateTagsInDocComment((PsiElement)signature, Collections.singletonList("param {" + text + "} " + parameter.getName()), Collections.emptyMap(), Collections.emptySet());
        }
        if (!genericNames.isEmpty()) {
            JSClass aClass = JSPsiElementFactory.createJSClass("class X<" + StringUtil.join((Collection)genericNames, (String)", ") + ">", (PsiElement)signature);
            signature.addAfter((PsiElement)Objects.requireNonNull(((TypeScriptTypeParameterListOwner)aClass).getTypeParameterList()), nameIdentifier);
        }
    }

    private static void doInferTypes(@NotNull JSFunction signature, JSParameterListElement @NotNull [] parameters, JSType @NotNull [] inferredTypes, boolean @NotNull [] proposeGenerics) {
        if (signature == null) {
            JSInferParametersIntention.$$$reportNull$$$0(2);
        }
        if (parameters == null) {
            JSInferParametersIntention.$$$reportNull$$$0(3);
        }
        if (inferredTypes == null) {
            JSInferParametersIntention.$$$reportNull$$$0(4);
        }
        if (proposeGenerics == null) {
            JSInferParametersIntention.$$$reportNull$$$0(5);
        }
        List[] types2 = new List[parameters.length + 1];
        for (PsiElement elementToSearchRefs : JSInferParametersIntention.getElementsToSearchRefs(signature)) {
            for (PsiReference search : ReferencesSearch.search((PsiElement)elementToSearchRefs, (SearchScope)elementToSearchRefs.getUseScope())) {
                PsiElement parent;
                if (!(search instanceof JSExpression)) continue;
                if (search instanceof JSReferenceExpression && (parent = ((JSReferenceExpression)search).getParent()) instanceof JSCallLikeExpression) {
                    JSInferParametersIntention.doInferFromCallLike(types2, (JSCallLikeExpression)parent);
                }
                JSType type = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)search.getElement());
                JSTypeUtils.getFunctionType(type, false, (PsiElement)signature).forEach(t -> {
                    if (t instanceof JSFunctionType) {
                        List decorators = ((JSFunctionType)t).getParameters();
                        for (int i = 0; i < decorators.size() && i < types2.length; ++i) {
                            JSParameterTypeDecorator parameter = (JSParameterTypeDecorator)decorators.get(i);
                            JSType inferredType = parameter.getInferredType();
                            if (inferredType == null) continue;
                            JSInferParametersIntention.addTypeAtIndex(types2, i, inferredType);
                        }
                    }
                });
            }
        }
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)signature);
        boolean hasNonConditionalUsages = false;
        for (int i = 0; i < parameters.length; ++i) {
            JSParameterListElement parameter = parameters[i];
            for (PsiReference search : ReferencesSearch.search((PsiElement)parameter, (SearchScope)parameter.getUseScope())) {
                if (!(search instanceof JSExpression)) continue;
                PsiElement parent = ((JSExpression)search).getParent();
                if (JSInferParametersIntention.isInCondition((PsiElement)search, parent)) {
                    if (parameter.isOptional() || !isTypeScript) continue;
                    JSInferParametersIntention.addTypeAtIndex(types2, i, new JSVoidType(JSTypeSourceFactory.createTypeSource(parent, true)));
                    continue;
                }
                hasNonConditionalUsages = true;
                JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)search);
                if (expectedType == null) continue;
                JSInferParametersIntention.addTypeAtIndex(types2, i, expectedType);
            }
        }
        JSInferParametersIntention.mergeInferredTypes(signature, parameters, inferredTypes, proposeGenerics, types2, hasNonConditionalUsages);
    }

    private static boolean isInCondition(@NotNull PsiElement search, @Nullable PsiElement parent) {
        if (search == null) {
            JSInferParametersIntention.$$$reportNull$$$0(6);
        }
        while (parent instanceof JSPrefixExpression || parent instanceof JSParenthesizedExpression || parent instanceof JSBinaryExpression) {
            IElementType sign;
            if (parent instanceof JSBinaryExpression && (sign = ((JSBinaryExpression)parent).getOperationSign()) != JSTokenTypes.ANDAND && sign != JSTokenTypes.OROR) {
                return false;
            }
            if (parent instanceof JSPrefixExpression && ((JSPrefixExpression)parent).getOperationSign() != JSTokenTypes.EXCL) {
                return false;
            }
            search = parent;
            parent = parent.getParent();
        }
        return parent instanceof JSConditionOwner && ((JSConditionOwner)parent).getCondition() == search;
    }

    private static void mergeInferredTypes(@NotNull JSFunction signature, JSParameterListElement @NotNull [] parameters, JSType @NotNull [] inferredTypes, boolean @NotNull [] proposeGenerics, List<JSType> @NotNull [] types2, boolean hasNonConditionalUsages) {
        if (signature == null) {
            JSInferParametersIntention.$$$reportNull$$$0(7);
        }
        if (parameters == null) {
            JSInferParametersIntention.$$$reportNull$$$0(8);
        }
        if (inferredTypes == null) {
            JSInferParametersIntention.$$$reportNull$$$0(9);
        }
        if (proposeGenerics == null) {
            JSInferParametersIntention.$$$reportNull$$$0(10);
        }
        if (types2 == null) {
            JSInferParametersIntention.$$$reportNull$$$0(11);
        }
        for (int i = 0; i < parameters.length; ++i) {
            JSType commonType;
            List<JSType> inferredTypesForParam;
            JSParameterListElement parameter = parameters[i];
            if (JSInferParametersIntention.hasTypeElement(parameter) || (inferredTypesForParam = types2[i]) == null || inferredTypesForParam.isEmpty()) continue;
            if (parameter.isRest() && types2[parameters.length] != null) {
                inferredTypesForParam.addAll(types2[parameters.length]);
            }
            ArrayList<JSType> reduced = new ArrayList<JSType>(inferredTypesForParam.size());
            for (JSType type : inferredTypesForParam) {
                reduced.add(type.transformTypeHierarchy(t -> JSTypeUtils.widenLiteralTypes(t)));
            }
            boolean isSingle = reduced.size() == 1 || hasNonConditionalUsages;
            reduced = ContainerUtil.map(reduced, t -> t instanceof JSVoidType ? (isSingle ? new JSBooleanType(true, t.getSource(), JSTypeContext.INSTANCE) : new JSUndefinedType(t.getSource())) : t);
            TypeScriptTypeRelations.reduceBySubtyping((PsiElement)signature, inferredTypesForParam, reduced);
            JSType jSType = commonType = reduced.size() == 1 ? (JSType)reduced.get(0) : JSTypeUtils.getCommonType(ContainerUtil.map(reduced, t -> () -> t), (PsiElement)signature, true);
            if (commonType == null) continue;
            commonType = TypeScriptTypeRelations.subtypeReduction(commonType, (PsiElement)signature);
            if (parameter.isRest()) {
                commonType = new JSArrayTypeImpl(commonType, commonType.getSource());
            } else if (parameter.isOptional() && commonType instanceof JSUnionType && ((JSUnionType)commonType).getTypes().stream().anyMatch(t -> t instanceof JSUndefinedType)) {
                commonType = JSCompositeTypeFactory.createUnionType(commonType.getSource(), ContainerUtil.filter(((JSUnionType)commonType).getTypes(), t -> !(t instanceof JSUndefinedType)));
            }
            inferredTypes[i] = commonType;
            if (!(commonType instanceof JSUnionType) || ((JSUnionType)commonType).getTypes().size() <= 2 || reduced.size() <= 2) continue;
            proposeGenerics[i] = true;
        }
    }

    private static boolean hasTypeElement(JSParameterListElement parameter) {
        if (parameter.getTypeElement() != null) {
            return true;
        }
        if (DialectDetector.isTypeScript((PsiElement)parameter)) {
            return false;
        }
        return parameter.getTypeDecorator().getSimpleType() != null;
    }

    private static void doInferFromCallLike(List<JSType> @NotNull [] types2, @NotNull JSCallLikeExpression parent) {
        if (parent == null) {
            JSInferParametersIntention.$$$reportNull$$$0(12);
        }
        if (types2 == null) {
            JSInferParametersIntention.$$$reportNull$$$0(13);
        }
        if (parent instanceof ES6TaggedTemplateExpression) {
            JSType type = JSNamedTypeFactory.createType("TemplateStringsArray", JSTypeSourceFactory.createTypeSource((PsiElement)parent, true), JSTypeContext.INSTANCE);
            JSInferParametersIntention.addTypeAtIndex(types2, 0, type);
        }
        int firstArgumentIndex = parent.getFirstArgumentIndex();
        JSExpression[] arguments = parent.getArguments();
        for (int i = 0; i < arguments.length; ++i) {
            JSType type = JSResolveUtil.getExpressionJSType(arguments[i]);
            if (type == null) continue;
            JSInferParametersIntention.addTypeAtIndex(types2, i + firstArgumentIndex < types2.length ? i + firstArgumentIndex : types2.length - 1, type);
        }
    }

    private static void addTypeAtIndex(List<JSType>[] types2, int index, JSType type) {
        if (types2[index] == null) {
            types2[index] = new SmartList();
        }
        types2[index].add(type);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"js.infer.parameter.types.intention", (Object[])new Object[0]);
        if (string == null) {
            JSInferParametersIntention.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            JSInferParametersIntention.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSInferParametersIntention.$$$reportNull$$$0(16);
        }
        if (element == null) {
            JSInferParametersIntention.$$$reportNull$$$0(17);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        this.myText = DialectDetector.hasFeature(element, JSLanguageFeature.TYPES) ? JavaScriptBundle.message((String)"js.infer.parameter.types.intention", (Object[])new Object[0]) : JavaScriptBundle.message((String)"js.infer.parameter.types.intention.jsdoc", (Object[])new Object[0]);
        Pair<JSFunction, JSCallLikeExpression> signature = JSInferParametersIntention.findSignature(element);
        if (signature == null) {
            return false;
        }
        if (Arrays.stream(((JSFunction)signature.first).getParameters()).allMatch(p -> JSInferParametersIntention.hasTypeElement(p))) {
            return false;
        }
        for (JSParameterListElement parameter : ((JSFunction)signature.first).getParameters()) {
            SearchScope scope = parameter.getUseScope();
            if (scope instanceof LocalSearchScope) continue;
            return false;
        }
        return true;
    }

    private static List<PsiElement> getElementsToSearchRefs(JSFunction function2) {
        PsiElement parent;
        SmartList items = new SmartList((Object)function2);
        if (function2 instanceof JSExpression && (parent = function2.getParent()) instanceof JSInitializerOwner && ((JSInitializerOwner)parent).getInitializerOrStub() == function2) {
            items.add(parent);
        }
        return items;
    }

    @Nullable
    private static Pair<JSFunction, JSCallLikeExpression> findSignature(@NotNull PsiElement element) {
        JSElement parent;
        if (element == null) {
            JSInferParametersIntention.$$$reportNull$$$0(18);
        }
        if ((parent = JSInferParametersIntention.findParent(element)) instanceof JSParameter) {
            parent = JSInferParametersIntention.findParent((PsiElement)parent);
        }
        if (parent instanceof JSFunction) {
            if (PsiTreeUtil.isAncestor((PsiElement)((JSFunction)parent).getBlock(), (PsiElement)element, (boolean)true)) {
                return null;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)parent), (PsiElement)element, (boolean)true)) {
                return null;
            }
        }
        if (parent instanceof JSParameterList) {
            return JSInferParametersIntention.getForParameterList((JSParameterList)parent);
        }
        if (parent instanceof JSCallLikeExpression && DialectDetector.hasFeature((PsiElement)parent, JSLanguageFeature.TYPES)) {
            JSExpression methodExpression = ((JSCallLikeExpression)parent).getMethodExpression();
            if (methodExpression instanceof JSReferenceExpression) {
                JSFunction constructor;
                PsiElement resolve = ((JSReferenceExpression)methodExpression).resolve();
                if (resolve instanceof JSFunction) {
                    return Pair.create((Object)((JSFunction)resolve), (Object)((JSCallLikeExpression)parent));
                }
                if (resolve instanceof JSInitializerOwner) {
                    JSExpression initializer = ((JSInitializerOwner)resolve).getInitializerOrStub();
                    if (initializer instanceof JSFunction) {
                        return Pair.create((Object)((JSFunction)initializer), (Object)((JSCallLikeExpression)parent));
                    }
                } else if (parent instanceof JSNewExpression && resolve instanceof JSClass && (constructor = ((JSClass)resolve).getConstructor()) != null) {
                    return Pair.create((Object)constructor, (Object)((JSCallLikeExpression)parent));
                }
            }
        } else {
            JSExpression initializer;
            if (parent instanceof JSFunction) {
                return JSInferParametersIntention.getForParameterList(((JSFunction)parent).getParameterList());
            }
            if (parent instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)parent).getInitializerOrStub()) instanceof JSFunction) {
                return JSInferParametersIntention.getForParameterList(((JSFunction)initializer).getParameterList());
            }
        }
        return null;
    }

    @Nullable
    private static JSElement findParent(@NotNull PsiElement element) {
        if (element == null) {
            JSInferParametersIntention.$$$reportNull$$$0(19);
        }
        return (JSElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSParameterList.class, JSCallLikeExpression.class, JSFunction.class, JSInitializerOwner.class});
    }

    @Nullable
    private static Pair<JSFunction, JSCallLikeExpression> getForParameterList(@Nullable JSParameterList parent) {
        if (parent == null) {
            return null;
        }
        boolean hasTypes = DialectDetector.hasFeature((PsiElement)parent, JSLanguageFeature.TYPES);
        for (JSParameterListElement parameter : parent.getParameters()) {
            JSFunction function2;
            if (!(parameter instanceof JSParameter) || JSInferParametersIntention.hasTypeElement(parameter) || !hasTypes && JSDocumentationUtils.getParameterTypeFromPrecedingComment((JSParameter)parameter) != null || (function2 = (JSFunction)ObjectUtils.tryCast((Object)parent.getParent(), JSFunction.class)) == null) continue;
            return Pair.create((Object)function2, null);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferredTypes";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proposeGenerics";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "search";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSInferParametersIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSInferParametersIntention";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doInferTypes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInCondition";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "mergeInferredTypes";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doInferFromCallLike";
                break;
            }
            case 14: 
            case 15: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findSignature";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

