/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.intentions.ES6ConvertVarToLetConstInspectionBase;
import com.intellij.lang.javascript.intentions.ES6ConvertVarToLetConstQuickFix;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

public class ES6ConvertVarToLetConstInspection
extends ES6ConvertVarToLetConstInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        return new JSElementVisitor(){

            public void visitJSVarStatement(JSVarStatement node) {
                boolean isBatch;
                if (!ES6CoolRefactoring.isEs6Compatible((PsiElement)node)) {
                    return;
                }
                ASTNode varNode = node.getNode().findChildByType(JSTokenTypes.VAR_KEYWORD);
                if (varNode == null || !ES6ConvertVarToLetConstInspectionBase.isAvailableForStatement(node)) {
                    return;
                }
                boolean bl = isBatch = !holder.isOnTheFly() || ES6ConvertVarToLetConstInspection.this.myEmulateBatch && ApplicationManager.getApplication().isUnitTestMode();
                if (isBatch) {
                    ES6ConvertVarToLetConstQuickFix fix = new ES6ConvertVarToLetConstQuickFix(node).setInBatch(true).setConservative(ES6ConvertVarToLetConstInspection.this.myConservativeOption);
                    holder.registerProblem(varNode.getPsi(), JavaScriptBundle.message((String)"js.convert.var.to.let.or.const.inspection.text", (Object[])new Object[0]), new LocalQuickFix[]{fix});
                } else {
                    boolean asIntention = ES6ConvertVarToLetConstInspection.this.checkHighlightLevel(node);
                    LocalQuickFix[] fixes = !ES6ConvertVarToLetConstQuickFix.canBeConst(node, true, false) ? new LocalQuickFix[]{new ES6ConvertVarToLetConstQuickFix(node).forceVariant(false).setForceFix(asIntention)} : new LocalQuickFix[]{new ES6ConvertVarToLetConstQuickFix(node).forceVariant(true).setForceFix(asIntention), new ES6ConvertVarToLetConstQuickFix(node).forceVariant(false).setForceFix(asIntention)};
                    holder.registerProblem(varNode.getPsi(), JavaScriptBundle.message((String)"js.convert.var.to.let.or.const.inspection.text", (Object[])new Object[0]), fixes);
                }
            }
        };
    }
}

