/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactoryBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExitPoint;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class JSHighlightFunctionExitPointsHandlerFactory
extends HighlightUsagesHandlerFactoryBase {
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull PsiElement target) {
        ASTNode node;
        if (editor == null) {
            JSHighlightFunctionExitPointsHandlerFactory.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            JSHighlightFunctionExitPointsHandlerFactory.$$$reportNull$$$0(1);
        }
        if (target == null) {
            JSHighlightFunctionExitPointsHandlerFactory.$$$reportNull$$$0(2);
        }
        if ((node = target.getNode()) != null) {
            IElementType elementType = node.getElementType();
            if (elementType == JSTokenTypes.RETURN_KEYWORD || elementType == JSTokenTypes.THROW_KEYWORD || elementType == JSTokenTypes.YIELD_KEYWORD || elementType == JSTokenTypes.FUNCTION_KEYWORD || elementType == JSTokenTypes.EQGT) {
                return new JSHighlightExitPointsHandler(editor, file2, target);
            }
            if (elementType == JSTokenTypes.ASYNC_KEYWORD || elementType == JSTokenTypes.AWAIT_KEYWORD) {
                return new JSHighlightAsyncAwaitHandler(editor, file2, target);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/highlighting/JSHighlightFunctionExitPointsHandlerFactory";
        objectArray[2] = "createHighlightUsagesHandler";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class JSHighlightAsyncAwaitHandler
    extends JSHighlightHandlerBase {
        private JSHighlightAsyncAwaitHandler(Editor editor, PsiFile file2, PsiElement target) {
            super(editor, file2, target);
        }

        public void computeUsages(List<PsiElement> targets) {
            JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)targets.get(0), JSFunction.class);
            if (fun != null) {
                ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)fun).forceIgnore(e -> e instanceof JSFunction)).filter(JSPrefixExpression.class).filter(e -> e.getOperationSign() == JSTokenTypes.AWAIT_KEYWORD).map(ep -> Objects.requireNonNull(ep.getOperationNode()).getTextRange()).addAllTo((Collection)this.myReadUsages);
            }
        }
    }

    private static class JSHighlightExitPointsHandler
    extends JSHighlightHandlerBase {
        private JSHighlightExitPointsHandler(Editor editor, PsiFile file2, PsiElement target) {
            super(editor, file2, target);
        }

        public void computeUsages(List<PsiElement> targets) {
            JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)targets.get(0), JSFunction.class);
            JSExpression arrowFunctionReturnExpression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(fun);
            if (arrowFunctionReturnExpression != null) {
                this.myReadUsages.add(arrowFunctionReturnExpression.getTextRange());
                return;
            }
            if (fun != null) {
                ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)fun).forceIgnore(e -> e instanceof JSFunction)).filter(JSFunctionExitPoint.class).filter(ep -> ep.isValidFunctionExit()).map(ep -> ep.getTextRange()).addAllTo((Collection)this.myReadUsages);
            }
        }
    }

    private static abstract class JSHighlightHandlerBase
    extends HighlightUsagesHandlerBase<PsiElement> {
        protected final PsiElement myTarget;

        private JSHighlightHandlerBase(Editor editor, PsiFile file2, PsiElement target) {
            super(editor, file2);
            this.myTarget = target;
        }

        public List<PsiElement> getTargets() {
            return new SmartList((Object)this.myTarget);
        }

        @NotNull
        public String getFeatureId() {
            return "codeassists.highlight.return";
        }

        protected void selectTargets(List<PsiElement> targets, Consumer<List<PsiElement>> selectionConsumer) {
            selectionConsumer.consume(targets);
        }
    }
}

