/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.javascript.frameworks.react.ReactAttributeDescriptor;
import com.intellij.lang.javascript.frameworks.react.ReactAttributeDescriptorImpl;
import com.intellij.lang.javascript.frameworks.react.ReactComponent;
import com.intellij.lang.javascript.frameworks.react.ReactXmlElementNSDescriptor;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.frameworks.react.references.JSXResolveUtil;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactTagUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactXmlElementDescriptor
implements XmlElementDescriptor {
    private static final Collection<String> IGNORED_ATTRIBUTES = ContainerUtil.immutableSet((Object[])new String[]{"class", "for"});
    @NotNull
    private final String myName;
    @NotNull
    private final PsiElement myContext;
    private final boolean myStrict;
    @Nullable
    private final ReactXmlElementNSDescriptor myDescriptor;

    public ReactXmlElementDescriptor(@NotNull String name, @NotNull PsiElement context, boolean isStrict) {
        if (name == null) {
            ReactXmlElementDescriptor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ReactXmlElementDescriptor.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myContext = context;
        this.myStrict = isStrict;
        this.myDescriptor = new ReactXmlElementNSDescriptor(this.myContext, name.contains("."), isStrict);
    }

    public String getQualifiedName() {
        return this.myName;
    }

    public String getDefaultName() {
        return this.myName;
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        XmlNSDescriptor descriptor2 = this.getNSDescriptor();
        if (descriptor2 == null) {
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        return descriptor2.getRootElementsDescriptors(null);
    }

    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        XmlNSDescriptor descriptor2 = this.getNSDescriptor();
        return descriptor2 == null ? null : descriptor2.getElementDescriptor(childTag);
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        if (context == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        if (JSXResolveUtil.isComponentName(context.getName())) {
            return ReactXmlElementDescriptor.getComponentProps(context);
        }
        return this.resolveTagAttributes(context);
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        if (context == null || DumbService.isDumb((Project)this.myContext.getProject())) {
            return new ReactAnyXmlAttributeDescriptor(attributeName);
        }
        if (JSXResolveUtil.isComponentName(context.getName())) {
            return ReactXmlElementDescriptor.findComponentProp(attributeName, context);
        }
        return this.resolveTagAttribute(context, attributeName);
    }

    @NotNull
    private static XmlAttributeDescriptor findComponentProp(@NonNls String attributeName, @NotNull XmlTag context) {
        ReactComponent reactComponent;
        JSRecordType props;
        if (context == null) {
            ReactXmlElementDescriptor.$$$reportNull$$$0(2);
        }
        JSRecordType.PropertySignature signature = (props = (reactComponent = ReactXmlElementDescriptor.getComponent(context)).getProps()) == null ? null : props.findPropertySignature(attributeName);
        return signature != null ? ReactAttributeDescriptorImpl.create(attributeName, signature.getMemberSource().getSingleElement(), signature.getJSType(), reactComponent.isWeakResolve()) : new ReactAnyXmlAttributeDescriptor(attributeName);
    }

    private static XmlAttributeDescriptor[] getComponentProps(@NotNull XmlTag context) {
        if (context == null) {
            ReactXmlElementDescriptor.$$$reportNull$$$0(3);
        }
        ReactComponent reactComponent = ReactXmlElementDescriptor.getComponent(context);
        return TypeScriptReactTagUtil.getXmlAttributeDescriptors((JSType)reactComponent.getProps());
    }

    @NotNull
    public static ReactComponent getComponent(@NotNull XmlTag context) {
        if (context == null) {
            ReactXmlElementDescriptor.$$$reportNull$$$0(4);
        }
        ReactComponent reactComponent = (ReactComponent)CachedValuesManager.getCachedValue((PsiElement)context, () -> CachedValueProvider.Result.create((Object)ReactXmlElementDescriptor.getComponentNoCache(context), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()}));
        if (reactComponent == null) {
            ReactXmlElementDescriptor.$$$reportNull$$$0(5);
        }
        return reactComponent;
    }

    @NotNull
    private static ReactComponent getComponentNoCache(@NotNull XmlTag context) {
        String name;
        if (context == null) {
            ReactXmlElementDescriptor.$$$reportNull$$$0(6);
        }
        PsiReference reference = context.getReference();
        SmartList components = new SmartList();
        boolean isWeakResolve = false;
        boolean isResolvedComponent = true;
        JSElement firstComponent = null;
        if (reference != null) {
            PsiElement resolve = reference.resolve();
            Collection<PsiElement> elements = ReactXmlExtension.getElementsByImport(resolve, false);
            for (PsiElement item : elements) {
                if (item instanceof JSCallExpression) {
                    isWeakResolve = true;
                    item = (PsiElement)ContainerUtil.getFirstItem(ReactXmlExtension.resolveCallExpression((JSCallExpression)item));
                }
                if (ReactXmlElementDescriptor.isRequireCall(item)) {
                    isResolvedComponent = false;
                    isWeakResolve = true;
                }
                if (!(item instanceof JSQualifiedNamedElement) && !(item instanceof JSImplicitElement)) continue;
                firstComponent = firstComponent == null ? (JSElement)item : firstComponent;
                components.add((JSElement)item);
            }
        }
        if (firstComponent != null && firstComponent.getName() != null) {
            name = firstComponent.getName();
        } else {
            name = context.getName();
            isResolvedComponent = false;
            isWeakResolve = true;
        }
        String namespace = name + "." + "props";
        return new ReactComponent(context, (Collection<? extends PsiElement>)components, namespace, isWeakResolve, isResolvedComponent);
    }

    private static boolean isRequireCall(@Nullable PsiElement item) {
        if (!(item instanceof JSVariable)) {
            return false;
        }
        JSExpression initializer = ((JSVariable)item).getInitializerOrStub();
        return initializer instanceof JSCallExpression && ((JSCallExpression)initializer).isRequireCall();
    }

    private XmlAttributeDescriptor @NotNull [] resolveTagAttributes(XmlTag context) {
        XmlAttributeDescriptor[] typeScriptProperties = ReactXmlElementDescriptor.getPropertyAttributes(context);
        XmlElementDescriptor elementDescriptor = this.getXmlElementDescriptorFormParent(context);
        if (elementDescriptor != null && !(elementDescriptor instanceof ReactXmlElementDescriptor)) {
            XmlAttributeDescriptor[] xmlAttributeDescriptorArray = this.mergeAttributes(typeScriptProperties, elementDescriptor.getAttributesDescriptors(context));
            if (xmlAttributeDescriptorArray == null) {
                ReactXmlElementDescriptor.$$$reportNull$$$0(7);
            }
            return xmlAttributeDescriptorArray;
        }
        if (typeScriptProperties == null) {
            ReactXmlElementDescriptor.$$$reportNull$$$0(8);
        }
        return typeScriptProperties;
    }

    private static XmlAttributeDescriptor[] getPropertyAttributes(XmlTag context) {
        TypeScriptPropertySignature property = TypeScriptReactTagUtil.resolveTag(context);
        XmlAttributeDescriptor[] typeScriptProperties = XmlAttributeDescriptor.EMPTY;
        if (property != null) {
            typeScriptProperties = TypeScriptReactTagUtil.getXmlAttributeDescriptors(property);
        }
        return typeScriptProperties;
    }

    protected XmlAttributeDescriptor[] mergeAttributes(XmlAttributeDescriptor @NotNull [] typeScriptProperties, XmlAttributeDescriptor @NotNull [] parentDescriptors) {
        if (typeScriptProperties == null) {
            ReactXmlElementDescriptor.$$$reportNull$$$0(9);
        }
        if (parentDescriptors == null) {
            ReactXmlElementDescriptor.$$$reportNull$$$0(10);
        }
        if (parentDescriptors.length == 0) {
            return typeScriptProperties;
        }
        if (typeScriptProperties.length == 0) {
            return parentDescriptors;
        }
        ArrayList result2 = ContainerUtil.newArrayList((Object[])typeScriptProperties);
        Set names = Arrays.stream(typeScriptProperties).map(el -> StringUtil.toLowerCase((String)el.getName())).collect(Collectors.toSet());
        for (XmlAttributeDescriptor descriptor2 : parentDescriptors) {
            String name = descriptor2.getName();
            if (IGNORED_ATTRIBUTES.contains(name) || names.contains(ReactXmlElementDescriptor.normalizeAttributeName(name))) continue;
            result2.add(descriptor2);
        }
        return result2.toArray(XmlAttributeDescriptor.EMPTY);
    }

    @Nullable
    private XmlAttributeDescriptor resolveTagAttribute(XmlTag context, @NonNls String attributeName) {
        XmlElementDescriptor elementDescriptor;
        boolean hasTypeScriptDeclarations;
        TypeScriptPropertySignature property = TypeScriptReactTagUtil.resolveTag(context);
        boolean bl = hasTypeScriptDeclarations = property != null;
        if (hasTypeScriptDeclarations) {
            Ref resultRef = Ref.create();
            HashSet lowCaseNames = new HashSet();
            TypeScriptReactTagUtil.processAttributes(property, (Processor<? super JSRecordType.PropertySignature>)((Processor)el -> {
                String name = el.getMemberName();
                if (name.equals(attributeName)) {
                    resultRef.set((Object)TypeScriptReactTagUtil.createAttributeDescriptor(el, false));
                    return false;
                }
                lowCaseNames.add(StringUtil.toLowerCase((String)name));
                return true;
            }));
            if (!resultRef.isNull() || lowCaseNames.contains(ReactXmlElementDescriptor.normalizeAttributeName(StringUtil.toLowerCase((String)attributeName))) || IGNORED_ATTRIBUTES.contains(attributeName)) {
                return resultRef.isNull() ? null : (XmlAttributeDescriptor)resultRef.get();
            }
        }
        if ((elementDescriptor = this.getXmlElementDescriptorFormParent(context)) != null) {
            if (!(elementDescriptor instanceof ReactXmlElementDescriptor)) {
                XmlAttributeDescriptor attributeDescriptor = elementDescriptor.getAttributeDescriptor(attributeName, context);
                if (attributeDescriptor == null) {
                    return ReactXmlElementDescriptor.getEmptyAttributeValue(attributeName, hasTypeScriptDeclarations);
                }
                if (!(attributeDescriptor instanceof ReactAttributeDescriptor)) {
                    attributeDescriptor = new ReactAttributeDescriptorImpl.ReactHtmlAttributeDescriptorImpl(attributeDescriptor);
                }
                return attributeDescriptor;
            }
            return ReactXmlElementDescriptor.getEmptyAttributeValue(attributeName, hasTypeScriptDeclarations);
        }
        return ReactXmlElementDescriptor.getEmptyAttributeValue(attributeName, hasTypeScriptDeclarations);
    }

    private static String normalizeAttributeName(@NotNull String attributeName) {
        if (attributeName == null) {
            ReactXmlElementDescriptor.$$$reportNull$$$0(11);
        }
        return attributeName.replace("-", "");
    }

    @Nullable
    private static XmlAttributeDescriptor getEmptyAttributeValue(@NotNull String attributeName, boolean strict) {
        if (attributeName == null) {
            ReactXmlElementDescriptor.$$$reportNull$$$0(12);
        }
        return strict ? null : new ReactAnyXmlAttributeDescriptor(attributeName);
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getName(), attribute.getParent());
    }

    public XmlNSDescriptor getNSDescriptor() {
        return this.myDescriptor;
    }

    @Nullable
    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        return JSXResolveUtil.isComponentName(this.myName) && !"Fragment".equals(this.myName) && !this.requiredChildren() ? 0 : 1;
    }

    protected boolean requiredChildren() {
        if (!(this.myContext instanceof XmlTag)) {
            return true;
        }
        XmlAttributeDescriptor descriptor2 = this.getAttributeDescriptor("children", (XmlTag)this.myContext);
        return descriptor2 != null && descriptor2.isRequired();
    }

    @Nullable
    public String getDefaultValue() {
        return null;
    }

    @Nullable
    public PsiElement getDeclaration() {
        PsiElement declaration;
        XmlElementDescriptor descriptor2;
        if (!this.myStrict && this.myContext instanceof XmlTag && !JSXResolveUtil.isComponentName(this.myName) && (descriptor2 = this.getXmlElementDescriptorFormParent((XmlTag)this.myContext)) != null && !(descriptor2 instanceof ReactXmlElementDescriptor) && (declaration = descriptor2.getDeclaration()) != null) {
            return declaration;
        }
        return this.myContext;
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ReactXmlElementDescriptor.$$$reportNull$$$0(13);
        }
        return string;
    }

    public void init(PsiElement element) {
    }

    @Nullable
    private XmlElementDescriptor getXmlElementDescriptorFormParent(@Nullable XmlTag context) {
        if (context == null) {
            return null;
        }
        XmlNSDescriptor defaultNSDescriptor = JSXXmlLiteralExpressionImpl.getDefaultNSDescriptor(this.myContext);
        if (defaultNSDescriptor == null) {
            return null;
        }
        return defaultNSDescriptor.getElementDescriptor(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeScriptProperties";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDescriptors";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTagAttributes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findComponentProp";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getComponentProps";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getComponent";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getComponentNoCache";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "mergeAttributes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "normalizeAttributeName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getEmptyAttributeValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReactAnyXmlAttributeDescriptor
    extends AnyXmlAttributeDescriptor
    implements ReactAttributeDescriptor {
        ReactAnyXmlAttributeDescriptor(String attributeName) {
            super(attributeName);
        }

        @Override
        @Nullable
        public JSType getValueType() {
            return null;
        }
    }
}

