/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameFileFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.validation.fixes.ChangeLanguageLevelFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import icons.JavaScriptLanguageIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXLanguageLevelAnnotator
implements Annotator {
    private static final String JSX_SWITCH_DISABLED = "jsx.switch.disabled";

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        JSFile file2;
        if (element == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(1);
        }
        if ((file2 = (JSFile)ObjectUtils.tryCast((Object)element, JSFile.class)) == null) {
            return;
        }
        Project project = file2.getProject();
        DialectOptionHolder optionHolder = DialectDetector.dialectOfElement((PsiElement)file2);
        if (optionHolder == null || optionHolder.isJSX) {
            return;
        }
        if (PropertiesComponent.getInstance((Project)project).getBoolean(JSX_SWITCH_DISABLED)) {
            return;
        }
        if (JSXLanguageLevelAnnotator.isJsxFile(file2)) {
            if (optionHolder.isTypeScript) {
                VirtualFile virtualFile = file2.getVirtualFile();
                if (virtualFile != null && virtualFile.isInLocalFileSystem()) {
                    JSXLanguageLevelAnnotator.addTypeScriptNotification(holder, file2);
                }
            } else {
                JSXLanguageLevelAnnotator.addJavaScriptNotification(holder, file2);
            }
        }
    }

    private static void addJavaScriptNotification(@NotNull AnnotationHolder holder, @NotNull JSFile file2) {
        if (holder == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(3);
        }
        holder.newAnnotation(HighlightSeverity.WARNING, JavaScriptBundle.message((String)"js.switch.to.jsx.inspection.name", (Object[])new Object[0])).range((PsiElement)file2).fileLevel().gutterIconRenderer((GutterIconRenderer)new JsxGutterIconRenderer()).withFix((IntentionAction)new ChangeLanguageLevelFix(JSLanguageLevel.JSX){

            @Override
            @NotNull
            public String getText() {
                String string = JavaScriptBundle.message((String)"js.switch.to.jsx.inspection.switch", (Object[])new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.invoke(project, editor, file2);
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }).withFix(JSXLanguageLevelAnnotator.createDismissIntention()).create();
    }

    private static void addTypeScriptNotification(@NotNull AnnotationHolder holder, @NotNull JSFile file2) {
        if (holder == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(5);
        }
        holder.newAnnotation(HighlightSeverity.WARNING, JavaScriptBundle.message((String)"ts.switch.to.jsx.inspection.name", (Object[])new Object[0])).range((PsiElement)file2).fileLevel().gutterIconRenderer((GutterIconRenderer)new JsxGutterIconRenderer()).withFix((IntentionAction)new RenameFileFix(file2.getName() + "x")).withFix(JSXLanguageLevelAnnotator.createDismissIntention()).create();
    }

    @NotNull
    private static IntentionAction createDismissIntention() {
        return new IntentionAction(){

            @NotNull
            public String getText() {
                String string = JavaScriptBundle.message((String)"js.switch.to.jsx.inspection.dismiss", (Object[])new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = JavaScriptBundle.message((String)"javascript.change.language.level.family", (Object[])new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
                if (project == null) {
                    2.$$$reportNull$$$0(2);
                }
                return true;
            }

            public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
                if (project == null) {
                    2.$$$reportNull$$$0(3);
                }
                PropertiesComponent.getInstance((Project)project).setValue(JSXLanguageLevelAnnotator.JSX_SWITCH_DISABLED, "true");
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }

            public boolean startInWriteAction() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator$2";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isAvailable";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static boolean isJsxFile(@NotNull JSFile file2) {
        if (file2 == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(6);
        }
        final Ref jsxRef = Ref.create((Object)false);
        new JSRecursiveWalkingElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                if (element instanceof LeafPsiElement && element.getNode().getElementType() == JSTokenTypes.LT) {
                    PsiElement prev;
                    PsiElement next;
                    PsiElement startNext = PsiTreeUtil.nextLeaf((PsiElement)element);
                    PsiElement psiElement = next = startNext != null ? PsiTreeUtil.nextLeaf((PsiElement)startNext) : null;
                    if (JSXLanguageLevelAnnotator.isCloseTagExpression(startNext, next)) {
                        jsxRef.set((Object)true);
                        this.stopWalking();
                    }
                    PsiElement psiElement2 = prev = (prev = PsiTreeUtil.prevLeaf((PsiElement)element)) instanceof PsiWhiteSpace ? PsiTreeUtil.prevLeaf((PsiElement)prev) : prev;
                    if (JSXLanguageLevelAnnotator.isOpenTagExpression(next, prev)) {
                        jsxRef.set((Object)true);
                        this.stopWalking();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator$3", "visitElement"));
            }
        }.visitFile((PsiFile)file2);
        return (Boolean)jsxRef.get();
    }

    private static boolean isOpenTagExpression(@Nullable PsiElement next, @Nullable PsiElement prev) {
        if ((next == null || next.getNode().getElementType() != JSTokenTypes.LT) && prev instanceof PsiErrorElement && JavaScriptBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]).equals(((PsiErrorElement)prev).getErrorDescription())) {
            PsiElement prevPrev = PsiTreeUtil.prevLeaf((PsiElement)prev);
            return prevPrev == null || prevPrev.getNode().getElementType() != JSTokenTypes.LT;
        }
        return false;
    }

    private static boolean isCloseTagExpression(@Nullable PsiElement startNext, @Nullable PsiElement next) {
        if (startNext == null || next == null) {
            return false;
        }
        if (startNext instanceof PsiErrorElement && next.getNode().getElementType() == JSTokenTypes.REGEXP_LITERAL && JSXLanguageLevelAnnotator.isNodeTextLikeCloseTag(next)) {
            return true;
        }
        return next instanceof PsiErrorElement && startNext.getNode().getElementType() == JSTokenTypes.REGEXP_LITERAL && JSXLanguageLevelAnnotator.isNodeTextLikeCloseTag(startNext);
    }

    private static boolean isNodeTextLikeCloseTag(@NotNull PsiElement next) {
        String text;
        if (next == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(7);
        }
        return (text = next.getText()).startsWith("/") && text.contains(">");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addJavaScriptNotification";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addTypeScriptNotification";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isJsxFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isNodeTextLikeCloseTag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class JsxGutterIconRenderer
    extends GutterIconRenderer
    implements DumbAware {
        private JsxGutterIconRenderer() {
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = JavaScriptLanguageIcons.Logos.Jsx_16;
            if (icon == null) {
                JsxGutterIconRenderer.$$$reportNull$$$0(0);
            }
            return icon;
        }

        public boolean equals(Object obj) {
            return obj instanceof JsxGutterIconRenderer;
        }

        public int hashCode() {
            return System.identityHashCode(JavaScriptLanguageIcons.Logos.Jsx_16);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator$JsxGutterIconRenderer", "getIcon"));
        }
    }
}

