/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.ecmascript6.TypeScriptMemberInfo;
import com.intellij.lang.javascript.ecmascript6.TypeScriptModifiersUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.ecmascript6.TypescriptConstructorChecker;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.JSSemanticHighlightingUtil;
import com.intellij.lang.javascript.highlighting.TypeScriptHighlighter;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypePredicate;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSAttributeListImpl;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.TypeScriptConditionalTypeGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSSymbolType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.JSConstructorChecker;
import com.intellij.lang.javascript.validation.TypedJSAnnotatingVisitor;
import com.intellij.lang.typescript.inspections.TypeScriptSmartCastInspection;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAnnotatingVisitor
extends TypedJSAnnotatingVisitor {
    public static final Key<TypeScriptAnnotatorCheckerProvider> PROVIDER_KEY = Key.create((String)"Annotator.Checker.Provider");

    public TypeScriptAnnotatingVisitor(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(1);
        }
        super(psiElement, holder);
    }

    @Override
    @NotNull
    protected JSConstructorChecker createConstructorChecker() {
        return new TypescriptConstructorChecker(this.myProblemReporter);
    }

    @Override
    @NotNull
    protected JSAnnotatorProblemReporter createProblemReporter(PsiElement context) {
        AnnotationSession session = this.myHolder.getCurrentAnnotationSession();
        TypeScriptAnnotatorCheckerProvider provider = (TypeScriptAnnotatorCheckerProvider)session.getUserData(PROVIDER_KEY);
        if (provider == null) {
            provider = TypeScriptAnnotatorCheckerProvider.getCheckerProvider(context);
            session.putUserData(PROVIDER_KEY, (Object)provider);
        }
        JSAnnotatorProblemReporter jSAnnotatorProblemReporter = provider.getProblemReporter(this.myHolder);
        if (jSAnnotatorProblemReporter == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(2);
        }
        return jSAnnotatorProblemReporter;
    }

    @Override
    public void visitJSClass(JSClass jsClass) {
        super.visitJSClass(jsClass);
        for (Object classMember : jsClass.getMembers()) {
            JSAttributeList list2;
            if (!(classMember instanceof JSAttributeListOwner) || (list2 = ((JSAttributeListOwner)classMember).getAttributeList()) == null || !list2.hasPrivateSharp()) continue;
            for (ASTNode child : list2.getNode().getChildren(JSAttributeListImpl.ourModifiersTypeSet)) {
                IElementType elementType = child.getElementType();
                if (elementType != JSTokenTypes.PRIVATE_KEYWORD && elementType != JSTokenTypes.PROTECTED_KEYWORD && elementType != JSTokenTypes.PUBLIC_KEYWORD) continue;
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, JavaScriptBundle.message((String)"typescript.private.field.modifiers.mix", (Object[])new Object[0])).range(child).create();
            }
        }
    }

    @Override
    public void visitComment(@NotNull PsiComment comment) {
        if (comment == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(3);
        }
        super.visitComment(comment);
        ASTNode node = comment.getNode();
        if (node.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT && comment.getParent() instanceof JSFile && StringUtil.startsWith((CharSequence)node.getChars(), (CharSequence)"///")) {
            this.checkReferences((PsiElement)comment, ProblemHighlightType.ERROR);
            JSFixFactory.getInstance().typeScriptReferencePathValidator().checkReferences(comment, this.myHolder, !TypeScriptAnnotatingVisitor.skipTypeChecking((PsiElement)comment));
        }
    }

    @Override
    protected boolean checkReferences(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(4);
        }
        if (TypeScriptPsiUtil.isLiteralModuleAugmentationName(element) || element.getParent() instanceof ES6ImportCall) {
            return false;
        }
        return super.checkReferences(element);
    }

    @Override
    public void visitJSReferenceExpression(JSReferenceExpression node) {
        JSType typeFromGuard;
        if (TypeScriptAnnotatingVisitor.isSmartCastInspectionEnabled(node) && (typeFromGuard = JSTypeGuardUtil.getTypeIfAffectedByTypeGuard(node)) != null) {
            AnnotationBuilder builder = JSFixFactory.getInstance().isShowSmartCastText() ? this.myHolder.newAnnotation(HighlightSeverity.INFORMATION, JavaScriptBundle.message((String)"typescript.narrowed.to", (Object[])new Object[]{typeFromGuard.getTypeText(JSType.TypeTextFormat.PRESENTABLE)})) : this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION);
            builder.textAttributes(TypeScriptHighlighter.TS_TYPE_GUARD).create();
        }
        super.visitJSReferenceExpression(node);
    }

    public static boolean isSmartCastInspectionEnabled(JSReferenceExpression node) {
        Project project = node.getProject();
        InspectionProjectProfileManager manager2 = InspectionProjectProfileManager.getInstance((Project)project);
        InspectionProfileImpl inspectionProfile = manager2.getCurrentProfile();
        String id = JSInspection.calcShortNameFromClass(TypeScriptSmartCastInspection.class);
        HighlightDisplayKey key = HighlightDisplayKey.find((String)id);
        if (key == null) {
            key = new HighlightDisplayKey(id, id);
        }
        return inspectionProfile.isToolEnabled(key, (PsiElement)node.getContainingFile());
    }

    @Override
    protected void checkImplementedMethods(@NotNull JSClass jsClass, JSAnnotatingVisitor.ErrorReportingClient reportingClient) {
        Map<TypeScriptMemberInfo, JSClass> membersToImplement;
        if (jsClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(5);
        }
        if ((membersToImplement = TypeScriptUtil.getMemberInfos(jsClass, false)).isEmpty()) {
            return;
        }
        boolean isAbstractClass = TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)jsClass);
        LocalQuickFix implementAllFix = JSFixFactory.getInstance().typeScriptImplementMembersFix(jsClass, false);
        LocalQuickFix implementRequiredOnlyFix = JSFixFactory.getInstance().typeScriptImplementMembersFix(jsClass, true);
        LocalQuickFix implementAbstractFix = JSFixFactory.getInstance().typeScriptImplementMembersAbstractFix(jsClass);
        HashSet<String> processed = new HashSet<String>(membersToImplement.size());
        boolean hasOptional = TypeScriptUtil.getMemberInfos(jsClass, true).size() != membersToImplement.size();
        for (Map.Entry<TypeScriptMemberInfo, JSClass> entry : membersToImplement.entrySet()) {
            Object[] objectArray;
            boolean isIncompatible;
            ASTNode classKeyword;
            JSClass containerClass = entry.getValue();
            TypeScriptMemberInfo info = entry.getKey();
            if (info.getKind() == TypeScriptMemberInfo.Kind.INCOMPATIBLE && this.reportMemberIncompatible(jsClass, info, containerClass)) continue;
            String message = TypeScriptAnnotatingVisitor.getErrorMessageForNotImplementedError(jsClass, containerClass, info);
            assert (message != null);
            if (!processed.add(message)) continue;
            PsiElement nameIdentifier = jsClass.getNameIdentifier();
            if (nameIdentifier == null && (classKeyword = jsClass.getNode().findChildByType(JSTokenTypes.CLASS_KEYWORD)) != null) {
                nameIdentifier = classKeyword.getPsi();
            }
            if (nameIdentifier == null) {
                nameIdentifier = jsClass.getFirstChild();
            }
            boolean bl = isIncompatible = info.getKind() == TypeScriptMemberInfo.Kind.INCOMPATIBLE;
            if (isIncompatible) {
                objectArray = LocalQuickFix.EMPTY_ARRAY;
            } else {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                objectArray = localQuickFixArray;
                localQuickFixArray[0] = implementAllFix;
            }
            Object[] fixes = objectArray;
            if (!isIncompatible) {
                if (hasOptional) {
                    fixes = (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)implementRequiredOnlyFix);
                }
                if (isAbstractClass) {
                    fixes = (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)implementAbstractFix);
                }
            }
            this.myProblemReporter.registerProblem(nameIdentifier, null, message, ProblemHighlightType.GENERIC_ERROR, null, (LocalQuickFix[])fixes, IntentionAction.EMPTY_ARRAY);
        }
    }

    private boolean reportMemberIncompatible(@NotNull JSClass jsClass, TypeScriptMemberInfo info, JSClass containerClass) {
        PsiElement identifier;
        JSElement element;
        String name;
        if (jsClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(6);
        }
        if ((name = (element = info.getElement()).getName()) == null) {
            return false;
        }
        Collection members = jsClass.findMembersByName(name);
        if (members.size() != 1) {
            return false;
        }
        JSElement item = (JSElement)ContainerUtil.getFirstItem((Collection)members);
        if (item instanceof JSNamedElement && (identifier = ((JSNamedElement)item).getNameIdentifier()) != null) {
            String message = TypeScriptAnnotatingVisitor.getErrorMessageForNotImplementedError(jsClass, containerClass, info);
            this.myProblemReporter.registerProblem(identifier, null, message, ProblemHighlightType.GENERIC_ERROR, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
            return true;
        }
        return false;
    }

    @Nullable
    private static String getErrorMessageForNotImplementedError(@NotNull JSClass jsClass, @NotNull JSClass containerClass, @NotNull TypeScriptMemberInfo info) {
        if (jsClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(7);
        }
        if (containerClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(8);
        }
        if (info == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(9);
        }
        String interfaceName = containerClass.getName();
        JSElement memberToImplement = info.getElement();
        if (info.getKind() == TypeScriptMemberInfo.Kind.INCOMPATIBLE) {
            String property = memberToImplement instanceof JSFunction ? "javascript.validation.message.class.method.incompatible" : "javascript.validation.message.class.property.incompatible";
            return JavaScriptBundle.message((String)property, (Object[])new Object[]{memberToImplement.getName(), jsClass.getName(), interfaceName});
        }
        boolean isFunction = TypeScriptUtil.isTypeScriptMethod((PsiElement)memberToImplement);
        boolean isProperty = TypeScriptUtil.isTypeScriptProperty((PsiElement)memberToImplement);
        if (isFunction || isProperty || memberToImplement instanceof JSLocalImplicitElementImpl) {
            String messageId = TypeScriptAnnotatingVisitor.getMessageIdForNotImplementedError(containerClass, isFunction);
            return JavaScriptBundle.message((String)messageId, (Object[])new Object[]{memberToImplement.getName(), interfaceName});
        }
        if (memberToImplement instanceof TypeScriptCallSignature) {
            return JavaScriptBundle.message((String)"javascript.validation.message.interface.call.signature.not.implemented", (Object[])new Object[]{interfaceName});
        }
        if (memberToImplement instanceof TypeScriptIndexSignature) {
            return JavaScriptBundle.message((String)"javascript.validation.message.interface.index.signature.not.implemented", (Object[])new Object[]{interfaceName});
        }
        return null;
    }

    @NotNull
    private static String getMessageIdForNotImplementedError(@NotNull JSClass containerClass, boolean isFunction) {
        if (containerClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(10);
        }
        if (isFunction) {
            if (containerClass instanceof TypeScriptClass) {
                return "javascript.validation.message.class.method.not.implemented";
            }
            return "javascript.validation.message.interface.method.not.implemented";
        }
        if (containerClass instanceof TypeScriptClass) {
            return "javascript.validation.message.class.property.not.implemented";
        }
        return "javascript.validation.message.interface.property.not.implemented";
    }

    @Override
    protected void checkSetterReturnType(@NotNull JSFunction function2) {
        PsiElement returnTypeElement;
        if (function2 == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(11);
        }
        if ((returnTypeElement = function2.getReturnTypeElement()) != null) {
            this.myProblemReporter.registerGenericError(returnTypeElement, JavaScriptBundle.message((String)"javascript.validation.message.class.setter.cannot.have.return.type", (Object[])new Object[0]), new IntentionAction[0]);
        }
    }

    @Override
    protected void validateSetter(@NotNull JSFunction setter, @NotNull JSFunction getter, JSParameterListElement param, JSType setterType, JSType retType) {
        if (setter == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(12);
        }
        if (getter == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(13);
        }
        this.checkAccessorAccessTypeMatch(setter, getter, "typescript.validation.message.getter.and.setter.must.have.same.access.type");
    }

    @Override
    protected void validateGetter(@NotNull JSFunction getter, @Nullable JSFunction setter, JSType type) {
        if (getter == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(14);
        }
        if (setter != null) {
            this.checkAccessorAccessTypeMatch(getter, setter, "typescript.validation.message.getter.and.setter.must.have.same.access.type");
        }
    }

    public void visitTypeScriptIndexSignature(TypeScriptIndexSignature indexSignature) {
        JSSemanticHighlightingUtil.highlight(indexSignature, this.myHighlighter, this.myHolder);
        PsiElement nameElement = indexSignature.getParameterNameElement();
        JSTypeDeclaration parameterType = indexSignature.getParameterType();
        if (nameElement != null) {
            if (parameterType == null) {
                this.myProblemReporter.registerGenericError(nameElement, JavaScriptBundle.message((String)"javascript.validation.message.index.no.type", (Object[])new Object[0]), new IntentionAction[0]);
            } else {
                JSSemanticHighlightingUtil.highlight(indexSignature, this.myHighlighter, this.myHolder);
                JSType type = parameterType.getJSType();
                if (!TypeScriptAnnotatingVisitor.isValidIndexerType(type)) {
                    this.myProblemReporter.registerGenericError((PsiElement)parameterType, JavaScriptBundle.message((String)"javascript.validation.message.index.wrong.type", (Object[])new Object[0]), new IntentionAction[0]);
                }
            }
        }
    }

    private static boolean isValidIndexerType(JSType type) {
        if (TypeScriptAnnotatingVisitor.isAssignableInAnyDirection(type, new JSStringType(true, type.getSource(), JSTypeContext.INSTANCE))) {
            return true;
        }
        if (TypeScriptAnnotatingVisitor.isAssignableInAnyDirection(type, new JSNumberType(true, type.getSource(), JSTypeContext.INSTANCE))) {
            return true;
        }
        return TypeScriptAnnotatingVisitor.isAssignableInAnyDirection(type, new JSSymbolType(true, type.getSource(), JSTypeContext.INSTANCE));
    }

    private static boolean isAssignableInAnyDirection(JSType type, JSType otherType) {
        return type.isDirectlyAssignableType(otherType, null) || otherType.isDirectlyAssignableType(type, null);
    }

    public void visitTypeScriptPropertySignature(TypeScriptPropertySignature propertySignature) {
        this.checkDuplicates((JSPsiNamedElementBase)propertySignature);
        JSSemanticHighlightingUtil.highlight(propertySignature, this.myHighlighter, this.myHolder);
    }

    public void visitTypeScriptFunctionSignature(TypeScriptFunctionSignature functionSignature) {
        this.checkDuplicates((JSPsiNamedElementBase)functionSignature);
        JSSemanticHighlightingUtil.highlight(functionSignature, this.myHighlighter, this.myHolder);
    }

    public void visitTypeScriptTypeParameter(TypeScriptTypeParameter typeParameter) {
        JSSemanticHighlightingUtil.highlight((TypeScriptGenericOrMappedTypeParameter)typeParameter, this.myHighlighter, this.myHolder);
    }

    public void visitTypeScriptMappedTypeParameter(TypeScriptMappedTypeParameter typeParameter) {
        JSSemanticHighlightingUtil.highlight((TypeScriptGenericOrMappedTypeParameter)typeParameter, this.myHighlighter, this.myHolder);
    }

    @Override
    protected void checkOverriddenMethods(@NotNull JSClass aClass) {
        if (aClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(15);
        }
        JSRecordType aClassInstanceType = TypeScriptTypeParser.buildTypeFromClass(aClass, false, false);
        JSRecordType aClassConstructorType = TypeScriptTypeParser.buildTypeFromClass(aClass, true, false);
        MultiMap checkedMembersInstance = MultiMap.createSet();
        MultiMap checkedMembersConstructor = MultiMap.createSet();
        for (JSClass parentClass : TypeScriptUtil.getNonStrictParents(aClass, aClass instanceof TypeScriptInterface)) {
            if (parentClass == aClass) continue;
            this.checkOverride(aClass, aClassInstanceType, parentClass, false, (MultiMap<JSRecordType.PropertySignature, JSClass>)checkedMembersInstance);
            this.checkOverride(aClass, aClassConstructorType, parentClass, true, (MultiMap<JSRecordType.PropertySignature, JSClass>)checkedMembersConstructor);
        }
    }

    private void checkOverride(@NotNull JSClass aClass, @NotNull JSRecordType aClassType, @NotNull JSClass parentClass, boolean isStatic, @NotNull MultiMap<JSRecordType.PropertySignature, JSClass> checkedMembers) {
        if (aClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(16);
        }
        if (aClassType == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(17);
        }
        if (parentClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(18);
        }
        if (checkedMembers == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(19);
        }
        JSRecordType parentClassInstanceType = TypeScriptTypeParser.buildTypeFromClass(parentClass, isStatic, false);
        ProcessingContext contextWithCache = JSTypeComparingContextService.getProcessingContextWithCache((PsiElement)aClass);
        for (JSRecordType.PropertySignature parentClassPropertySignature : parentClassInstanceType.getProperties()) {
            JSType type;
            String name = parentClassPropertySignature.getMemberName();
            JSRecordType.PropertySignature aClassPropertySignature = aClassType.findPropertySignature(name);
            if (aClassPropertySignature == null) continue;
            Collection classes = checkedMembers.get((Object)aClassPropertySignature);
            if (!classes.isEmpty()) {
                boolean wasCheckedForHierarchy = false;
                for (JSClass checkedClass : classes) {
                    if (!JSInheritanceUtil.isParentClass(checkedClass, parentClass)) continue;
                    wasCheckedForHierarchy = true;
                    break;
                }
                if (wasCheckedForHierarchy) {
                    continue;
                }
            } else {
                checkedMembers.putValue((Object)aClassPropertySignature, (Object)parentClass);
            }
            if ((type = parentClassPropertySignature.getJSType()) == null || (type = JSTypeUtils.hasForeignGenericParameter(type) ? TypeScriptUtil.applyGenericsToType(type, aClass, parentClass) : type).isDirectlyAssignableType(aClassPropertySignature.getJSType(), contextWithCache)) continue;
            for (JSNamedElement classMember : TypeScriptUtil.getNamedMembers(aClass)) {
                PsiElement nameIdentifier;
                if (!name.equals(classMember.getName())) continue;
                boolean isStaticMember = false;
                if (classMember instanceof JSAttributeListOwner) {
                    JSAttributeList attributeList = ((JSAttributeListOwner)classMember).getAttributeList();
                    boolean bl = isStaticMember = attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
                }
                if (isStaticMember != isStatic || (nameIdentifier = classMember.getNameIdentifier()) == null) continue;
                this.myProblemReporter.registerGenericError(nameIdentifier, JavaScriptBundle.message((String)"javascript.validation.message.incompatible.override", (Object[])new Object[]{parentClass.getName()}), new IntentionAction[0]);
            }
        }
    }

    @Override
    protected ProblemHighlightType getHighlightTypeForTypeOrSignatureProblem(@NotNull PsiElement node) {
        if (node == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(20);
        }
        if (node instanceof JSCallExpression) {
            node = ((JSCallExpression)node).getMethodExpression();
        }
        return node instanceof JSReferenceExpression && !TypeScriptUtil.resolveIsStrict((JSReferenceExpression)node) ? ProblemHighlightType.LIKE_UNKNOWN_SYMBOL : ProblemHighlightType.GENERIC_ERROR;
    }

    @Override
    protected boolean checkExtendsRef(JSClass jsClass, JSClass referencedClass, JSExpression expr) {
        return true;
    }

    @Override
    protected boolean checkImplementsRef(JSClass jsClass, JSExpression expr) {
        return true;
    }

    public void visitTypeScriptImportStatement(TypeScriptImportStatement importStatement) {
        PsiElement identifier;
        TypeScriptExternalModuleReference externalModuleReference = importStatement.getExternalModuleReference();
        if (externalModuleReference != null) {
            String referenceNodeText;
            ASTNode referenceNode = externalModuleReference.findReferenceNode();
            String string = referenceNodeText = referenceNode != null ? StringUtil.unquoteString((String)referenceNode.getText()) : null;
            if (referenceNodeText != null && referenceNodeText.endsWith(".ts")) {
                this.myProblemReporter.registerGenericError(referenceNode, JavaScriptBundle.message((String)"typescript.validation.module.reference.with.extension", (Object[])new Object[0]), new IntentionAction[0]);
            }
        }
        if ((identifier = importStatement.getNameIdentifier()) != null) {
            PsiElement meaningfulElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement((PsiElement)importStatement);
            JSSemanticHighlightingUtil.highlight(identifier, meaningfulElement, this.myHighlighter, this.myHolder);
        }
        super.visitTypeScriptImportStatement(importStatement);
    }

    @Override
    protected void checkFunctionDeclaration(@NotNull JSFunction node) {
        JSClass parentClass;
        if (node == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(21);
        }
        if ((parentClass = TypeScriptPsiUtil.getParentClass((PsiElement)node)) != null) {
            this.validateClassMember(node, parentClass);
        }
        this.validateSignatureFunction(node, parentClass);
        super.checkFunctionDeclaration(node);
    }

    @Nullable
    private static ASTNode getStarFromGenerator(@NotNull JSFunction function2) {
        ASTNode mult;
        if (function2 == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(22);
        }
        if (!function2.isGenerator()) {
            return null;
        }
        JSAttributeList list2 = function2.getAttributeList();
        if (list2 != null && (mult = list2.getNode().findChildByType(JSTokenTypes.MULT)) != null) {
            return mult;
        }
        return function2.getNode().findChildByType(JSTokenTypes.MULT);
    }

    private void validateSignatureFunction(JSFunction node, JSClass parentClass) {
        if (!(node instanceof TypeScriptFunction) || node instanceof JSFunctionExpression) {
            return;
        }
        TypeScriptFunction function2 = (TypeScriptFunction)node;
        boolean noBody = function2.getBlock() == null;
        boolean isOverload = function2.isOverloadDeclaration();
        boolean isAbstract = TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)function2);
        boolean isOptional = function2.isOptional();
        boolean isAmbient = TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)function2);
        if (!(!noBody || isOverload || isOptional || isAbstract || isAmbient)) {
            SmartList intentions = new SmartList();
            TypeScriptAnnotatingVisitor.addMakeMethodAbstractIntention(parentClass, function2, (Collection<IntentionAction>)intentions);
            this.myProblemReporter.registerGenericError(function2.getNameIdentifier(), JavaScriptBundle.message((String)"typescript.validation.message.function.implementation.missing", (Object[])new Object[0]), intentions.toArray(IntentionAction.EMPTY_ARRAY));
            return;
        }
        if (function2.isGenerator()) {
            if (isOverload) {
                ASTNode multNode = TypeScriptAnnotatingVisitor.getStarFromGenerator((JSFunction)function2);
                if (multNode != null) {
                    this.myProblemReporter.registerGenericError(multNode, JavaScriptBundle.message((String)"typescript.validation.generators.overload", (Object[])new Object[0]), new IntentionAction[0]);
                }
                return;
            }
            if (isAmbient) {
                ASTNode multNode = TypeScriptAnnotatingVisitor.getStarFromGenerator((JSFunction)function2);
                if (multNode != null) {
                    this.myProblemReporter.registerGenericError(multNode, JavaScriptBundle.message((String)"typescript.validation.generators.ambient", (Object[])new Object[0]), new IntentionAction[0]);
                }
                return;
            }
        }
        if (isOverload || isAmbient) {
            return;
        }
        List overloadDeclarations = function2.getOverloadDeclarations();
        if (overloadDeclarations.size() > 0 && parentClass != null) {
            HashSet<TypeScriptFunction> abstracts = new HashSet<TypeScriptFunction>();
            if (isAbstract) {
                abstracts.add(function2);
            }
            for (TypeScriptFunction declaration : overloadDeclarations) {
                if (!TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)declaration)) continue;
                abstracts.add(declaration);
            }
            if (abstracts.size() != overloadDeclarations.size() + 1) {
                for (TypeScriptFunction anAbstract : abstracts) {
                    JSAttributeList list2 = anAbstract.getAttributeList();
                    PsiElement element = list2 != null ? list2.findModifierElement(JSAttributeList.ModifierType.ABSTRACT) : null;
                    if (element == null) continue;
                    this.myProblemReporter.registerGenericError(element, JavaScriptBundle.message((String)"typescript.validation.message.abstract.overload", (Object[])new Object[0]), new IntentionAction[0]);
                }
            }
        }
    }

    private static void addMakeMethodAbstractIntention(JSClass parentClass, TypeScriptFunction function2, Collection<IntentionAction> intentions) {
        JSAttributeList methodAttributeList;
        JSAttributeList list2;
        if (parentClass instanceof TypeScriptClass && parentClass.getAttributeList() != null && (list2 = parentClass.getAttributeList()).hasModifier(JSAttributeList.ModifierType.ABSTRACT) && (methodAttributeList = function2.getAttributeList()) != null && !methodAttributeList.hasModifier(JSAttributeList.ModifierType.STATIC)) {
            intentions.add((IntentionAction)JSFixFactory.getInstance().insertModifier((JSAttributeListOwner)function2, JSAttributeList.ModifierType.ABSTRACT));
        }
    }

    private void validateClassMember(JSFunction member, JSClass parentClass) {
        PsiElement element;
        JSAttributeList list2;
        PsiElement identifier;
        if (TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)member) && member.getBlock() != null && (identifier = member.getNameIdentifier()) != null) {
            this.myProblemReporter.registerGenericError(identifier, JavaScriptBundle.message((String)"javascript.ambient.declaration.should.have.no.body", (Object[])new Object[0]), new IntentionAction[0]);
        }
        if ((list2 = member.getAttributeList()) != null && (element = list2.findModifierElement(JSAttributeList.ModifierType.ABSTRACT)) != null) {
            if (list2.getExplicitAccessType() == JSAttributeList.AccessType.PRIVATE) {
                this.myProblemReporter.registerGenericError(element, JavaScriptBundle.message((String)"typescript.validation.message.abstract.cannot.be.used", (Object[])new Object[]{"private"}), new IntentionAction[0]);
            } else if (list2.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                this.myProblemReporter.registerGenericError(element, JavaScriptBundle.message((String)"typescript.validation.message.abstract.cannot.be.used", (Object[])new Object[]{"static"}), new IntentionAction[0]);
            }
            if (member.isConstructor()) {
                this.myProblemReporter.registerGenericError(element, JavaScriptBundle.message((String)"typescript.validation.message.constructor.cannot.be.abstract", (Object[])new Object[0]), TypeScriptAnnotatingVisitor.createRemoveAbstractKeywordFix(element));
            } else if (member.getBlock() != null) {
                this.myProblemReporter.registerGenericError(member.getNameIdentifier(), JavaScriptBundle.message((String)"typescript.validation.message.abstract.cannot.have.body", (Object[])new Object[0]), TypeScriptAnnotatingVisitor.createRemoveAbstractKeywordFix(element));
            } else {
                JSAttributeList attrList = parentClass.getAttributeList();
                if (attrList == null || !attrList.hasModifier(JSAttributeList.ModifierType.ABSTRACT)) {
                    this.myProblemReporter.registerGenericError(element, JavaScriptBundle.message((String)"typescript.validation.message.abstract.class.should.be", (Object[])new Object[0]), new IntentionAction[]{JSFixFactory.getInstance().insertModifier((JSAttributeListOwner)parentClass, JSAttributeList.ModifierType.ABSTRACT)});
                }
            }
        }
    }

    private static IntentionAction createRemoveAbstractKeywordFix(PsiElement element) {
        return JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.abstract.keyword", element);
    }

    @Override
    public void visitJSAttributeList(JSAttributeList attributeList) {
        PsiElement container = attributeList.getParent();
        PsiElement place = TypeScriptPsiUtil.getParentOverDefaultAssignable(container);
        boolean isTopLevel = TypeScriptPsiUtil.isTopLevelContainer(place);
        ASTNode[] children = attributeList.getNode().getChildren(JSTokenTypes.MODIFIERS);
        if (children.length == 0) {
            return;
        }
        boolean alreadyHasAccessModifier = false;
        HashSet<IElementType> modifiers = new HashSet<IElementType>();
        for (ASTNode child : children) {
            IElementType elementType = child.getElementType();
            String message = TypeScriptModifiersUtil.validateModifiers(container, isTopLevel, alreadyHasAccessModifier, modifiers, child, elementType);
            if (message != null) {
                this.myProblemReporter.registerGenericError(child, message, new IntentionAction[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.modifier", child.getPsi())});
            }
            if (!TypeScriptModifiersUtil.isAccessibilityModifier(elementType)) continue;
            alreadyHasAccessModifier = true;
        }
        super.visitJSAttributeList(attributeList);
    }

    @Override
    protected void validateRestParameterType(JSParameterListElement parameter) {
        JSType type;
        PsiElement typeElement = parameter.getTypeElement();
        if (typeElement != null && parameter instanceof JSParameter && !TypeScriptAnnotatingVisitor.isValidRestType(type = ((TypeScriptType)typeElement).getJSType().substitute())) {
            String newTypeText = new JSArrayTypeImpl(type, type.getSource()).getTypeText(JSType.TypeTextFormat.CODE);
            LocalQuickFixAndIntentionActionOnPsiElement changeTypeFix = JSFixFactory.getInstance().changeTypeFix((JSNamedElement)((JSParameter)parameter), newTypeText, "typescript.validation.message.unexpected.type.for.rest.parameter.fix");
            this.myProblemReporter.registerGenericError(typeElement, JavaScriptBundle.message((String)"typescript.validation.message.unexpected.type.for.rest.parameter", (Object[])new Object[0]), new IntentionAction[]{changeTypeFix});
        }
    }

    private static boolean isValidRestType(JSType type) {
        if (JSTypeUtils.isIndexableType(type)) {
            return true;
        }
        if (type instanceof JSGenericParameterImpl && (TypeScriptAnnotatingVisitor.isInferType(type) || JSTypeUtils.getIndexableComponentType(((JSGenericParameterImpl)type).getConstraintType()) != null)) {
            return true;
        }
        if (type instanceof JSIntersectionType) {
            return ((JSIntersectionType)type).getTypes().stream().allMatch(TypeScriptAnnotatingVisitor::isValidRestType);
        }
        return false;
    }

    private static boolean isInferType(JSType type) {
        return type instanceof TypeScriptConditionalTypeGenericParameterImpl;
    }

    @Override
    public void visitJSVariable(@NotNull JSVariable var) {
        String message;
        if (var == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(23);
        }
        JSClass grandParent = JSUtils.getMemberContainingClass((PsiElement)var);
        if (TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)var) && !(grandParent instanceof TypeScriptEnum) && (message = TypeScriptAnnotatingVisitor.getMessageForAmbientDeclaration(var)) != null) {
            this.myProblemReporter.registerGenericError((PsiElement)var.getInitializer(), message, new IntentionAction[0]);
        }
        super.visitJSVariable(var);
    }

    @Nullable
    private static String getMessageForAmbientDeclaration(@NotNull JSVariable var) {
        JSExpression initializer;
        if (var == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(24);
        }
        if ((initializer = var.getInitializer()) == null) {
            return null;
        }
        PsiElement type = var.getTypeElement();
        if (type != null || !var.isConst()) {
            return JavaScriptBundle.message((String)"javascript.ambient.declaration.should.have.no.initializer", (Object[])new Object[0]);
        }
        JSType jsType = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(var.getJSType());
        if (jsType instanceof JSPrimitiveLiteralType) {
            return null;
        }
        if (jsType instanceof JSResolvableType && ((JSResolvableType)jsType).resolveType().isEnumLiteral()) {
            return null;
        }
        return JavaScriptBundle.message((String)"javascript.ambient.declaration.const.should.be.primitive", (Object[])new Object[0]);
    }

    public void visitTypeScriptExportAssignment(TypeScriptExportAssignment exportAssignment) {
        PsiElement parent = exportAssignment.getParent();
        if (parent instanceof TypeScriptModule && ((TypeScriptModule)parent).isInternal()) {
            this.myProblemReporter.registerGenericError(exportAssignment.getNode(), JavaScriptBundle.message((String)"typescript.export.assignment.cannot.be.used.in.internal.modules", (Object[])new Object[0]), new IntentionAction[0]);
        }
        super.visitTypeScriptExportAssignment(exportAssignment);
    }

    public void visitTypeScriptTypePredicate(@NotNull TypeScriptTypePredicate predicate) {
        PsiElement parent;
        if (predicate == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(25);
        }
        if (!this.checkTypePredicateShouldBeReturnType(predicate, parent = predicate.getParent())) {
            JSType guardType;
            if ("this".equals(predicate.getParameterName())) {
                return;
            }
            JSParameter parameter = predicate.getParameterMatchName();
            if (parameter == null) {
                PsiElement anchor = predicate.getNameIdentifier();
                if (anchor == null) {
                    anchor = predicate;
                }
                this.myProblemReporter.registerGenericError(anchor.getNode(), JavaScriptBundle.message((String)"typescript.type.predicate.not.match.name", (Object[])new Object[]{predicate.getParameterName()}), new IntentionAction[0]);
                return;
            }
            if (parameter.isRest()) {
                this.myProblemReporter.registerGenericError(predicate.getNameIdentifier(), JavaScriptBundle.message((String)"typescript.type.predicate.rest", (Object[])new Object[0]), new IntentionAction[0]);
                return;
            }
            PsiElement nameParent = parameter.getParent();
            if (nameParent instanceof JSDestructuringContainer || nameParent instanceof JSDestructuringProperty || nameParent instanceof JSDestructuringArrayRestElement) {
                this.myProblemReporter.registerGenericError(predicate.getNameIdentifier(), JavaScriptBundle.message((String)"typescript.type.predicate.destructuring", (Object[])new Object[0]), new IntentionAction[0]);
                return;
            }
            JSType parameterType = parameter.getJSType();
            if (parameterType != null && (guardType = predicate.getGuardType()) != null && !parameterType.isDirectlyAssignableType(guardType, JSTypeComparingContextService.getProcessingContextWithCache((PsiElement)predicate))) {
                this.myProblemReporter.registerGenericError((PsiElement)predicate, JavaScriptBundle.message((String)"typescript.type.predicate.incompatible.types", (Object[])new Object[]{parameterType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), new IntentionAction[0]);
            }
        }
        super.visitTypeScriptTypePredicate(predicate);
    }

    private boolean checkTypePredicateShouldBeReturnType(@NotNull TypeScriptTypePredicate predicate, @NotNull PsiElement parent) {
        boolean isParentCorrectFunction;
        if (predicate == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(26);
        }
        if (parent == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(27);
        }
        boolean bl = isParentCorrectFunction = parent instanceof TypeScriptFunction && !((TypeScriptFunction)parent).isConstructor() && ((TypeScriptFunction)parent).getReturnTypeElement() == predicate;
        if (isParentCorrectFunction) {
            return false;
        }
        if (predicate.isThisType()) {
            if (parent instanceof JSField && ((JSField)parent).getTypeElement() == predicate) {
                return false;
            }
            this.myProblemReporter.registerGenericError(predicate.getNode(), JavaScriptBundle.message((String)"typescript.type.this.predicate.not.return", (Object[])new Object[0]), new IntentionAction[0]);
        } else {
            this.myProblemReporter.registerGenericError(predicate.getNode(), JavaScriptBundle.message((String)"typescript.type.predicate.not.return", (Object[])new Object[0]), new IntentionAction[0]);
        }
        return true;
    }

    @Override
    public void visitJSParameterList(JSParameterList node) {
        boolean hasOptional = false;
        for (JSParameterListElement parameter : node.getParameters()) {
            if (hasOptional && !parameter.isOptional() && !parameter.isRest()) {
                this.myProblemReporter.registerGenericError((PsiElement)parameter, JavaScriptBundle.message((String)"javascript.validation.message.parameter.non.optional.after.optional", (Object[])new Object[0]), new IntentionAction[0]);
            }
            if (parameter.isRest() && parameter.isOptional()) {
                this.myProblemReporter.registerGenericError((PsiElement)parameter, JavaScriptBundle.message((String)"javascript.validation.message.parameter.rest.optional", (Object[])new Object[0]), new IntentionAction[0]);
            }
            hasOptional = hasOptional || parameter.isOptional();
        }
        super.visitJSParameterList(node);
    }

    @Override
    protected LocalQuickFix @NotNull [] getQuickFixesForReferenceProblem(@NotNull PsiReference ref, @Nullable String message) {
        if (ref == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(28);
        }
        if (ref instanceof ES6ImportExportSpecifier && message != null) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = ((ES6ImportExportSpecifier)ref).multiResolve(false)) {
                if (!(result2 instanceof JSResolveResult) || ((JSResolveResult)result2).getResolveProblemKey() != "javascript.element.need.to.be.included.to.config") continue;
                LocalQuickFix[] localQuickFixArray = JSFixFactory.getInstance().typeScriptConfigFixes((JSElement)ref, result2.getElement()).toArray(LocalQuickFix.EMPTY_ARRAY);
                if (localQuickFixArray == null) {
                    TypeScriptAnnotatingVisitor.$$$reportNull$$$0(29);
                }
                return localQuickFixArray;
            }
        }
        LocalQuickFix[] localQuickFixArray = super.getQuickFixesForReferenceProblem(ref, message);
        if (localQuickFixArray == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(30);
        }
        return localQuickFixArray;
    }

    private static boolean skipTypeChecking(@NotNull PsiElement context) {
        if (context == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(31);
        }
        return TypeScriptAnnotatorCheckerProvider.getCheckerProvider(context).skipErrors();
    }

    public void visitTypeScriptEntityName(TypeScriptEntityName entityName) {
        JSSemanticHighlightingUtil.highlight((JSPsiReferenceElement)entityName, this.myHighlighter, this.myHolder);
        super.visitTypeScriptEntityName(entityName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatingVisitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClassType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedMembers";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatingVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createProblemReporter";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixesForReferenceProblem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 29: 
            case 30: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitComment";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkReferences";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkImplementedMethods";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reportMemberIncompatible";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessageForNotImplementedError";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMessageIdForNotImplementedError";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkSetterReturnType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "validateSetter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "validateGetter";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkOverriddenMethods";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkOverride";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightTypeForTypeOrSignatureProblem";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionDeclaration";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getStarFromGenerator";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitJSVariable";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getMessageForAmbientDeclaration";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptTypePredicate";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkTypePredicateShouldBeReturnType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixesForReferenceProblem";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "skipTypeChecking";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

