/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSLookupElementInfo;
import com.intellij.lang.javascript.completion.JSLookupElementInfoImpl;
import com.intellij.lang.javascript.completion.JSLookupElementMerger;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSSimpleTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTaggedResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptLiteralBasedPropertyElement;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.typescript.completion.ItemWithAction;
import com.intellij.lang.typescript.completion.TypeScriptSmartCompletionContributor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSVariantsProcessorMerger
extends JSLookupElementMerger {
    public JSVariantsProcessorMerger(PsiElement context, @NotNull JSLookupElementMerger.MergeFilter filter, int limit, boolean firstOverloadOnly) {
        if (filter == null) {
            JSVariantsProcessorMerger.$$$reportNull$$$0(0);
        }
        super(context, filter, limit, firstOverloadOnly);
    }

    public void addRecordTypeElements(@NotNull JSRecordType recordType, PsiFile targetFile, PsiElement context) {
        if (recordType == null) {
            JSVariantsProcessorMerger.$$$reportNull$$$0(1);
        }
        PsiElement element = recordType.getSource().getSourceElement();
        for (JSRecordType.TypeMember member : recordType.getTypeMembers()) {
            if (!(member instanceof JSRecordType.PropertySignature)) continue;
            JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)member;
            String name = JSSymbolUtil.handleSpecialPropertyNames(propertySignature.getMemberName(), JSCodeStyleSettings.getQuoteChar((PsiElement)targetFile));
            JSType type = propertySignature.getJSType();
            JSRecordType.MemberSource source = propertySignature.getMemberSource();
            PsiElement sourceElement = source.getSingleElement();
            name = JSVariantsProcessorMerger.adjustNameWithComputedName(name, sourceElement, targetFile, context);
            Object el = sourceElement == null ? new JSLocalImplicitElementImpl(name, type, element, JSImplicitElement.Type.Property) : sourceElement;
            this.addResult((PsiElement)el, name, JSLookupPriority.MAX_PRIORITY, BaseJSSymbolProcessor.MatchType.COMPLETE, null);
        }
    }

    @NotNull
    private static String adjustNameWithComputedName(@NotNull String name, @Nullable PsiElement sourceElement, PsiFile targetFile, PsiElement context) {
        if (name == null) {
            JSVariantsProcessorMerger.$$$reportNull$$$0(2);
        }
        if (sourceElement instanceof JSComputedPropertyNameOwner) {
            ItemWithAction item = TypeScriptSmartCompletionContributor.getSpecialItemForCompletion((JSComputedPropertyNameOwner)sourceElement, context);
            if (item != null) {
                name = item.item;
            }
        } else if (sourceElement instanceof TypeScriptLiteralBasedPropertyElement) {
            PsiElement original = sourceElement.getParent();
            JSSimpleTypeProcessor processor = new JSSimpleTypeProcessor();
            JSTypeEvaluator.evaluateExpressionOrElementTypes(targetFile, processor, original);
            List<ItemWithAction> items = TypeScriptSmartCompletionContributor.getSpecialItemsForCompletion(processor.getType(), context, null, true);
            ItemWithAction item = (ItemWithAction)ContainerUtil.getFirstItem(items);
            if (item != null) {
                name = item.item;
            }
        }
        String string = name;
        if (string == null) {
            JSVariantsProcessorMerger.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void addNeighbourReference(@NotNull JSQualifiedName neighbourReference, boolean onlyApplyPriority) {
        String name;
        Collection elements;
        if (neighbourReference == null) {
            JSVariantsProcessorMerger.$$$reportNull$$$0(4);
        }
        if (!(elements = this.myResults.get((Object)(name = neighbourReference.getName()))).isEmpty()) {
            ArrayList<JSLookupElementInfo> newElements = new ArrayList<JSLookupElementInfo>(elements.size());
            boolean hadNeighbours = false;
            for (JSLookupElementInfo element : elements) {
                if (element.compareTo(null, JSLookupPriority.NEIGHBOUR_REFERENCES_PRIORITY, null, this.myPlace) < 0) {
                    hadNeighbours = true;
                    newElements.add(element.withNewPriority(JSLookupPriority.NEIGHBOUR_REFERENCES_PRIORITY));
                    continue;
                }
                newElements.add(element);
            }
            if (hadNeighbours) {
                this.myResults.put((Object)name, newElements);
            }
        } else if (!onlyApplyPriority) {
            this.myResults.putValue((Object)name, (Object)new SimpleMergeInfo(name, JSLookupPriority.NEIGHBOUR_REFERENCES_PRIORITY));
        }
    }

    @Override
    @NotNull
    protected JSLookupElementInfoImpl createMergeInfo(@Nullable PsiElement element, @NotNull String name, @NotNull JSLookupPriority priority, @NotNull BaseJSSymbolProcessor.MatchType matchType, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (name == null) {
            JSVariantsProcessorMerger.$$$reportNull$$$0(5);
        }
        if (priority == null) {
            JSVariantsProcessorMerger.$$$reportNull$$$0(6);
        }
        if (matchType == null) {
            JSVariantsProcessorMerger.$$$reportNull$$$0(7);
        }
        return new VariantLookupElementInfo(element, name, priority, matchType, typeSubstitutor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSVariantsProcessorMerger";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "neighbourReference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSVariantsProcessorMerger";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustNameWithComputedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addRecordTypeElements";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "adjustNameWithComputedName";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addNeighbourReference";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createMergeInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class VariantLookupElementInfo
    extends JSLookupElementInfoImpl {
        VariantLookupElementInfo(@Nullable PsiElement element, @NotNull String name, @NotNull JSLookupPriority priority, @NotNull BaseJSSymbolProcessor.MatchType matchType, @Nullable JSTypeSubstitutor typeSubstitutor) {
            if (name == null) {
                VariantLookupElementInfo.$$$reportNull$$$0(0);
            }
            if (priority == null) {
                VariantLookupElementInfo.$$$reportNull$$$0(1);
            }
            if (matchType == null) {
                VariantLookupElementInfo.$$$reportNull$$$0(2);
            }
            super(element, name, priority, matchType, typeSubstitutor);
        }

        @Override
        @NotNull
        public JSLookupElementInfoImpl withNewPriority(@NotNull JSLookupPriority priority) {
            if (priority == null) {
                VariantLookupElementInfo.$$$reportNull$$$0(3);
            }
            return new VariantLookupElementInfo(this.myElement, this.myName, priority, this.myMatchType, this.myTypeSubstitutor);
        }

        @Override
        public int compareTo(@Nullable PsiElement element, @NotNull JSLookupPriority priority, @Nullable BaseJSSymbolProcessor.MatchType matchType, @Nullable PsiElement context) {
            int result2;
            if (priority == null) {
                VariantLookupElementInfo.$$$reportNull$$$0(4);
            }
            if ((result2 = super.compareTo(element, priority, matchType, context)) != 0) {
                return result2;
            }
            return this.compareFixedPriority(element, priority, context);
        }

        private int compareFixedPriority(@Nullable PsiElement element, @NotNull JSLookupPriority priority, @Nullable PsiElement context) {
            if (priority == null) {
                VariantLookupElementInfo.$$$reportNull$$$0(5);
            }
            int itemPriority = priority.getPriorityValue();
            int itemProximity = priority.getProximityValue();
            int storedItemPriority = this.myPriority.getPriorityValue();
            int storedItemProximity = this.myPriority.getProximityValue();
            boolean currentIsProperty = VariantLookupElementInfo.isPropertyWithFunctionInitializer(element);
            boolean storedIsProperty = VariantLookupElementInfo.isPropertyWithFunctionInitializer(this.myElement);
            if (currentIsProperty && !storedIsProperty) {
                --storedItemPriority;
            } else if (!currentIsProperty && storedIsProperty) {
                --itemPriority;
            }
            if (context != null && itemPriority == storedItemPriority && itemProximity == storedItemProximity && !this.isPartial()) {
                EnumSet<JSTaggedResolveResult.ResolveResultTag> itemTags = EnumSet.noneOf(JSTaggedResolveResult.ResolveResultTag.class);
                BaseJSSymbolProcessor.addResolveResultTags(itemTags, element, context);
                EnumSet<JSTaggedResolveResult.ResolveResultTag> storedItemTags = EnumSet.noneOf(JSTaggedResolveResult.ResolveResultTag.class);
                BaseJSSymbolProcessor.addResolveResultTags(storedItemTags, this.myElement, context);
                itemPriority -= JSTaggedResolveResult.comparePriorities(itemTags, storedItemTags);
            }
            return storedItemPriority - itemPriority;
        }

        private static boolean isPropertyWithFunctionInitializer(PsiElement lookupItemElement) {
            return lookupItemElement instanceof JSProperty && ((JSProperty)lookupItemElement).tryGetFunctionInitializer() != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "priority";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/completion/JSVariantsProcessorMerger$VariantLookupElementInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withNewPriority";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareFixedPriority";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class SimpleMergeInfo
    implements JSLookupElementInfo {
        private final String myName;
        private final JSLookupPriority myPriority;

        private SimpleMergeInfo(@NotNull String name, @NotNull JSLookupPriority priority) {
            if (name == null) {
                SimpleMergeInfo.$$$reportNull$$$0(0);
            }
            if (priority == null) {
                SimpleMergeInfo.$$$reportNull$$$0(1);
            }
            this.myName = name;
            this.myPriority = priority;
        }

        @Override
        @Nullable
        public PsiElement getElement() {
            return null;
        }

        @Override
        @NotNull
        public JSLookupPriority getPriority() {
            JSLookupPriority jSLookupPriority = this.myPriority;
            if (jSLookupPriority == null) {
                SimpleMergeInfo.$$$reportNull$$$0(2);
            }
            return jSLookupPriority;
        }

        @Override
        @NotNull
        public JSLookupElementInfo withNewPriority(@NotNull JSLookupPriority priority) {
            if (priority == null) {
                SimpleMergeInfo.$$$reportNull$$$0(3);
            }
            return new SimpleMergeInfo(this.myName, priority);
        }

        @Override
        public boolean isPartial() {
            return true;
        }

        @Override
        public LookupElement toLookupElement() {
            LookupElementBuilder element = LookupElementBuilder.create((String)this.myName).withIcon(PlatformIcons.PROPERTY_ICON);
            return JSCompletionUtil.withJSLookupPriority((LookupElement)element, this.myPriority);
        }

        @Override
        public int compareTo(@Nullable PsiElement element, @NotNull JSLookupPriority priority, @Nullable BaseJSSymbolProcessor.MatchType matchType, @Nullable PsiElement context) {
            if (priority == null) {
                SimpleMergeInfo.$$$reportNull$$$0(4);
            }
            return JSLookupElementInfo.comparePriority(this.myPriority, priority);
        }

        @Override
        @NotNull
        public JSLookupElementInfo.FunctionType getFunctionType() {
            JSLookupElementInfo.FunctionType functionType = JSLookupElementInfo.FunctionType.NOT_FUNCTION;
            if (functionType == null) {
                SimpleMergeInfo.$$$reportNull$$$0(5);
            }
            return functionType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "priority";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/completion/JSVariantsProcessorMerger$SimpleMergeInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/completion/JSVariantsProcessorMerger$SimpleMergeInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPriority";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFunctionType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "withNewPriority";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

