/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.JSSwitchBranchesProcessor;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSSwitchCasesCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        PsiElement statementParent;
        PsiElement statement;
        if (parameters == null) {
            JSSwitchCasesCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JSSwitchCasesCompletionContributor.$$$reportNull$$$0(1);
        }
        super.fillCompletionVariants(parameters, result2);
        PsiElement position = parameters.getPosition();
        PsiElement parent = position.getParent();
        if (parent instanceof JSCaseClause && parent.getFirstChild() instanceof PsiErrorElement) {
            JSSwitchStatement statement2 = ((JSCaseClause)parent).getSwitchStatement();
            if (statement2 == null) {
                return;
            }
            JSSwitchCasesCompletionContributor.addVariants(result2, statement2);
        } else if (parent instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getQualifier() == null && (statement = parent.getParent()) instanceof JSExpressionStatement && (statementParent = statement.getParent()) instanceof JSCaseClause && parent.getTextOffset() == statement.getTextOffset()) {
            JSSwitchStatement switchStatement = ((JSCaseClause)statementParent).getSwitchStatement();
            if (switchStatement == null) {
                return;
            }
            JSSwitchCasesCompletionContributor.addVariants(result2, switchStatement);
        }
    }

    private static void addVariants(@NotNull CompletionResultSet result2, JSSwitchStatement statement) {
        if (result2 == null) {
            JSSwitchCasesCompletionContributor.$$$reportNull$$$0(2);
        }
        List<Pair<Integer, String>> variants = JSSwitchBranchesProcessor.getAllCaseVariants(JSSwitchBranchesProcessor.findTypeForCases(statement), JSSwitchBranchesProcessor.getExistingVariants(statement), JSCodeStyleSettings.getQuote((PsiElement)statement));
        for (Pair<Integer, String> variant : variants) {
            if ((Integer)variant.first != -1) continue;
            result2.addElement(JSCompletionUtil.withJSLookupPriority((LookupElement)LookupElementBuilder.create((String)("case " + (String)variant.second + ":")).withBoldness(true).withInsertHandler((context, item) -> {
                PsiElement element = context.getFile().findElementAt(context.getStartOffset());
                JSCaseClause clause = (JSCaseClause)PsiTreeUtil.getParentOfType((PsiElement)element, JSCaseClause.class);
                if (clause != null) {
                    FormatFixer.create((PsiElement)clause, FormatFixer.Mode.Reformat).fixFormat();
                }
            }), JSLookupPriority.SMART_KEYWORDS_PRIORITY));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/completion/JSSwitchCasesCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addVariants";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

