/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.gulp.GulpUtil;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfiguration;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfigurationEditor;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpTasksFetchSettingsDialog
extends DialogWrapper {
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final RawCommandLineEditor myNodeOptionsEditor;
    private final NodePackageField myGulpPackageField;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVarsComponent;
    private final JPanel myPanel;
    private final Project myProject;

    protected GulpTasksFetchSettingsDialog(@NotNull Project project, @Nullable VirtualFile contextGulpfile) {
        if (project == null) {
            GulpTasksFetchSettingsDialog.$$$reportNull$$$0(0);
        }
        super(project, false);
        this.myProject = project;
        this.setTitle("Gulp Settings");
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.myNodeOptionsEditor = GulpRunConfigurationEditor.createNodeOptionsEditor();
        this.myGulpPackageField = new NodePackageField(this.myNodeInterpreterField, GulpUtil.GULP, () -> contextGulpfile);
        this.myEnvVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.myPanel = FormBuilder.createFormBuilder().setAlignLabelOnRight(false).setHorizontalGap(10).setVerticalGap(4).addLabeledComponent(JavaScriptBundle.message((String)"gulp.rc.nodeInterpreter.label", (Object[])new Object[0]), (JComponent)((Object)this.myNodeInterpreterField)).addLabeledComponent(JavaScriptBundle.message((String)"gulp.rc.nodeOptions.label", (Object[])new Object[0]), (JComponent)this.myNodeOptionsEditor).addLabeledComponent(JavaScriptBundle.message((String)"gulp.rc.gulpPackage.label", (Object[])new Object[0]), (JComponent)((Object)this.myGulpPackageField)).addLabeledComponent(JavaScriptBundle.message((String)"gulp.rc.environmentVariables.label", (Object[])new Object[0]), (JComponent)this.myEnvVarsComponent).addComponentFillVertically((JComponent)new JPanel(), 0).getPanel();
        GulpRunSettings runSettings = GulpRunConfiguration.getTemplateRunSettings(project);
        NodeJsInterpreterRef interpreterRef = runSettings.getInterpreterRef();
        NodePackage gulpPackage = GulpUtil.getGulpPackage(project, interpreterRef.resolve(project), contextGulpfile);
        this.myNodeInterpreterField.setInterpreterRef(interpreterRef);
        this.myNodeOptionsEditor.setText(runSettings.getNodeOptions());
        this.myEnvVarsComponent.setData(runSettings.getEnvData());
        this.myGulpPackageField.setSelected(gulpPackage);
        this.configurePreferredWidth();
        this.init();
    }

    private void configurePreferredWidth() {
        this.myNodeInterpreterField.setPreferredWidthToFitText();
        this.myGulpPackageField.setPreferredWidthToFitText();
        int prefWidth = Math.max(this.myNodeInterpreterField.getPreferredSize().width, this.myGulpPackageField.getPreferredSize().width);
        int minFieldWidth = JBUIScale.scale((int)300);
        if (prefWidth < minFieldWidth) {
            SwingHelper.setPreferredWidth((Component)((Object)this.myNodeInterpreterField), (int)minFieldWidth);
        }
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String interpreterError = NodeInterpreterUtil.validateAndGetErrorMessage(this.myNodeInterpreterField.getInterpreter());
        if (interpreterError != null) {
            return new ValidationInfo(interpreterError, (JComponent)((Object)this.myNodeInterpreterField));
        }
        String gulpPackageError = this.myGulpPackageField.getSelected().getErrorMessage(GulpUtil.GULP.getPackageNames().get(0));
        if (gulpPackageError != null) {
            return new ValidationInfo(gulpPackageError, this.myGulpPackageField.getEditorComponent());
        }
        return null;
    }

    protected void doOKAction() {
        this.apply();
        super.doOKAction();
    }

    private void apply() {
        GulpUtil.setGulpPackage(this.myProject, this.myGulpPackageField.getSelected());
        GulpRunSettings runSettings = GulpRunConfiguration.getTemplateRunSettings(this.myProject);
        GulpRunSettings.Builder builder = new GulpRunSettings.Builder(runSettings);
        builder.setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef());
        builder.setNodeOptions(this.myNodeOptionsEditor.getText());
        builder.setEnvData(this.myEnvVarsComponent.getData());
        GulpRunConfiguration.setTemplateRunSettings(this.myProject, builder.build());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpTasksFetchSettingsDialog", "<init>"));
    }
}

