/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.google.common.io.Files;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.ide.util.projectWizard.ModuleNameLocationSettings;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadService;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadableInterpreterType;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.boilerplate.NpxPackageDescriptor;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.JSLinterGuesser;
import com.intellij.lang.javascript.modules.ConsoleProgress;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.platform.ProjectTemplate;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NpmPackageProjectGenerator
extends WebProjectTemplate<Settings>
implements ProjectTemplate {
    private static final String ID = "none";
    private static final Logger LOG = Logger.getInstance(NpmPackageProjectGenerator.class);
    private static final Key<Boolean> GENERATING = Key.create((String)(NpmPackageProjectGenerator.class.getSimpleName() + ".generating"));
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Project generator", NotificationDisplayType.BALLOON, true);

    protected abstract Filter @NotNull [] filters(@NotNull Project var1, @NotNull VirtualFile var2);

    @Deprecated
    @NotNull
    protected String executable(String path) {
        String string = this.executable(new NodePackage(path));
        if (string == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected String executable(@NotNull NodePackage pkg) {
        File file2;
        if (pkg == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(1);
        }
        return (file2 = pkg.findBinFile()) != null ? file2.getAbsolutePath() : "";
    }

    protected abstract String @NotNull [] generatorArgs(@NotNull Project var1, @NotNull VirtualFile var2);

    protected abstract void customizeModule(@NotNull VirtualFile var1, ContentEntry var2);

    @NotNull
    protected abstract String packageName();

    @NotNull
    protected abstract String presentablePackageName();

    @NotNull
    protected List<NpxPackageDescriptor.NpxCommand> getNpxCommands() {
        List<NpxPackageDescriptor.NpxCommand> list2 = Collections.emptyList();
        if (list2 == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(2);
        }
        return list2;
    }

    private void generateApp(@NotNull NodeJsInterpreter node, @NotNull Settings settings, @NotNull VirtualFile baseDir, @NotNull Project project) throws ExecutionException {
        if (node == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(4);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(5);
        }
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(6);
        }
        File workingDir = this.workingDir(settings, baseDir);
        ProcessHandler processHandler = NpmPackageProjectGenerator.generate(node, settings.myPackage, (Function<? super NodePackage, String>)((Function)pkg -> this.executable((NodePackage)pkg)), baseDir, workingDir, project, this.postInstall(project, baseDir, workingDir), "Generating " + baseDir.getName(), this.filters(project, baseDir), this.generatorArgs(project, baseDir, settings));
        this.onProcessHandlerCreated(processHandler);
    }

    protected void onProcessHandlerCreated(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(7);
        }
    }

    protected String[] generatorArgs(Project project, VirtualFile dir, Settings settings) {
        return this.generatorArgs(project, dir);
    }

    @Deprecated
    @NotNull
    protected Runnable postInstall(@NotNull NodeJsLocalInterpreter node, @NotNull Project project, @NotNull VirtualFile baseDir, File workingDir) {
        if (node == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(8);
        }
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(9);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(10);
        }
        Runnable runnable = this.postInstall(project, baseDir, workingDir);
        if (runnable == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(11);
        }
        return runnable;
    }

    @NotNull
    protected Runnable postInstall(@NotNull Project project, @NotNull VirtualFile baseDir, File workingDir) {
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(12);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(13);
        }
        Runnable runnable = () -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (this.generateInTemp()) {
                try {
                    ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeStarted(project, "copying files");
                    FileUtil.copyDir((File)new File(workingDir, baseDir.getName()), (File)VfsUtilCore.virtualToIoFile((VirtualFile)baseDir));
                    VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{baseDir});
                }
                catch (IOException e) {
                    throw new Error(e);
                }
                finally {
                    ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeCompleted(project);
                }
            }
            if (project.isDisposed()) {
                return;
            }
            DumbService.getInstance((Project)project).runWhenSmart(() -> this.onGettingSmartAfterProjectGeneration(project, baseDir));
        });
        if (runnable == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(14);
        }
        return runnable;
    }

    protected void onGettingSmartAfterProjectGeneration(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(15);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(16);
        }
        NpmPackageProjectGenerator.initBuildfiles(project);
        JSLinterGuesser.guessLinters(project, true);
    }

    private static void initBuildfiles(@NotNull Project project) {
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(17);
        }
        NpmScriptsService instance = NpmScriptsService.getInstance();
        List<VirtualFile> buildfiles = instance.detectAllBuildfiles(project);
        for (VirtualFile buildfile : buildfiles) {
            instance.getFileManager(project).addBuildfile(buildfile);
        }
        instance.getToolWindowManager(project).setAvailable();
    }

    @Deprecated
    public static void generate(@NotNull NodeJsLocalInterpreter node, @NotNull String path, @NotNull VirtualFile baseDir, @NotNull File workingDir, @NotNull Project project, @Nullable Runnable callback, Filter @NotNull [] filters, String ... args) throws ExecutionException {
        VirtualFile file2;
        if (node == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(18);
        }
        if (path == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(19);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(20);
        }
        if (workingDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(21);
        }
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(22);
        }
        if (filters == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(23);
        }
        VirtualFile packageJson = (file2 = LocalFileSystem.getInstance().findFileByPath(path)) != null ? PackageJsonUtil.findUpPackageJson(file2) : null;
        VirtualFile dir = packageJson != null ? packageJson.getParent() : null;
        NodePackage pkg = dir != null ? new NodePackage(dir.getPath()) : new NodePackage(path);
        NpmPackageProjectGenerator.generate((NodeJsInterpreter)node, pkg, (Function<? super NodePackage, String>)((Function)p -> path), baseDir, workingDir, project, callback, filters, args);
    }

    @Deprecated
    @NotNull
    public static ProcessHandler generate(@NotNull NodeJsInterpreter node, @NotNull NodePackage pkg, @NotNull Function<? super NodePackage, String> binFilePathProvider, @NotNull VirtualFile baseDir, @NotNull File workingDir, @NotNull Project project, @Nullable Runnable callback, Filter @NotNull [] filters, String ... args) throws ExecutionException {
        if (node == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(24);
        }
        if (pkg == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(25);
        }
        if (binFilePathProvider == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(26);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(27);
        }
        if (workingDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(28);
        }
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(29);
        }
        if (filters == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(30);
        }
        return NpmPackageProjectGenerator.generate(node, pkg, binFilePathProvider, baseDir, workingDir, project, callback, "Generating " + baseDir.getName(), filters, args);
    }

    @NotNull
    public static ProcessHandler generate(@NotNull NodeJsInterpreter node, @NotNull NodePackage pkg, @NotNull Function<? super NodePackage, String> binFilePathProvider, final @NotNull VirtualFile baseDir, @NotNull File workingDir, @NotNull Project project, @Nullable Runnable callback, @NotNull String title, Filter @NotNull [] filters, String ... args) throws ExecutionException {
        if (node == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(31);
        }
        if (pkg == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(32);
        }
        if (binFilePathProvider == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(33);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(34);
        }
        if (workingDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(35);
        }
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(36);
        }
        if (title == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(37);
        }
        if (filters == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(38);
        }
        Runnable done = PackageJsonDependenciesExternalUpdateManager.getInstance(project).externalUpdateStarted(null, null);
        GENERATING.set((UserDataHolder)project, (Object)Boolean.TRUE);
        NodeCommandLineConfigurator configurator = NodeCommandLineConfigurator.find(node);
        boolean useConsoleViewImpl = Boolean.getBoolean("npm.project.generators.ConsoleViewImpl");
        GeneralCommandLine commandLine = NodeCommandLineUtil.createCommandLine(!useConsoleViewImpl);
        ArrayList<Object> arguments = new ArrayList<Object>();
        if (pkg instanceof NpxPackageDescriptor.NpxNodePackage) {
            arguments.addAll(((NpxPackageDescriptor.NpxNodePackage)pkg).getArguments(node));
        } else {
            arguments.add(binFilePathProvider.fun((Object)pkg));
        }
        ContainerUtil.addAll(arguments, (Object[])args);
        commandLine.addParameters(arguments);
        commandLine.setWorkDirectory(workingDir.getPath());
        commandLine.setCharset(StandardCharsets.UTF_8);
        NodeCommandLineUtil.configureUsefulEnvironment(commandLine);
        if (node instanceof NodeJsLocalInterpreter) {
            String bin = PathUtil.getParentPath((String)((NodeJsLocalInterpreter)node).getInterpreterSystemDependentPath());
            String path = (String)commandLine.getParentEnvironment().get("PATH");
            path = StringUtil.isEmpty((String)path) ? bin : bin + File.pathSeparatorChar + path;
            commandLine.getEnvironment().put("PATH", path);
        }
        configurator.configure(commandLine);
        OSProcessHandler handler = NodeCommandLineUtil.createProcessHandler(commandLine, false);
        ConsoleView console = NodeCommandLineUtil.createConsole((ProcessHandler)handler, project, false);
        for (Filter filter : filters) {
            console.addMessageFilter(filter);
        }
        console.attachToProcess((ProcessHandler)handler);
        ConsoleProgress.install(console, (ProcessHandler)handler);
        ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeStarted(project, "project generation");
        handler.addProcessListener((ProcessListener)new ProcessAdapter((ProcessHandler)handler, done, project, callback){
            final /* synthetic */ ProcessHandler val$handler;
            final /* synthetic */ Runnable val$done;
            final /* synthetic */ Project val$project;
            final /* synthetic */ Runnable val$callback;
            {
                this.val$handler = processHandler;
                this.val$done = runnable;
                this.val$project = project;
                this.val$callback = runnable2;
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                baseDir.refresh(false, true);
                baseDir.getChildren();
                this.val$handler.notifyTextAvailable("Done\n", ProcessOutputTypes.SYSTEM);
                this.val$done.run();
                GENERATING.set((UserDataHolder)this.val$project, null);
                if (this.val$callback != null) {
                    this.val$callback.run();
                }
                ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeCompleted(this.val$project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$1", "processTerminated"));
            }
        });
        Executor defaultExecutor = DefaultRunExecutor.getRunExecutorInstance();
        RunnerLayoutUi ui = RunnerLayoutUi.Factory.getInstance((Project)project).create(ID, title, title, (Disposable)project);
        Content consoleContent = ui.createContent(ID, console.getComponent(), title, null, console.getPreferredFocusableComponent());
        ui.addContent(consoleContent);
        RunContentDescriptor descriptor2 = new RunContentDescriptor((ExecutionConsole)console, (ProcessHandler)handler, console.getComponent(), title);
        descriptor2.setAutoFocusContent(true);
        RunContentManager.getInstance((Project)project).showRunContent(defaultExecutor, descriptor2);
        handler.startNotify();
        OSProcessHandler oSProcessHandler = handler;
        if (oSProcessHandler == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(39);
        }
        return oSProcessHandler;
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Settings settings, @NotNull Module module) {
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(40);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(41);
        }
        if (settings == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(42);
        }
        if (module == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(43);
        }
        NodeJsInterpreter interpreter = settings.myInterpreterRef.resolve(project);
        assert (interpreter != null);
        GENERATING.set((UserDataHolder)project, (Object)Boolean.TRUE);
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> NodeJsDownloadService.getInstance().ensureInstalled(null, interpreter, node -> {
            try {
                NodeJsInterpreterRef ref = node != interpreter ? NodeJsInterpreterRef.create(node) : settings.myInterpreterRef;
                NodeJsInterpreterManager.getInstance(project).setInterpreterRef(ref);
                this.generateApp((NodeJsInterpreter)node, settings, baseDir, project);
                ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                ContentEntry entry = MarkRootActionBase.findContentEntry((ModuleRootModel)model, (VirtualFile)baseDir);
                this.customizeModule(baseDir, entry);
                ApplicationManager.getApplication().runWriteAction(() -> {
                    model.commit();
                    project.save();
                });
            }
            catch (ExecutionException e) {
                NOTIFICATION_GROUP.createNotification("Cannot generate " + this.getName(), StringUtil.notNullize((String)ExceptionUtil.getMessage((Throwable)e)), NotificationType.ERROR, null).notify(project);
                LOG.warn((Throwable)e);
            }
        }));
    }

    @NotNull
    public ProjectGeneratorPeer<Settings> createPeer() {
        return new NpmPackageGeneratorPeer();
    }

    @NotNull
    protected File workingDir(Settings settings, @NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(44);
        }
        if (this.generateInTemp()) {
            File file2 = Files.createTempDir();
            if (file2 == null) {
                NpmPackageProjectGenerator.$$$reportNull$$$0(45);
            }
            return file2;
        }
        File file3 = VfsUtilCore.virtualToIoFile((VirtualFile)baseDir);
        if (file3 == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(46);
        }
        return file3;
    }

    protected boolean generateInTemp() {
        return false;
    }

    protected String validateProjectPath(@NotNull String path) {
        if (path == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(47);
        }
        return null;
    }

    public static boolean isGenerating(@NotNull Project project) {
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(48);
        }
        return GENERATING.get((UserDataHolder)project) == Boolean.TRUE;
    }

    protected boolean allowDownload() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator";
                break;
            }
            case 1: 
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 3: 
            case 8: 
            case 18: 
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 27: 
            case 34: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 22: 
            case 29: 
            case 36: 
            case 40: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 19: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 21: 
            case 28: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 23: 
            case 30: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binFilePathProvider";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "executable";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNpxCommands";
                break;
            }
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "postInstall";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "workingDir";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "executable";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateApp";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onProcessHandlerCreated";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "postInstall";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onGettingSmartAfterProjectGeneration";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "initBuildfiles";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "workingDir";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "validateProjectPath";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isGenerating";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class NpmPackageGeneratorPeer
    implements ProjectGeneratorPeer<Settings> {
        private final JPanel myPanel;
        @NotNull
        private final List<String> myPackageNames;
        @NotNull
        private final String myPresentablePackageName;
        @NotNull
        private final Convertor<String, String> myValidator;
        private NodeJsInterpreterField myInterpreterField;
        private NodePackageField myPackageField;
        private TextAccessor myLocation;

        public NpmPackageGeneratorPeer() {
            this.myPackageNames = Collections.singletonList(NpmPackageProjectGenerator.this.packageName());
            this.myPresentablePackageName = NpmPackageProjectGenerator.this.presentablePackageName();
            this.myValidator = path -> NpmPackageProjectGenerator.this.validateProjectPath((String)path);
            this.myPanel = this.createPanel();
        }

        protected NodePackageField getPackageField() {
            return this.myPackageField;
        }

        protected JPanel createPanel() {
            JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
            this.myInterpreterField = this.createAndInitInterpreterField(ProjectManager.getInstance().getDefaultProject());
            LabeledComponent component = LabeledComponent.create((JComponent)((Object)this.myInterpreterField), (String)NodeJsInterpreterField.getLabelTextForComponent());
            component.setLabelLocation("West");
            panel2.add((Component)component);
            this.myPackageField = this.createAndInitPackageField(this.myInterpreterField);
            component = LabeledComponent.create((JComponent)((Object)this.myPackageField), (String)this.myPresentablePackageName);
            component.setAnchor((JComponent)panel2.getComponent(0));
            component.setLabelLocation("West");
            panel2.add((Component)component);
            return panel2;
        }

        @NotNull
        private NodeJsInterpreterField createAndInitInterpreterField(Project project) {
            NodeJsDownloadableInterpreterType downloadableType = NodeJsDownloadableInterpreterType.getInstance();
            boolean withDownload = NpmPackageProjectGenerator.this.allowDownload() && downloadableType.isActive();
            NodeJsInterpreterField interpreter = new NodeJsInterpreterField(project, false, withDownload){

                @Override
                public boolean isDefaultProjectInterpreterField() {
                    return true;
                }
            };
            if (withDownload) {
                interpreter.setInterpreterRef(NodeJsInterpreterRef.create(downloadableType.getInterpreters().iterator().next()));
            } else {
                interpreter.setInterpreterRef(NodeJsInterpreterManager.getInstance(project).getInterpreterRef());
            }
            NodeJsInterpreterField nodeJsInterpreterField = interpreter;
            if (nodeJsInterpreterField == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(0);
            }
            return nodeJsInterpreterField;
        }

        @NotNull
        protected NodePackageField createAndInitPackageField(@NotNull NodeJsInterpreterField interpreterField) {
            NpxPackageDescriptor.NpxNodePackage npxPackage;
            if (interpreterField == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(1);
            }
            List<NpxPackageDescriptor.NpxCommand> npxCommands = NpmPackageProjectGenerator.this.getNpxCommands();
            NodePackageField packageField = new NodePackageField(this.myInterpreterField, new NpxPackageDescriptor(this.myPackageNames, npxCommands), null);
            NodeJsInterpreter interpreter = this.myInterpreterField.getInterpreter();
            NodePackage pkg = NodePackage.findPreferredPackage(this.myInterpreterField.getProject(), this.myPackageNames, interpreter);
            NpxPackageDescriptor.NpxCommand npxCommand = (NpxPackageDescriptor.NpxCommand)ContainerUtil.getFirstItem(npxCommands);
            if (npxCommand != null && (npxPackage = NpxPackageDescriptor.createIfAvailable(interpreter, npxCommand)) != null) {
                pkg = npxPackage;
            }
            packageField.setSelected(pkg);
            NodePackageField nodePackageField = packageField;
            if (nodePackageField == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(2);
            }
            return nodePackageField;
        }

        @NotNull
        public JComponent getComponent() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(3);
            }
            return jPanel;
        }

        public void buildUI(@NotNull SettingsStep settingsStep) {
            ModuleNameLocationSettings field;
            if (settingsStep == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(4);
            }
            if ((field = settingsStep.getModuleNameLocationSettings()) != null) {
                this.myLocation = new TextAccessor(){

                    public void setText(String text) {
                        field.setModuleName(text);
                    }

                    public String getText() {
                        return field.getModuleName();
                    }
                };
            }
            settingsStep.addSettingsField(NodeJsInterpreterField.getLabelTextForComponent(), (JComponent)((Object)this.myInterpreterField));
            settingsStep.addSettingsField(UIUtil.replaceMnemonicAmpersand((String)this.myPresentablePackageName), (JComponent)((Object)this.myPackageField));
        }

        @NotNull
        public Settings getSettings() {
            return new Settings(this.myInterpreterField.getInterpreterRef(), this.myPackageField.getSelectedRef(), this.myPackageField.getSelected());
        }

        @Nullable
        public ValidationInfo validate() {
            String validateMessage;
            NodeJsInterpreter interpreter = this.myInterpreterField.getInterpreter();
            if (interpreter == null) {
                return new ValidationInfo("Please specify Node.js interpreter", (JComponent)((Object)this.myInterpreterField));
            }
            String error = interpreter.validate(null);
            if (error != null) {
                return new ValidationInfo(error, (JComponent)((Object)this.myInterpreterField));
            }
            NodePackage pkg = this.myPackageField.getSelected();
            String pkgError = pkg instanceof NpxPackageDescriptor.NpxNodePackage ? ((NpxPackageDescriptor.NpxNodePackage)pkg).getErrorMessage(interpreter) : pkg.getErrorMessage(UIUtil.replaceMnemonicAmpersand((String)this.myPresentablePackageName));
            if (pkgError != null) {
                return new ValidationInfo(pkgError, (JComponent)((Object)this.myPackageField));
            }
            if (this.myLocation == null) {
                this.myLocation = this.findLocationField();
            }
            String string = validateMessage = this.myLocation != null ? (String)this.myValidator.convert((Object)this.myLocation.getText()) : null;
            if (validateMessage != null) {
                return new ValidationInfo(validateMessage);
            }
            return null;
        }

        public boolean isBackgroundJobRunning() {
            return false;
        }

        public void addSettingsListener(@NotNull ProjectGeneratorPeer.SettingsListener listener2) {
            if (listener2 == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(5);
            }
            this.myInterpreterField.addChangeListener(interpreter -> listener2.stateChanged(this.validate() == null));
            this.myPackageField.addSelectionListener((Consumer<NodePackage>)((Consumer)newPackage -> listener2.stateChanged(this.validate() == null)));
            listener2.stateChanged(this.validate() == null);
        }

        @Nullable
        private TextAccessor findLocationField() {
            if (this.myInterpreterField.getParent() == null || this.myInterpreterField.getParent().getParent() == null) {
                return null;
            }
            Container greatGrandparent = this.myInterpreterField.getParent().getParent().getParent();
            if (Optional.ofNullable(greatGrandparent).map(c -> (Container)ObjectUtils.tryCast((Object)c.getComponent(0), Container.class)).map(c -> c.getComponent(0)).map(c -> c.getClass().getName()).orElse("").startsWith(HideableDecorator.class.getName())) {
                return Optional.ofNullable(greatGrandparent).map(Component::getParent).map(c -> (Container)ObjectUtils.tryCast((Object)c.getComponent(0), Container.class)).map(c -> (LabeledComponent)ObjectUtils.tryCast((Object)c.getComponent(0), LabeledComponent.class)).map(c -> (TextAccessor)ObjectUtils.tryCast((Object)c.getComponent(), TextAccessor.class)).orElse(null);
            }
            return (TextAccessor)ObjectUtils.doIfCast((Object)this.myInterpreterField.getParent().getParent().getComponent(0), LabeledComponent.class, lc -> (TextAccessor)ObjectUtils.tryCast((Object)lc.getComponent(), TextAccessor.class));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$NpmPackageGeneratorPeer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreterField";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settingsStep";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAndInitInterpreterField";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$NpmPackageGeneratorPeer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAndInitPackageField";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createAndInitPackageField";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "buildUI";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addSettingsListener";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Settings
    extends UserDataHolderBase {
        public final NodeJsInterpreterRef myInterpreterRef;
        public final NodePackageRef myPackageRef;
        public final NodePackage myPackage;

        public Settings(@NotNull NodeJsInterpreterRef interpreterRef, @NotNull NodePackage pkg) {
            if (interpreterRef == null) {
                Settings.$$$reportNull$$$0(0);
            }
            if (pkg == null) {
                Settings.$$$reportNull$$$0(1);
            }
            this.myInterpreterRef = interpreterRef;
            this.myPackageRef = NodePackageRef.create(pkg);
            this.myPackage = pkg;
        }

        public Settings(@NotNull NodeJsInterpreterRef interpreterRef, @NotNull NodePackageRef pkgRef, @NotNull NodePackage pkg) {
            if (interpreterRef == null) {
                Settings.$$$reportNull$$$0(2);
            }
            if (pkgRef == null) {
                Settings.$$$reportNull$$$0(3);
            }
            if (pkg == null) {
                Settings.$$$reportNull$$$0(4);
            }
            this.myInterpreterRef = interpreterRef;
            this.myPackageRef = pkgRef;
            this.myPackage = pkg;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "interpreterRef";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pkg";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pkgRef";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$Settings";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

