/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.reference;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.lang.javascript.frameworks.modules.JSModuleReferenceBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NodeFileModulePsiReferenceBase
implements PsiReference,
JSModuleBaseReference {
    protected final PsiElement myPsiElement;
    protected final String myRequiredModuleName;
    private final int myOffset;

    public NodeFileModulePsiReferenceBase(@NotNull PsiElement literalOrModuleReferenceOwner, @NotNull String requiredModuleName, int offset) {
        if (literalOrModuleReferenceOwner == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(0);
        }
        if (requiredModuleName == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(1);
        }
        this.myPsiElement = literalOrModuleReferenceOwner;
        this.myRequiredModuleName = requiredModuleName;
        this.myOffset = offset;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myPsiElement;
        if (psiElement == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = TextRange.from((int)this.myOffset, (int)this.myRequiredModuleName.length());
        if (textRange == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    public PsiElement resolve() {
        ResolvedModuleInfo resolvedModuleInfo = this.resolveModule();
        if (resolvedModuleInfo == null) {
            return null;
        }
        VirtualFile resolvedVirtualFile = resolvedModuleInfo.getModuleMainFile();
        if (resolvedVirtualFile.isValid()) {
            return this.myPsiElement.getManager().findFile(resolvedVirtualFile);
        }
        return null;
    }

    @Nullable
    public final ResolvedModuleInfo resolveModule() {
        ResolvedModuleInfo module = this.doResolveModule();
        return module != null ? this.getCanonicalModuleInProject(module) : null;
    }

    @Nullable
    protected abstract ResolvedModuleInfo doResolveModule();

    @NotNull
    private ResolvedModuleInfo getCanonicalModuleInProject(@NotNull ResolvedModuleInfo info) {
        VirtualFile canonicalModule;
        String relativePath;
        VirtualFile canonicalRoot;
        VirtualFile root;
        if (info == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(4);
        }
        if (!(root = info.getModuleSourceRoot()).equals(canonicalRoot = JSModuleReferenceBase.getCanonicalPreferredFile(this.myPsiElement.getProject(), root)) && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)info.getModuleMainFile(), (VirtualFile)root)) != null && (canonicalModule = canonicalRoot.findFileByRelativePath(relativePath)) != null) {
            return new ResolvedModuleInfo(canonicalRoot, canonicalModule, info.getType());
        }
        ResolvedModuleInfo resolvedModuleInfo = info;
        if (resolvedModuleInfo == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(5);
        }
        return resolvedModuleInfo;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myRequiredModuleName;
        if (string == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(6);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newContent) throws IncorrectOperationException {
        if (newContent == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(7);
        }
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(8);
        }
        return psiElement;
    }

    public boolean isReferenceTo(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(9);
        }
        return this.myPsiElement.getManager().areElementsEquivalent(this.resolve(), psiElement);
    }

    public Object @NotNull [] getVariants() {
        VirtualFile requester = this.getContainingFile();
        CompletionModuleInfo[] modules = this.getModuleInfos(requester);
        Arrays.sort(modules, Comparator.comparing(CompletionModuleInfo::getName));
        ArrayList lookupElements = Lists.newArrayListWithCapacity((int)modules.length);
        for (CompletionModuleInfo module : modules) {
            String name = module.getName();
            if (name.startsWith("@types/")) continue;
            lookupElements.add(NodeFileModulePsiReferenceBase.createLookupElement(requester, module, this.getElement().getProject()));
        }
        Object[] objectArray = lookupElements.toArray(LookupElement.EMPTY_ARRAY);
        if (objectArray == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(10);
        }
        return objectArray;
    }

    @NotNull
    public static LookupElement createLookupElement(@Nullable VirtualFile context, @NotNull CompletionModuleInfo module, @NotNull Project project) {
        if (module == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(11);
        }
        if (project == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(12);
        }
        String lookupObject = module.getName();
        PsiFileSystemItem fileOrDir = PsiUtilCore.findFileSystemItem((Project)project, (VirtualFile)module.getVirtualFile());
        if (fileOrDir != null) {
            lookupObject = fileOrDir;
        }
        LookupElementBuilder element = LookupElementBuilder.create((Object)lookupObject, (String)module.getName()).withIcon(AllIcons.Nodes.Folder);
        String typeText = null;
        if (module.getType() == ModuleType.CORE_MODULE) {
            typeText = "Node.js core module";
        } else {
            String presentablePath = module.getPresentablePath(context);
            if (presentablePath != null) {
                typeText = presentablePath;
            }
        }
        LookupElementBuilder lookupElementBuilder = element = element.withTypeText(typeText, true);
        if (lookupElementBuilder == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(13);
        }
        return lookupElementBuilder;
    }

    protected abstract CompletionModuleInfo @NotNull [] getModuleInfos(VirtualFile var1);

    @Nullable
    public VirtualFile getContainingFile() {
        VirtualFile vFile;
        PsiFile psiFile = this.getElement().getContainingFile();
        if (psiFile != null && (vFile = (psiFile = psiFile.getOriginalFile()).getVirtualFile()) != null && vFile.isValid()) {
            return vFile;
        }
        return null;
    }

    @NotNull
    public String getRequiredModuleName() {
        String string = this.myRequiredModuleName;
        if (string == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(14);
        }
        return string;
    }

    public boolean isSoft() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalOrModuleReferenceOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredModuleName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/reference/NodeFileModulePsiReferenceBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContent";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/reference/NodeFileModulePsiReferenceBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalModuleInProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalModuleInProject";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

