/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeModuleDirectorySearchProcessor {
    public static final NodeModuleDirectorySearchProcessor PROCESSOR = new NodeModuleDirectorySearchProcessor();
    public static final String INDEX_NAME = "index";

    @Nullable
    public ResolvedModuleInfo doResolveModule(@Nullable VirtualFile moduleSourceRoot, @NotNull ModuleType type, @NotNull VirtualFile baseDir, @NotNull String requiredModuleName, boolean resolveDirectory, boolean respectPackageJson) {
        String childNamePrefix;
        VirtualFile parentDir;
        int lastSlashInd;
        if (type == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(1);
        }
        if (requiredModuleName == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(2);
        }
        if ((lastSlashInd = (requiredModuleName = FileUtil.toSystemIndependentName((String)requiredModuleName)).lastIndexOf(47)) == -1) {
            parentDir = baseDir;
            childNamePrefix = requiredModuleName;
        } else {
            if (lastSlashInd == 0 || lastSlashInd == requiredModuleName.length() - 1) {
                return null;
            }
            parentDir = baseDir.findFileByRelativePath(requiredModuleName.substring(0, lastSlashInd));
            if (parentDir == null) {
                return null;
            }
            childNamePrefix = requiredModuleName.substring(lastSlashInd + 1);
        }
        boolean directory = false;
        VirtualFile fileOrDir = null;
        if (resolveDirectory && (fileOrDir = childNamePrefix.equals("..") ? parentDir.getParent() : (childNamePrefix.equals(".") ? parentDir : parentDir.findChild(childNamePrefix))) != null && fileOrDir.isValid()) {
            if (fileOrDir.isDirectory()) {
                directory = true;
            } else {
                if (moduleSourceRoot != null) {
                    return new ResolvedModuleInfo(moduleSourceRoot, fileOrDir, type);
                }
                return new ResolvedModuleInfo(fileOrDir, type);
            }
        }
        for (String ext : this.getExtensions()) {
            VirtualFile childFile = parentDir.findChild(childNamePrefix + ext);
            if (childFile == null || !NodeModuleSearchUtil.isFile(childFile)) continue;
            if (moduleSourceRoot != null) {
                return new ResolvedModuleInfo(moduleSourceRoot, childFile, type);
            }
            return new ResolvedModuleInfo(childFile, type);
        }
        if (directory && fileOrDir != null) {
            return this.loadDirectory(moduleSourceRoot, fileOrDir, type, respectPackageJson);
        }
        return null;
    }

    protected String[] getExtensions() {
        return NodeModuleSearchUtil.FILE_EXTENSIONS_IN_ORDER;
    }

    @Nullable
    public ResolvedModuleInfo loadDirectory(@Nullable VirtualFile moduleSourceRoot, @NotNull VirtualFile dir, @NotNull ModuleType type, boolean respectPackageJson) {
        PackageJsonData data;
        String main;
        VirtualFile packageJson;
        if (dir == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(3);
        }
        if (type == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(4);
        }
        if (moduleSourceRoot == null) {
            moduleSourceRoot = dir;
        }
        if (respectPackageJson && (packageJson = dir.findChild("package.json")) != null && (main = this.findPathInPackageJson(data = PackageJsonUtil.getOrCreateData(packageJson))) != null) {
            ResolvedModuleInfo resolvedMain;
            String subPath = StringUtil.trimEnd((String)main, (char)'/');
            boolean resolveDirectory = INDEX_NAME.equals(subPath);
            ResolvedModuleInfo info = this.doResolveModule(moduleSourceRoot, type, dir, INDEX_NAME, resolveDirectory, false);
            if (!data.hasTypings() && info != null && "index.d.ts".equals(info.getModuleMainFile().getName())) {
                return info;
            }
            if (!INDEX_NAME.equals(subPath) && (resolvedMain = this.doResolveModule(moduleSourceRoot, type, dir, subPath, true, false)) != null) {
                return resolvedMain;
            }
            return info;
        }
        return this.doResolveModule(moduleSourceRoot, type, dir, INDEX_NAME, false, false);
    }

    protected String findPathInPackageJson(@NotNull PackageJsonData data) {
        if (data == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(5);
        }
        return data.getDefaultMain();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredModuleName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/NodeModuleDirectorySearchProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doResolveModule";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "loadDirectory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findPathInPackageJson";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

