/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommandLineInspectionProgressReporter;
import com.intellij.codeInspection.CommandLineInspectionProjectConfigurator;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadService;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadableInterpreter;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadableInterpreterType;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.ConsoleCommandLineFolder;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.modules.InstallNodeLocalDependenciesAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class NodeJsCommandLineInspectionProjectConfigurator
implements CommandLineInspectionProjectConfigurator {
    public boolean isApplicable(@NotNull Path projectPath, @NotNull CommandLineInspectionProgressReporter logger) {
        if (projectPath == null) {
            NodeJsCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(0);
        }
        if (logger == null) {
            NodeJsCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(1);
        }
        return true;
    }

    public void configureEnvironment(@NotNull Path projectPath, @NotNull CommandLineInspectionProgressReporter logger) {
        List<NodeJsDownloadableInterpreter> interpreters;
        if (projectPath == null) {
            NodeJsCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(2);
        }
        if (logger == null) {
            NodeJsCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(3);
        }
        if ((interpreters = NodeJsDownloadableInterpreterType.getInstance().getInterpretersIfActive()).size() > 0) {
            NodeJsDownloadService.install(interpreters.get(0), null);
        }
    }

    public void configureProject(@NotNull Project project, @NotNull AnalysisScope scope, final @NotNull CommandLineInspectionProgressReporter logger) {
        if (project == null) {
            NodeJsCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            NodeJsCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(5);
        }
        if (logger == null) {
            NodeJsCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(6);
        }
        Set<VirtualFile> packageJsons = PackageJsonFileManager.getInstance(project).getValidPackageJsonFiles();
        for (VirtualFile packageJson : packageJsons) {
            try {
                NodeCommandLineConfigurator configurer = NodeCommandLineConfigurator.find(NodeJsInterpreterManager.getInstance(project).getInterpreterRef(), project);
                NodePackage pkg = NpmManager.getInstance(project).getPackageOrThrow();
                VirtualFile dir = packageJson.getParent();
                GeneralCommandLine commandLine = InstallNodeLocalDependenciesAction.createCommandLine(configurer, dir, pkg, NpmCommand.INSTALL, new ConsoleCommandLineFolder(new String[0]));
                OSProcessHandler processHandler = NodeCommandLineUtil.createProcessHandler(commandLine, true);
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        logger.reportMessage(3, event.getText());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "outputType";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/javascript/nodejs/NodeJsCommandLineInspectionProjectConfigurator$1";
                        objectArray[2] = "onTextAvailable";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                processHandler.startNotify();
                processHandler.waitFor();
                dir.refresh(false, true);
            }
            catch (ExecutionException e) {
                logger.reportError(e.getMessage());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/NodeJsCommandLineInspectionProjectConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "configureEnvironment";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "configureProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

