/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.auth;

import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.ssh.interaction.ConnectionOwnerFactory;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManagerBaseImpl;
import com.jetbrains.plugins.webDeployment.ui.auth.LoginDialog;
import gnu.trove.THashMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthHelper {
    private static final Logger LOG = Logger.getInstance(AuthHelper.class);
    private static final Map<AuthKey, Collection<AuthPair>> LOGIN_SERVERS = new THashMap();

    public static boolean ensureAuthSpecified(@Nullable Project project, @NotNull Deployable deployable, @NotNull Component component) {
        if (deployable == null) {
            AuthHelper.$$$reportNull$$$0(0);
        }
        if (component == null) {
            AuthHelper.$$$reportNull$$$0(1);
        }
        return AuthHelper.ensureAuthSpecified(project, deployable, true, ConnectionOwnerFactory.createConnectionOwner((Component)component));
    }

    public static boolean ensureAuthSpecified(@NotNull Deployable deployable, @Nullable Project project) {
        if (deployable == null) {
            AuthHelper.$$$reportNull$$$0(2);
        }
        boolean modal = ApplicationManager.getApplication().isDispatchThread();
        return AuthHelper.ensureAuthSpecified(project, deployable, true, (Factory<LoginDialog>)((Factory)() -> new LoginDialog(deployable, project, modal)), modal);
    }

    public static boolean ensureAuthSpecified(@Nullable Project project, @NotNull Deployable deployable, @NotNull ConnectionOwner connectionOwner) {
        if (deployable == null) {
            AuthHelper.$$$reportNull$$$0(3);
        }
        if (connectionOwner == null) {
            AuthHelper.$$$reportNull$$$0(4);
        }
        boolean modal = ApplicationManager.getApplication().isDispatchThread();
        return AuthHelper.ensureAuthSpecified(project, deployable, true, (Factory<LoginDialog>)((Factory)() -> LoginDialog.createInstance(deployable, connectionOwner, modal)), modal);
    }

    public static boolean ensureAuthSpecified(@Nullable Project project, @NotNull Deployable deployable, boolean applyCredentialsToPasswordSafe, @NotNull ConnectionOwner connectionOwner) {
        if (deployable == null) {
            AuthHelper.$$$reportNull$$$0(5);
        }
        if (connectionOwner == null) {
            AuthHelper.$$$reportNull$$$0(6);
        }
        boolean modal = ApplicationManager.getApplication().isDispatchThread();
        return AuthHelper.ensureAuthSpecified(project, deployable, applyCredentialsToPasswordSafe, (Factory<LoginDialog>)((Factory)() -> LoginDialog.createInstance(deployable, connectionOwner, modal)), modal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean ensureAuthSpecified(@Nullable Project project, Deployable deployable, boolean applyCredentialsToPasswordSafe, Factory<LoginDialog> dialog, boolean modal) {
        if (deployable.hasCredentials() && !AuthHelper.shouldReAuth(deployable)) {
            return true;
        }
        boolean needToShow = true;
        AuthPair resultPair = new AuthPair();
        AuthKey targetKey = new AuthKey(deployable, modal);
        if (targetKey.isDescriptive()) {
            Map<AuthKey, Collection<AuthPair>> map = LOGIN_SERVERS;
            synchronized (map) {
                Collection<AuthPair> refs = LOGIN_SERVERS.get(targetKey);
                if (refs == null) {
                    needToShow = true;
                    LOGIN_SERVERS.put(targetKey, new ArrayList());
                } else {
                    LOG.assertTrue(!modal);
                    needToShow = false;
                    refs.add(resultPair);
                    try {
                        Collection<AuthPair> pairs;
                        while ((pairs = LOGIN_SERVERS.get(targetKey)) != null && pairs.contains(resultPair)) {
                            LOGIN_SERVERS.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        LOG.warn("Undescriptive auth key for " + deployable);
        if (needToShow) {
            LOG.assertTrue(project != null || !deployable.isProjectLevel(), (Object)("Project '" + deployable.getName() + "' is project-level one. Please provide project."));
            Semaphore done = new Semaphore();
            Runnable runnable = () -> {
                LoginDialog d = (LoginDialog)((Object)((Object)dialog.create()));
                d.showAndGetResult().onSuccess(ok -> {
                    if (ok.booleanValue()) {
                        AuthHelper.noMoreReAuth(deployable);
                        resultPair.username = d.getUsername();
                        resultPair.password = d.getPassword();
                        resultPair.isRememberPassword = d.isRememberPassword();
                        LOG.assertTrue(!d.isRememberPassword() || d.getPassword() != null, (Object)"No password can't be saved");
                    }
                    if (targetKey.isDescriptive()) {
                        Map<AuthKey, Collection<AuthPair>> map = LOGIN_SERVERS;
                        synchronized (map) {
                            for (AuthPair pair : LOGIN_SERVERS.remove(targetKey)) {
                                pair.username = resultPair.username;
                                pair.password = resultPair.password;
                                pair.isRememberPassword = resultPair.isRememberPassword;
                            }
                            LOGIN_SERVERS.notifyAll();
                        }
                    }
                    if (!modal) {
                        done.up();
                    }
                });
            };
            if (!modal) {
                done.down();
                ApplicationManager.getApplication().invokeAndWait(runnable);
                done.waitFor();
            } else {
                runnable.run();
            }
        }
        if (!AuthHelper.checkAuthInfoIsEnough(deployable.getAuthType(), resultPair)) {
            return false;
        }
        deployable.setCredentials(new Credentials(resultPair.username, resultPair.password), !resultPair.isRememberPassword, applyCredentialsToPasswordSafe, false);
        return true;
    }

    private static boolean checkAuthInfoIsEnough(@NotNull AuthType authType, @NotNull AuthPair authPair) {
        if (authType == null) {
            AuthHelper.$$$reportNull$$$0(7);
        }
        if (authPair == null) {
            AuthHelper.$$$reportNull$$$0(8);
        }
        if (StringUtil.isEmptyOrSpaces((String)authPair.username)) {
            return false;
        }
        if (authType == AuthType.OPEN_SSH) {
            return true;
        }
        return authPair.isRememberPassword ? authPair.password != null : !StringUtil.isEmptyOrSpaces((String)authPair.password);
    }

    public static void setDeployableToReAuth(@NotNull Deployable deployable) {
        if (deployable == null) {
            AuthHelper.$$$reportNull$$$0(9);
        }
        WebServersConfigManagerBaseImpl.App.getInstance().setDeployableToReauth(deployable);
    }

    public static boolean shouldReAuth(Deployable deployable) {
        return WebServersConfigManagerBaseImpl.App.getInstance().shouldReauth(deployable);
    }

    public static void noMoreReAuth(Deployable deployable) {
        WebServersConfigManagerBaseImpl.App.getInstance().noMoreReauth(deployable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionOwner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authPair";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureAuthSpecified";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAuthInfoIsEnough";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setDeployableToReAuth";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class AuthKey {
        private final String myDeployableId;
        private final boolean myModal;

        private AuthKey(Deployable deployable, Boolean modal) {
            this.myDeployableId = deployable.getId();
            this.myModal = modal;
        }

        public boolean isDescriptive() {
            return !StringUtil.isEmptyOrSpaces((String)this.myDeployableId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuthKey key = (AuthKey)o;
            if (this.myModal != key.myModal) {
                return false;
            }
            return !(this.myDeployableId != null ? !this.myDeployableId.equals(key.myDeployableId) : key.myDeployableId != null);
        }

        public int hashCode() {
            int result = this.myDeployableId != null ? this.myDeployableId.hashCode() : 0;
            result = 31 * result + (this.myModal ? 1 : 0);
            return result;
        }
    }

    private static class AuthPair {
        public String username;
        public String password;
        public boolean isRememberPassword;

        private AuthPair() {
        }
    }
}

